/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.restapi.JacksonJsonMapper;
import com.yahoo.restapi.JacksonJsonResponse;
import com.yahoo.restapi.MessageResponse;
import com.yahoo.restapi.Path;
import com.yahoo.restapi.RestApi;
import com.yahoo.restapi.RestApiException;
import com.yahoo.restapi.SlimeJsonResponse;
import com.yahoo.restapi.UriBuilder;
import com.yahoo.slime.JsonParseException;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

class RestApiImpl
implements RestApi {
    private static final Logger log = Logger.getLogger(RestApiImpl.class.getName());
    private final Route defaultRoute;
    private final List<Route> routes;
    private final List<ExceptionMapperHolder<?>> exceptionMappers;
    private final List<ResponseMapperHolder<?>> responseMappers;
    private final List<RequestMapperHolder<?>> requestMappers;
    private final List<RestApi.Filter> filters;
    private final ObjectMapper jacksonJsonMapper;

    private RestApiImpl(RestApi.Builder builder) {
        BuilderImpl builderImpl = (BuilderImpl)builder;
        ObjectMapper jacksonJsonMapper = builderImpl.jacksonJsonMapper != null ? builderImpl.jacksonJsonMapper : JacksonJsonMapper.instance.copy();
        this.defaultRoute = builderImpl.defaultRoute != null ? builderImpl.defaultRoute : RestApiImpl.createDefaultRoute();
        this.routes = List.copyOf(builderImpl.routes);
        this.exceptionMappers = RestApiImpl.combineWithDefaultExceptionMappers(builderImpl.exceptionMappers, Boolean.TRUE.equals(builderImpl.disableDefaultExceptionMappers));
        this.responseMappers = RestApiImpl.combineWithDefaultResponseMappers(builderImpl.responseMappers, jacksonJsonMapper, Boolean.TRUE.equals(builderImpl.disableDefaultResponseMappers));
        this.requestMappers = RestApiImpl.combineWithDefaultRequestMappers(builderImpl.requestMappers, jacksonJsonMapper);
        this.filters = List.copyOf(builderImpl.filters);
        this.jacksonJsonMapper = jacksonJsonMapper;
    }

    @Override
    public HttpResponse handleRequest(HttpRequest request) {
        RequestContextImpl requestContext;
        Path pathMatcher = new Path(request.getUri());
        Route resolvedRoute = this.resolveRoute(pathMatcher);
        FilterContextImpl filterContext = this.createFilterContextRecursive(resolvedRoute, requestContext = new RequestContextImpl(request, pathMatcher, this.jacksonJsonMapper), this.filters, this.createFilterContextRecursive(resolvedRoute, requestContext, resolvedRoute.filters, null));
        if (filterContext != null) {
            return filterContext.executeFirst();
        }
        return this.dispatchToRoute(resolvedRoute, requestContext);
    }

    private HttpResponse dispatchToRoute(Route route, RequestContextImpl context) {
        Object responseEntity;
        Object requestEntity;
        HandlerHolder<?> resolvedHandler = this.resolveHandler(context, route);
        RequestMapperHolder<?> resolvedRequestMapper = this.resolveRequestMapper(resolvedHandler);
        try {
            requestEntity = resolvedRequestMapper.mapper.toRequestEntity(context).orElse(null);
        }
        catch (RuntimeException e) {
            return this.mapException(context, e);
        }
        try {
            responseEntity = resolvedHandler.executeHandler(context, requestEntity);
        }
        catch (RuntimeException e) {
            return this.mapException(context, e);
        }
        if (responseEntity == null) {
            throw new NullPointerException("Handler must return non-null value");
        }
        ResponseMapperHolder<?> resolvedResponseMapper = this.resolveResponseMapper(responseEntity);
        try {
            return resolvedResponseMapper.toHttpResponse(context, responseEntity);
        }
        catch (RuntimeException e) {
            return this.mapException(context, e);
        }
    }

    private HandlerHolder<?> resolveHandler(RequestContextImpl context, Route route) {
        HandlerHolder<?> resolvedHandler = route.handlerPerMethod.get((Object)context.request().getMethod());
        return resolvedHandler == null ? route.defaultHandler : resolvedHandler;
    }

    private RequestMapperHolder<?> resolveRequestMapper(HandlerHolder<?> resolvedHandler) {
        return this.requestMappers.stream().filter(holder -> resolvedHandler.type.isAssignableFrom(holder.type)).findFirst().orElseThrow(() -> new IllegalStateException("No mapper configured for " + resolvedHandler.type));
    }

    private ResponseMapperHolder<?> resolveResponseMapper(Object responseEntity) {
        return this.responseMappers.stream().filter(holder -> holder.type.isAssignableFrom(responseEntity.getClass())).findFirst().orElseThrow(() -> new IllegalStateException("No mapper configured for " + responseEntity.getClass()));
    }

    private HttpResponse mapException(RequestContextImpl context, RuntimeException e) {
        log.log(Level.FINE, e, e::getMessage);
        ExceptionMapperHolder mapper = this.exceptionMappers.stream().filter(holder -> holder.type.isAssignableFrom(e.getClass())).findFirst().orElseThrow(() -> e);
        return mapper.toResponse(context, e);
    }

    private Route resolveRoute(Path pathMatcher) {
        Route matchingRoute = this.routes.stream().filter(route -> pathMatcher.matches(route.pathPattern)).findFirst().orElse(null);
        if (matchingRoute != null) {
            return matchingRoute;
        }
        pathMatcher.matches(this.defaultRoute.pathPattern);
        return this.defaultRoute;
    }

    private FilterContextImpl createFilterContextRecursive(Route route, RequestContextImpl requestContext, List<RestApi.Filter> filters, FilterContextImpl previousContext) {
        FilterContextImpl filterContext = previousContext;
        ListIterator<RestApi.Filter> iterator = filters.listIterator(filters.size());
        while (iterator.hasPrevious()) {
            filterContext = new FilterContextImpl(route, iterator.previous(), requestContext, filterContext);
        }
        return filterContext;
    }

    private static Route createDefaultRoute() {
        RestApi.RouteBuilder routeBuilder = new RouteBuilderImpl("{*}").defaultHandler(context -> {
            throw new RestApiException.NotFoundException();
        });
        return ((RouteBuilderImpl)routeBuilder).build();
    }

    private static List<ExceptionMapperHolder<?>> combineWithDefaultExceptionMappers(List<ExceptionMapperHolder<?>> configuredExceptionMappers, boolean disableDefaultMappers) {
        ArrayList exceptionMappers = new ArrayList(configuredExceptionMappers);
        if (!disableDefaultMappers) {
            exceptionMappers.add(new ExceptionMapperHolder<RestApiException>(RestApiException.class, (context, exception) -> exception.response()));
        }
        return exceptionMappers;
    }

    private static List<ResponseMapperHolder<?>> combineWithDefaultResponseMappers(List<ResponseMapperHolder<?>> configuredResponseMappers, ObjectMapper jacksonJsonMapper, boolean disableDefaultMappers) {
        ArrayList responseMappers = new ArrayList(configuredResponseMappers);
        if (!disableDefaultMappers) {
            responseMappers.add(new ResponseMapperHolder<HttpResponse>(HttpResponse.class, (context, entity) -> entity));
            responseMappers.add(new ResponseMapperHolder<String>(String.class, (context, entity) -> new MessageResponse((String)entity)));
            responseMappers.add(new ResponseMapperHolder<Slime>(Slime.class, (context, entity) -> new SlimeJsonResponse((Slime)entity)));
            responseMappers.add(new ResponseMapperHolder<JsonNode>(JsonNode.class, (context, entity) -> new JacksonJsonResponse<JsonNode>(200, (JsonNode)entity, jacksonJsonMapper, true)));
        }
        return responseMappers;
    }

    private static List<RequestMapperHolder<?>> combineWithDefaultRequestMappers(List<RequestMapperHolder<?>> configuredRequestMappers, ObjectMapper jacksonJsonMapper) {
        ArrayList requestMappers = new ArrayList(configuredRequestMappers);
        requestMappers.add(new RequestMapperHolder<Slime>(Slime.class, RestApiImpl::toSlime));
        requestMappers.add(new RequestMapperHolder<JsonNode>(JsonNode.class, ctx -> RestApiImpl.toJsonNode(ctx, jacksonJsonMapper)));
        requestMappers.add(new RequestMapperHolder<String>(String.class, RestApiImpl::toString));
        requestMappers.add(new RequestMapperHolder<byte[]>(byte[].class, RestApiImpl::toByteArray));
        requestMappers.add(new RequestMapperHolder<InputStream>(InputStream.class, RestApiImpl::toInputStream));
        requestMappers.add(new RequestMapperHolder<Void>(Void.class, ctx -> Optional.empty()));
        return requestMappers;
    }

    private static Optional<InputStream> toInputStream(RestApi.RequestContext context) {
        return context.requestContent().map(RestApi.RequestContext.RequestContent::content);
    }

    private static Optional<byte[]> toByteArray(RestApi.RequestContext context) {
        InputStream in = RestApiImpl.toInputStream(context).orElse(null);
        if (in == null) {
            return Optional.empty();
        }
        return RestApiImpl.convertIoException(() -> Optional.of(in.readAllBytes()));
    }

    private static Optional<String> toString(RestApi.RequestContext context) {
        try {
            return RestApiImpl.toByteArray(context).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8));
        }
        catch (RuntimeException e) {
            throw new RestApiException.BadRequest("Failed parse request content as UTF-8: " + Exceptions.toMessageString((Throwable)e), e);
        }
    }

    private static Optional<JsonNode> toJsonNode(RestApi.RequestContext context, ObjectMapper jacksonJsonMapper) {
        if (log.isLoggable(Level.FINE)) {
            return RestApiImpl.toString(context).map(string -> {
                log.fine(() -> "Request content: " + string);
                return RestApiImpl.convertIoException("Failed to parse JSON", () -> jacksonJsonMapper.readTree(string));
            });
        }
        return RestApiImpl.toInputStream(context).map(in -> RestApiImpl.convertIoException("Invalid JSON", () -> jacksonJsonMapper.readTree(in)));
    }

    private static Optional<Slime> toSlime(RestApi.RequestContext context) {
        try {
            return RestApiImpl.toString(context).map(string -> {
                log.fine(() -> "Request content: " + string);
                return SlimeUtils.jsonToSlimeOrThrow((String)string);
            });
        }
        catch (JsonParseException e) {
            log.log(Level.FINE, e.getMessage(), e);
            throw new RestApiException.BadRequest("Invalid JSON: " + Exceptions.toMessageString((Throwable)e), e);
        }
    }

    private static <T> T convertIoException(String messagePrefix, SupplierThrowingIoException<T> supplier) {
        try {
            return supplier.get();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.getMessage(), e);
            throw new RestApiException.InternalServerError(messagePrefix + ": " + Exceptions.toMessageString((Throwable)e), e);
        }
    }

    private static <T> T convertIoException(SupplierThrowingIoException<T> supplier) {
        return RestApiImpl.convertIoException("Failed to read request content", supplier);
    }

    @FunctionalInterface
    private static interface SupplierThrowingIoException<T> {
        public T get() throws IOException;
    }

    private static class JacksonResponseMapper<ENTITY>
    implements RestApi.ResponseMapper<ENTITY> {
        private JacksonResponseMapper() {
        }

        @Override
        public HttpResponse toHttpResponse(RestApi.RequestContext context, ENTITY responseEntity) throws RestApiException {
            return new JacksonJsonResponse<ENTITY>(200, responseEntity, context.jacksonJsonMapper(), true);
        }
    }

    private static class JacksonRequestMapper<ENTITY>
    implements RestApi.RequestMapper<ENTITY> {
        private final Class<ENTITY> type;

        JacksonRequestMapper(Class<ENTITY> type) {
            this.type = type;
        }

        @Override
        public Optional<ENTITY> toRequestEntity(RestApi.RequestContext context) throws RestApiException {
            if (log.isLoggable(Level.FINE)) {
                return RestApiImpl.toString(context).map(string -> {
                    log.fine(() -> "Request content: " + string);
                    return RestApiImpl.convertIoException("Failed to parse JSON", () -> context.jacksonJsonMapper().readValue(string, this.type));
                });
            }
            return RestApiImpl.toInputStream(context).map(in -> RestApiImpl.convertIoException("Invalid JSON", () -> context.jacksonJsonMapper().readValue(in, this.type)));
        }
    }

    static class Route {
        private final String pathPattern;
        private final String name;
        private final Map<HttpRequest.Method, HandlerHolder<?>> handlerPerMethod;
        private final HandlerHolder<?> defaultHandler;
        private final List<RestApi.Filter> filters;

        private Route(RestApi.RouteBuilder builder) {
            RouteBuilderImpl builderImpl = (RouteBuilderImpl)builder;
            this.pathPattern = builderImpl.pathPattern;
            this.name = builderImpl.name;
            this.handlerPerMethod = Map.copyOf(builderImpl.handlerPerMethod);
            this.defaultHandler = builderImpl.defaultHandler != null ? builderImpl.defaultHandler : this.createDefaultMethodHandler();
            this.filters = List.copyOf(builderImpl.filters);
        }

        private HandlerHolder<?> createDefaultMethodHandler() {
            return HandlerHolder.of(context -> {
                throw new RestApiException.MethodNotAllowed(context.request());
            });
        }
    }

    private static class RequestMapperHolder<ENTITY> {
        final Class<ENTITY> type;
        final RestApi.RequestMapper<ENTITY> mapper;

        RequestMapperHolder(Class<ENTITY> type, RestApi.RequestMapper<ENTITY> mapper) {
            this.type = type;
            this.mapper = mapper;
        }
    }

    private static class HandlerHolder<REQUEST_ENTITY> {
        final Class<REQUEST_ENTITY> type;
        final RestApi.HandlerWithRequestEntity<REQUEST_ENTITY, ?> handler;

        HandlerHolder(Class<REQUEST_ENTITY> type, RestApi.HandlerWithRequestEntity<REQUEST_ENTITY, ?> handler) {
            this.type = type;
            this.handler = handler;
        }

        static <RESPONSE_ENTITY, REQUEST_ENTITY> HandlerHolder<REQUEST_ENTITY> of(Class<REQUEST_ENTITY> type, RestApi.HandlerWithRequestEntity<REQUEST_ENTITY, RESPONSE_ENTITY> handler) {
            return new HandlerHolder<REQUEST_ENTITY>(type, handler);
        }

        static <RESPONSE_ENTITY> HandlerHolder<Void> of(RestApi.Handler<RESPONSE_ENTITY> handler) {
            return new HandlerHolder<Void>(Void.class, (context, nullEntity) -> handler.handleRequest(context));
        }

        Object executeHandler(RestApi.RequestContext context, Object entity) {
            return this.handler.handleRequest(context, this.type.cast(entity));
        }
    }

    private static class ResponseMapperHolder<ENTITY> {
        final Class<ENTITY> type;
        final RestApi.ResponseMapper<ENTITY> mapper;

        ResponseMapperHolder(Class<ENTITY> type, RestApi.ResponseMapper<ENTITY> mapper) {
            this.type = type;
            this.mapper = mapper;
        }

        HttpResponse toHttpResponse(RestApi.RequestContext context, Object entity) {
            return this.mapper.toHttpResponse(context, this.type.cast(entity));
        }
    }

    private static class ExceptionMapperHolder<EXCEPTION extends RuntimeException> {
        final Class<EXCEPTION> type;
        final RestApi.ExceptionMapper<EXCEPTION> mapper;

        ExceptionMapperHolder(Class<EXCEPTION> type, RestApi.ExceptionMapper<EXCEPTION> mapper) {
            this.type = type;
            this.mapper = mapper;
        }

        HttpResponse toResponse(RestApi.RequestContext context, RuntimeException e) {
            return this.mapper.toResponse(context, (RuntimeException)this.type.cast(e));
        }
    }

    private class FilterContextImpl
    implements RestApi.FilterContext {
        final Route route;
        final RestApi.Filter filter;
        final RequestContextImpl requestContext;
        final FilterContextImpl next;

        FilterContextImpl(Route route, RestApi.Filter filter, RequestContextImpl requestContext, FilterContextImpl next) {
            this.route = route;
            this.filter = filter;
            this.requestContext = requestContext;
            this.next = next;
        }

        @Override
        public RestApi.RequestContext requestContext() {
            return this.requestContext;
        }

        @Override
        public String route() {
            return this.route.name != null ? this.route.name : this.route.pathPattern;
        }

        HttpResponse executeFirst() {
            return this.filter.filterRequest(this);
        }

        @Override
        public HttpResponse executeNext() {
            if (this.next != null) {
                return this.next.filter.filterRequest(this.next);
            }
            return RestApiImpl.this.dispatchToRoute(this.route, this.requestContext);
        }
    }

    private static class RequestContextImpl
    implements RestApi.RequestContext {
        final HttpRequest request;
        final Path pathMatcher;
        final ObjectMapper jacksonJsonMapper;
        final RestApi.RequestContext.PathParameters pathParameters = new PathParametersImpl();
        final RestApi.RequestContext.QueryParameters queryParameters = new QueryParametersImpl();
        final RestApi.RequestContext.Headers headers = new HeadersImpl();
        final RestApi.RequestContext.Attributes attributes = new AttributesImpl();
        final RestApi.RequestContext.RequestContent requestContent;

        RequestContextImpl(HttpRequest request, Path pathMatcher, ObjectMapper jacksonJsonMapper) {
            this.request = request;
            this.pathMatcher = pathMatcher;
            this.jacksonJsonMapper = jacksonJsonMapper;
            this.requestContent = request.getData() != null ? new RequestContentImpl() : null;
        }

        @Override
        public HttpRequest request() {
            return this.request;
        }

        @Override
        public RestApi.RequestContext.PathParameters pathParameters() {
            return this.pathParameters;
        }

        @Override
        public RestApi.RequestContext.QueryParameters queryParameters() {
            return this.queryParameters;
        }

        @Override
        public RestApi.RequestContext.Headers headers() {
            return this.headers;
        }

        @Override
        public RestApi.RequestContext.Attributes attributes() {
            return this.attributes;
        }

        @Override
        public Optional<RestApi.RequestContext.RequestContent> requestContent() {
            return Optional.ofNullable(this.requestContent);
        }

        @Override
        public RestApi.RequestContext.RequestContent requestContentOrThrow() {
            return this.requestContent().orElseThrow(() -> new RestApiException.BadRequest("Request content missing"));
        }

        @Override
        public ObjectMapper jacksonJsonMapper() {
            return this.jacksonJsonMapper;
        }

        @Override
        public UriBuilder uriBuilder() {
            URI uri = this.request.getUri();
            return new UriBuilder(uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort());
        }

        private class AttributesImpl
        implements RestApi.RequestContext.Attributes {
            private AttributesImpl() {
            }

            @Override
            public Optional<Object> get(String name) {
                return Optional.ofNullable(RequestContextImpl.this.request.getJDiscRequest().context().get(name));
            }

            @Override
            public void set(String name, Object value) {
                RequestContextImpl.this.request.getJDiscRequest().context().put(name, value);
            }
        }

        private class RequestContentImpl
        implements RestApi.RequestContext.RequestContent {
            private RequestContentImpl() {
            }

            @Override
            public String contentType() {
                return RequestContextImpl.this.request.getHeader("Content-Type");
            }

            @Override
            public InputStream content() {
                return RequestContextImpl.this.request.getData();
            }
        }

        private class HeadersImpl
        implements RestApi.RequestContext.Headers {
            private HeadersImpl() {
            }

            @Override
            public Optional<String> getString(String name) {
                return Optional.ofNullable(RequestContextImpl.this.request.getHeader(name));
            }

            @Override
            public String getStringOrThrow(String name) {
                return this.getString(name).orElseThrow(() -> new RestApiException.BadRequest("Header '" + name + "' missing"));
            }
        }

        private class QueryParametersImpl
        implements RestApi.RequestContext.QueryParameters {
            private QueryParametersImpl() {
            }

            @Override
            public Optional<String> getString(String name) {
                return Optional.ofNullable(RequestContextImpl.this.request.getProperty(name));
            }

            @Override
            public String getStringOrThrow(String name) {
                return this.getString(name).orElseThrow(() -> new RestApiException.BadRequest("Query parameter '" + name + "' is missing"));
            }
        }

        private class PathParametersImpl
        implements RestApi.RequestContext.PathParameters {
            private PathParametersImpl() {
            }

            @Override
            public Optional<String> getString(String name) {
                if (name.equals("*")) {
                    String rest = RequestContextImpl.this.pathMatcher.getRest();
                    return rest.isEmpty() ? Optional.empty() : Optional.of(rest);
                }
                return Optional.ofNullable(RequestContextImpl.this.pathMatcher.get(name));
            }

            @Override
            public String getStringOrThrow(String name) {
                return this.getString(name).orElseThrow(() -> new RestApiException.BadRequest("Path parameter '" + name + "' is missing"));
            }
        }
    }

    public static class RouteBuilderImpl
    implements RestApi.RouteBuilder {
        private final String pathPattern;
        private String name;
        private final Map<HttpRequest.Method, HandlerHolder<?>> handlerPerMethod = new HashMap();
        private final List<RestApi.Filter> filters = new ArrayList<RestApi.Filter>();
        private HandlerHolder<?> defaultHandler;

        RouteBuilderImpl(String pathPattern) {
            this.pathPattern = pathPattern;
        }

        @Override
        public RestApi.RouteBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public RestApi.RouteBuilder get(RestApi.Handler<?> handler) {
            return this.addHandler(HttpRequest.Method.GET, handler);
        }

        @Override
        public RestApi.RouteBuilder post(RestApi.Handler<?> handler) {
            return this.addHandler(HttpRequest.Method.POST, handler);
        }

        public <ENTITY> RestApi.RouteBuilder post(Class<ENTITY> type, RestApi.HandlerWithRequestEntity<ENTITY, ?> handler) {
            return this.addHandler(HttpRequest.Method.POST, type, handler);
        }

        @Override
        public RestApi.RouteBuilder put(RestApi.Handler<?> handler) {
            return this.addHandler(HttpRequest.Method.PUT, handler);
        }

        public <ENTITY> RestApi.RouteBuilder put(Class<ENTITY> type, RestApi.HandlerWithRequestEntity<ENTITY, ?> handler) {
            return this.addHandler(HttpRequest.Method.PUT, type, handler);
        }

        @Override
        public RestApi.RouteBuilder delete(RestApi.Handler<?> handler) {
            return this.addHandler(HttpRequest.Method.DELETE, handler);
        }

        @Override
        public RestApi.RouteBuilder patch(RestApi.Handler<?> handler) {
            return this.addHandler(HttpRequest.Method.PATCH, handler);
        }

        public <ENTITY> RestApi.RouteBuilder patch(Class<ENTITY> type, RestApi.HandlerWithRequestEntity<ENTITY, ?> handler) {
            return this.addHandler(HttpRequest.Method.PATCH, type, handler);
        }

        @Override
        public RestApi.RouteBuilder defaultHandler(RestApi.Handler<?> handler) {
            this.defaultHandler = HandlerHolder.of(handler);
            return this;
        }

        public <ENTITY> RestApi.RouteBuilder defaultHandler(Class<ENTITY> type, RestApi.HandlerWithRequestEntity<ENTITY, ?> handler) {
            this.defaultHandler = HandlerHolder.of(type, handler);
            return this;
        }

        @Override
        public RestApi.RouteBuilder addFilter(RestApi.Filter filter) {
            this.filters.add(filter);
            return this;
        }

        private RestApi.RouteBuilder addHandler(HttpRequest.Method method, RestApi.Handler<?> handler) {
            this.handlerPerMethod.put(method, HandlerHolder.of(handler));
            return this;
        }

        private <ENTITY> RestApi.RouteBuilder addHandler(HttpRequest.Method method, Class<ENTITY> type, RestApi.HandlerWithRequestEntity<ENTITY, ?> handler) {
            this.handlerPerMethod.put(method, HandlerHolder.of(type, handler));
            return this;
        }

        private Route build() {
            return new Route(this);
        }
    }

    static class BuilderImpl
    implements RestApi.Builder {
        private final List<Route> routes = new ArrayList<Route>();
        private final List<ExceptionMapperHolder<?>> exceptionMappers = new ArrayList();
        private final List<ResponseMapperHolder<?>> responseMappers = new ArrayList();
        private final List<RequestMapperHolder<?>> requestMappers = new ArrayList();
        private final List<RestApi.Filter> filters = new ArrayList<RestApi.Filter>();
        private Route defaultRoute;
        private ObjectMapper jacksonJsonMapper;
        private Boolean disableDefaultExceptionMappers;
        private Boolean disableDefaultResponseMappers;

        BuilderImpl() {
        }

        @Override
        public RestApi.Builder setObjectMapper(ObjectMapper mapper) {
            this.jacksonJsonMapper = mapper;
            return this;
        }

        @Override
        public RestApi.Builder setDefaultRoute(RestApi.RouteBuilder route) {
            this.defaultRoute = ((RouteBuilderImpl)route).build();
            return this;
        }

        @Override
        public RestApi.Builder addRoute(RestApi.RouteBuilder route) {
            this.routes.add(((RouteBuilderImpl)route).build());
            return this;
        }

        @Override
        public RestApi.Builder addFilter(RestApi.Filter filter) {
            this.filters.add(filter);
            return this;
        }

        @Override
        public <EXCEPTION extends RuntimeException> RestApi.Builder addExceptionMapper(Class<EXCEPTION> type, RestApi.ExceptionMapper<EXCEPTION> mapper) {
            this.exceptionMappers.add(new ExceptionMapperHolder<EXCEPTION>(type, mapper));
            return this;
        }

        public <ENTITY> RestApi.Builder addResponseMapper(Class<ENTITY> type, RestApi.ResponseMapper<ENTITY> mapper) {
            this.responseMappers.add(new ResponseMapperHolder<ENTITY>(type, mapper));
            return this;
        }

        public <ENTITY> RestApi.Builder addRequestMapper(Class<ENTITY> type, RestApi.RequestMapper<ENTITY> mapper) {
            this.requestMappers.add(new RequestMapperHolder<ENTITY>(type, mapper));
            return this;
        }

        public <ENTITY> RestApi.Builder registerJacksonResponseEntity(Class<ENTITY> type) {
            this.addResponseMapper(type, new JacksonResponseMapper());
            return this;
        }

        public <ENTITY> RestApi.Builder registerJacksonRequestEntity(Class<ENTITY> type) {
            this.addRequestMapper(type, new JacksonRequestMapper<ENTITY>(type));
            return this;
        }

        @Override
        public RestApi.Builder disableDefaultExceptionMappers() {
            this.disableDefaultExceptionMappers = true;
            return this;
        }

        @Override
        public RestApi.Builder disableDefaultResponseMappers() {
            this.disableDefaultResponseMappers = true;
            return this;
        }

        @Override
        public RestApi build() {
            return new RestApiImpl(this);
        }
    }
}

