/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.response;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.yahoo.component.provider.ListenableFreezableClass;
import com.yahoo.processing.Request;
import com.yahoo.processing.response.Data;
import com.yahoo.processing.response.DataList;
import com.yahoo.processing.response.IncomingData;
import com.yahoo.processing.response.Ordered;
import com.yahoo.processing.response.Streamed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractDataList<DATATYPE extends Data>
extends ListenableFreezableClass
implements DataList<DATATYPE>,
Streamed,
Ordered {
    private final boolean ordered;
    private final boolean streamed;
    private final Request request;
    private final IncomingData<DATATYPE> incomingData;
    private final ListenableFuture<DataList<DATATYPE>> completedFuture;

    protected AbstractDataList(Request request) {
        this.request = request;
        this.incomingData = new IncomingData.NullIncomingData(this);
        this.completedFuture = new DrainOnGetFuture(this);
        this.ordered = true;
        this.streamed = true;
    }

    protected AbstractDataList(Request request, IncomingData<DATATYPE> incomingData) {
        this(request, incomingData, true, true);
    }

    protected AbstractDataList(Request request, IncomingData<DATATYPE> incomingData, boolean ordered, boolean streamed) {
        if (request == null) {
            throw new NullPointerException("Request cannot be null");
        }
        if (incomingData == null) {
            throw new NullPointerException("incomingData cannot be null");
        }
        this.request = request;
        this.incomingData = incomingData;
        this.completedFuture = new DrainOnGetFuture(this);
        this.ordered = ordered;
        this.streamed = streamed;
    }

    @Override
    public Request request() {
        return this.request;
    }

    @Override
    public IncomingData<DATATYPE> incoming() {
        return this.incomingData;
    }

    @Override
    public ListenableFuture<DataList<DATATYPE>> complete() {
        return this.completedFuture;
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public boolean isStreamed() {
        return this.streamed;
    }

    public String toString() {
        return super.toString() + (String)(this.complete().isDone() ? " [completed]" : " [incomplete, " + this.incoming() + "]");
    }

    public static final class DrainOnGetFuture<DATATYPE extends Data>
    extends AbstractFuture<DataList<DATATYPE>> {
        private final DataList<DATATYPE> owner;

        public DrainOnGetFuture(DataList<DATATYPE> owner) {
            this.owner = owner;
        }

        public boolean cancel(boolean b) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public DataList<DATATYPE> get() throws InterruptedException, ExecutionException {
            return this.drain((DataList)this.owner.incoming().completed().get());
        }

        public DataList<DATATYPE> get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.drain((DataList)this.owner.incoming().completed().get(timeout, timeUnit));
        }

        private DataList<DATATYPE> drain(DataList<DATATYPE> dataList) {
            for (Data item : dataList.incoming().drain()) {
                dataList.add(item);
            }
            this.set(dataList);
            return dataList;
        }
    }
}

