/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.server.jetty.HttpServletRequestUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

class TlsClientAuthenticationEnforcer
extends HandlerWrapper {
    private final Map<Integer, List<String>> portToWhitelistedPathsMapping;

    TlsClientAuthenticationEnforcer(List<ConnectorConfig> connectorConfigs) {
        this.portToWhitelistedPathsMapping = TlsClientAuthenticationEnforcer.createWhitelistMapping(connectorConfigs);
    }

    public void handle(String target, Request request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
        if (this.isHttpsRequest(request) && !this.isRequestToWhitelistedBinding(servletRequest) && !this.isClientAuthenticated(servletRequest)) {
            servletResponse.sendError(401, "Client did not present a x509 certificate, or presented a certificate not issued by any of the CA certificates in trust store.");
        } else {
            this._handler.handle(target, request, servletRequest, servletResponse);
        }
    }

    private static Map<Integer, List<String>> createWhitelistMapping(List<ConnectorConfig> connectorConfigs) {
        HashMap<Integer, List<String>> mapping = new HashMap<Integer, List<String>>();
        for (ConnectorConfig connectorConfig : connectorConfigs) {
            ConnectorConfig.TlsClientAuthEnforcer enforcerConfig = connectorConfig.tlsClientAuthEnforcer();
            if (!enforcerConfig.enable()) continue;
            mapping.put(connectorConfig.listenPort(), enforcerConfig.pathWhitelist());
        }
        return mapping;
    }

    private boolean isHttpsRequest(Request request) {
        return request.getDispatcherType() == DispatcherType.REQUEST && request.getScheme().equalsIgnoreCase("https");
    }

    private boolean isRequestToWhitelistedBinding(HttpServletRequest servletRequest) {
        int localPort = HttpServletRequestUtils.getConnectorLocalPort(servletRequest);
        List<String> whiteListedPaths = this.getWhitelistedPathsForPort(localPort);
        if (whiteListedPaths == null) {
            return true;
        }
        return whiteListedPaths.contains(servletRequest.getRequestURI());
    }

    private List<String> getWhitelistedPathsForPort(int localPort) {
        if (this.portToWhitelistedPathsMapping.containsKey(0) && this.portToWhitelistedPathsMapping.size() == 1) {
            return this.portToWhitelistedPathsMapping.get(0);
        }
        return this.portToWhitelistedPathsMapping.get(localPort);
    }

    private boolean isClientAuthenticated(HttpServletRequest servletRequest) {
        return servletRequest.getAttribute("javax.servlet.request.X509Certificate") != null;
    }
}

