/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.restapi.JacksonJsonMapper;
import com.yahoo.restapi.JacksonJsonResponse;
import com.yahoo.restapi.MessageResponse;
import com.yahoo.restapi.Path;
import com.yahoo.restapi.RestApi;
import com.yahoo.restapi.RestApiException;
import com.yahoo.restapi.SlimeJsonResponse;
import com.yahoo.slime.JsonParseException;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

class RestApiImpl
implements RestApi {
    private static final Logger log = Logger.getLogger(RestApiImpl.class.getName());
    private final Route defaultRoute;
    private final List<Route> routes;
    private final List<ExceptionMapperHolder<?>> exceptionMappers;
    private final List<ResponseMapperHolder<?>> responseMappers;
    private final List<RestApi.Filter> filters;
    private final ObjectMapper jacksonJsonMapper;

    private RestApiImpl(RestApi.Builder builder) {
        BuilderImpl builderImpl = (BuilderImpl)builder;
        ObjectMapper jacksonJsonMapper = builderImpl.jacksonJsonMapper != null ? builderImpl.jacksonJsonMapper : JacksonJsonMapper.instance.copy();
        this.defaultRoute = builderImpl.defaultRoute != null ? builderImpl.defaultRoute : RestApiImpl.createDefaultRoute();
        this.routes = List.copyOf(builderImpl.routes);
        this.exceptionMappers = RestApiImpl.combineWithDefaultExceptionMappers(builderImpl.exceptionMappers, Boolean.TRUE.equals(builderImpl.disableDefaultExceptionMappers));
        this.responseMappers = RestApiImpl.combineWithDefaultResponseMappers(builderImpl.responseMappers, jacksonJsonMapper, Boolean.TRUE.equals(builderImpl.disableDefaultResponseMappers));
        this.filters = List.copyOf(builderImpl.filters);
        this.jacksonJsonMapper = jacksonJsonMapper;
    }

    @Override
    public HttpResponse handleRequest(HttpRequest request) {
        RequestContextImpl requestContext;
        Path pathMatcher = new Path(request.getUri());
        Route resolvedRoute = this.resolveRoute(pathMatcher);
        FilterContextImpl filterContext = this.createFilterContextRecursive(resolvedRoute, requestContext = new RequestContextImpl(request, pathMatcher, this.jacksonJsonMapper), this.filters, this.createFilterContextRecursive(resolvedRoute, requestContext, resolvedRoute.filters, null));
        if (filterContext != null) {
            return filterContext.executeFirst();
        }
        return this.dispatchToRoute(resolvedRoute, requestContext);
    }

    @Override
    public ObjectMapper jacksonJsonMapper() {
        return this.jacksonJsonMapper;
    }

    private HttpResponse dispatchToRoute(Route route, RequestContextImpl context) {
        Object entity;
        RestApi.MethodHandler<?> resolvedHandler = route.handlerPerMethod.get(context.request().getMethod());
        if (resolvedHandler == null) {
            resolvedHandler = route.defaultHandler;
        }
        try {
            entity = resolvedHandler.handleRequest(context);
        }
        catch (RuntimeException e) {
            ExceptionMapperHolder mapper = this.exceptionMappers.stream().filter(holder -> holder.matches(e)).findFirst().orElseThrow(() -> e);
            return mapper.toResponse(e, context);
        }
        if (entity == null) {
            throw new NullPointerException("Handler must return non-null value");
        }
        ResponseMapperHolder mapper = this.responseMappers.stream().filter(holder -> holder.matches(entity)).findFirst().orElseThrow(() -> new IllegalStateException("No mapper configured for " + entity.getClass()));
        return mapper.toHttpResponse(entity, context);
    }

    private Route resolveRoute(Path pathMatcher) {
        Route matchingRoute = this.routes.stream().filter(route -> pathMatcher.matches(route.pathPattern)).findFirst().orElse(null);
        if (matchingRoute != null) {
            return matchingRoute;
        }
        pathMatcher.matches(this.defaultRoute.pathPattern);
        return this.defaultRoute;
    }

    private FilterContextImpl createFilterContextRecursive(Route route, RequestContextImpl requestContext, List<RestApi.Filter> filters, FilterContextImpl previousContext) {
        FilterContextImpl filterContext = previousContext;
        ListIterator<RestApi.Filter> iterator = filters.listIterator(filters.size());
        while (iterator.hasPrevious()) {
            filterContext = new FilterContextImpl(route, iterator.previous(), requestContext, filterContext);
        }
        return filterContext;
    }

    private static Route createDefaultRoute() {
        RestApi.RouteBuilder routeBuilder = new RouteBuilderImpl("{*}").defaultHandler(context -> {
            throw new RestApiException.NotFoundException();
        });
        return ((RouteBuilderImpl)routeBuilder).build();
    }

    private static List<ExceptionMapperHolder<?>> combineWithDefaultExceptionMappers(List<ExceptionMapperHolder<?>> configuredExceptionMappers, boolean disableDefaultMappers) {
        ArrayList exceptionMappers = new ArrayList(configuredExceptionMappers);
        if (!disableDefaultMappers) {
            exceptionMappers.add(new ExceptionMapperHolder<RestApiException>(RestApiException.class, (exception, context) -> exception.response()));
        }
        return exceptionMappers;
    }

    private static List<ResponseMapperHolder<?>> combineWithDefaultResponseMappers(List<ResponseMapperHolder<?>> configuredResponseMappers, ObjectMapper jacksonJsonMapper, boolean disableDefaultMappers) {
        ArrayList responseMappers = new ArrayList(configuredResponseMappers);
        if (!disableDefaultMappers) {
            responseMappers.add(new ResponseMapperHolder<HttpResponse>(HttpResponse.class, (entity, context) -> entity));
            responseMappers.add(new ResponseMapperHolder<String>(String.class, (entity, context) -> new MessageResponse((String)entity)));
            responseMappers.add(new ResponseMapperHolder<Slime>(Slime.class, (entity, context) -> new SlimeJsonResponse((Slime)entity)));
            responseMappers.add(new ResponseMapperHolder<JsonNode>(JsonNode.class, (entity, context) -> new JacksonJsonResponse<JsonNode>(200, (JsonNode)entity, jacksonJsonMapper, true)));
            responseMappers.add(new ResponseMapperHolder<RestApi.JacksonResponseEntity>(RestApi.JacksonResponseEntity.class, (entity, context) -> new JacksonJsonResponse<RestApi.JacksonResponseEntity>(200, (RestApi.JacksonResponseEntity)entity, jacksonJsonMapper, true)));
        }
        return responseMappers;
    }

    static class Route {
        private final String pathPattern;
        private final String name;
        private final Map<HttpRequest.Method, RestApi.MethodHandler<?>> handlerPerMethod;
        private final RestApi.MethodHandler<?> defaultHandler;
        private final List<RestApi.Filter> filters;

        private Route(RestApi.RouteBuilder builder) {
            RouteBuilderImpl builderImpl = (RouteBuilderImpl)builder;
            this.pathPattern = builderImpl.pathPattern;
            this.name = builderImpl.name;
            this.handlerPerMethod = Map.copyOf(builderImpl.handlerPerMethod);
            this.defaultHandler = builderImpl.defaultHandler != null ? builderImpl.defaultHandler : this.createDefaultMethodHandler();
            this.filters = List.copyOf(builderImpl.filters);
        }

        private RestApi.MethodHandler<?> createDefaultMethodHandler() {
            return context -> {
                throw new RestApiException.MethodNotAllowed(context.request());
            };
        }
    }

    private static class ResponseMapperHolder<ENTITY> {
        final Class<ENTITY> type;
        final RestApi.ResponseMapper<ENTITY> mapper;

        ResponseMapperHolder(Class<ENTITY> type, RestApi.ResponseMapper<ENTITY> mapper) {
            this.type = type;
            this.mapper = mapper;
        }

        boolean matches(Object entity) {
            return this.type.isAssignableFrom(entity.getClass());
        }

        HttpResponse toHttpResponse(Object entity, RestApi.RequestContext context) {
            return this.mapper.toHttpResponse(this.type.cast(entity), context);
        }
    }

    private static class ExceptionMapperHolder<EXCEPTION extends RuntimeException> {
        final Class<EXCEPTION> type;
        final RestApi.ExceptionMapper<EXCEPTION> mapper;

        ExceptionMapperHolder(Class<EXCEPTION> type, RestApi.ExceptionMapper<EXCEPTION> mapper) {
            this.type = type;
            this.mapper = mapper;
        }

        boolean matches(RuntimeException e) {
            return this.type.isAssignableFrom(e.getClass());
        }

        HttpResponse toResponse(RuntimeException e, RestApi.RequestContext context) {
            return this.mapper.toResponse((RuntimeException)this.type.cast(e), context);
        }
    }

    private class FilterContextImpl
    implements RestApi.FilterContext {
        final Route route;
        final RestApi.Filter filter;
        final RequestContextImpl requestContext;
        final FilterContextImpl next;

        FilterContextImpl(Route route, RestApi.Filter filter, RequestContextImpl requestContext, FilterContextImpl next) {
            this.route = route;
            this.filter = filter;
            this.requestContext = requestContext;
            this.next = next;
        }

        @Override
        public RestApi.RequestContext requestContext() {
            return this.requestContext;
        }

        @Override
        public String route() {
            return this.route.name != null ? this.route.name : this.route.pathPattern;
        }

        HttpResponse executeFirst() {
            return this.filter.filterRequest(this);
        }

        @Override
        public HttpResponse executeNext() {
            if (this.next != null) {
                return this.next.filter.filterRequest(this.next);
            }
            return RestApiImpl.this.dispatchToRoute(this.route, this.requestContext);
        }
    }

    private static class RequestContextImpl
    implements RestApi.RequestContext {
        final HttpRequest request;
        final Path pathMatcher;
        final ObjectMapper jacksonJsonMapper;
        final RestApi.RequestContext.PathParameters pathParameters = new PathParametersImpl();
        final RestApi.RequestContext.QueryParameters queryParameters = new QueryParametersImpl();
        final RestApi.RequestContext.Headers headers = new HeadersImpl();
        final RestApi.RequestContext.Attributes attributes = new AttributesImpl();
        final RestApi.RequestContext.RequestContent requestContent;

        RequestContextImpl(HttpRequest request, Path pathMatcher, ObjectMapper jacksonJsonMapper) {
            this.request = request;
            this.pathMatcher = pathMatcher;
            this.jacksonJsonMapper = jacksonJsonMapper;
            this.requestContent = request.getData() != null ? new RequestContentImpl() : null;
        }

        @Override
        public HttpRequest request() {
            return this.request;
        }

        @Override
        public RestApi.RequestContext.PathParameters pathParameters() {
            return this.pathParameters;
        }

        @Override
        public RestApi.RequestContext.QueryParameters queryParameters() {
            return this.queryParameters;
        }

        @Override
        public RestApi.RequestContext.Headers headers() {
            return this.headers;
        }

        @Override
        public RestApi.RequestContext.Attributes attributes() {
            return this.attributes;
        }

        @Override
        public Optional<RestApi.RequestContext.RequestContent> requestContent() {
            return Optional.ofNullable(this.requestContent);
        }

        @Override
        public RestApi.RequestContext.RequestContent requestContentOrThrow() {
            return this.requestContent().orElseThrow(() -> new RestApiException.BadRequest("Request content missing"));
        }

        private static <T> T convertIoException(SupplierThrowingIoException<T> supplier) {
            try {
                return supplier.get();
            }
            catch (IOException e) {
                throw new RestApiException.InternalServerError("Failed to read request content: " + Exceptions.toMessageString((Throwable)e), e);
            }
        }

        @FunctionalInterface
        private static interface SupplierThrowingIoException<T> {
            public T get() throws IOException;
        }

        private class AttributesImpl
        implements RestApi.RequestContext.Attributes {
            private AttributesImpl() {
            }

            @Override
            public Optional<Object> get(String name) {
                return Optional.ofNullable(RequestContextImpl.this.request.getJDiscRequest().context().get(name));
            }

            @Override
            public void set(String name, Object value) {
                RequestContextImpl.this.request.getJDiscRequest().context().put(name, value);
            }
        }

        private class RequestContentImpl
        implements RestApi.RequestContext.RequestContent {
            private RequestContentImpl() {
            }

            @Override
            public String contentType() {
                return RequestContextImpl.this.request.getHeader("Content-Type");
            }

            @Override
            public InputStream inputStream() {
                return RequestContextImpl.this.request.getData();
            }

            @Override
            public ObjectMapper jacksonJsonMapper() {
                return RequestContextImpl.this.jacksonJsonMapper;
            }

            @Override
            public byte[] consumeByteArray() {
                return RequestContextImpl.convertIoException(() -> this.inputStream().readAllBytes());
            }

            @Override
            public String consumeString() {
                return new String(this.consumeByteArray(), StandardCharsets.UTF_8);
            }

            @Override
            public JsonNode consumeJsonNode() {
                return RequestContextImpl.convertIoException(() -> {
                    try {
                        if (log.isLoggable(Level.FINE)) {
                            String content = this.consumeString();
                            log.fine(() -> "Request content: " + content);
                            return RequestContextImpl.this.jacksonJsonMapper.readTree(content);
                        }
                        return RequestContextImpl.this.jacksonJsonMapper.readTree(RequestContextImpl.this.request.getData());
                    }
                    catch (com.fasterxml.jackson.core.JsonParseException e) {
                        log.log(Level.FINE, e.getMessage(), e);
                        throw new RestApiException.BadRequest("Invalid json request content: " + Exceptions.toMessageString((Throwable)e), e);
                    }
                });
            }

            @Override
            public Slime consumeSlime() {
                try {
                    String content = this.consumeString();
                    log.fine(() -> "Request content: " + content);
                    return SlimeUtils.jsonToSlimeOrThrow((String)content);
                }
                catch (JsonParseException e) {
                    log.log(Level.FINE, e.getMessage(), e);
                    throw new RestApiException.BadRequest("Invalid json request content: " + Exceptions.toMessageString((Throwable)e), e);
                }
            }

            @Override
            public <T extends RestApi.JacksonRequestEntity> T consumeJacksonEntity(Class<T> type) {
                return (T)RequestContextImpl.convertIoException(() -> {
                    try {
                        if (log.isLoggable(Level.FINE)) {
                            String content = this.consumeString();
                            log.fine(() -> "Request content: " + content);
                            return (RestApi.JacksonRequestEntity)RequestContextImpl.this.jacksonJsonMapper.readValue(content, type);
                        }
                        return (RestApi.JacksonRequestEntity)RequestContextImpl.this.jacksonJsonMapper.readValue(RequestContextImpl.this.request.getData(), type);
                    }
                    catch (com.fasterxml.jackson.core.JsonParseException | JsonMappingException e) {
                        log.log(Level.FINE, e.getMessage(), e);
                        throw new RestApiException.BadRequest("Invalid json request content: " + Exceptions.toMessageString((Throwable)e), e);
                    }
                });
            }
        }

        private class HeadersImpl
        implements RestApi.RequestContext.Headers {
            private HeadersImpl() {
            }

            @Override
            public Optional<String> getString(String name) {
                return Optional.ofNullable(RequestContextImpl.this.request.getHeader(name));
            }

            @Override
            public String getStringOrThrow(String name) {
                return this.getString(name).orElseThrow(() -> new RestApiException.BadRequest("Header '" + name + "' missing"));
            }
        }

        private class QueryParametersImpl
        implements RestApi.RequestContext.QueryParameters {
            private QueryParametersImpl() {
            }

            @Override
            public Optional<String> getString(String name) {
                return Optional.ofNullable(RequestContextImpl.this.request.getProperty(name));
            }

            @Override
            public String getStringOrThrow(String name) {
                return this.getString(name).orElseThrow(() -> new RestApiException.BadRequest("Query parameter '" + name + "' is missing"));
            }
        }

        private class PathParametersImpl
        implements RestApi.RequestContext.PathParameters {
            private PathParametersImpl() {
            }

            @Override
            public Optional<String> getString(String name) {
                if (name.equals("*")) {
                    String rest = RequestContextImpl.this.pathMatcher.getRest();
                    return rest.isEmpty() ? Optional.empty() : Optional.of(rest);
                }
                return Optional.ofNullable(RequestContextImpl.this.pathMatcher.get(name));
            }

            @Override
            public String getStringOrThrow(String name) {
                return this.getString(name).orElseThrow(() -> new RestApiException.BadRequest("Path parameter '" + name + "' is missing"));
            }
        }
    }

    public static class RouteBuilderImpl
    implements RestApi.RouteBuilder {
        private final String pathPattern;
        private String name;
        private final Map<HttpRequest.Method, RestApi.MethodHandler<?>> handlerPerMethod = new HashMap();
        private final List<RestApi.Filter> filters = new ArrayList<RestApi.Filter>();
        private RestApi.MethodHandler<?> defaultHandler;

        RouteBuilderImpl(String pathPattern) {
            this.pathPattern = pathPattern;
        }

        @Override
        public RestApi.RouteBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public RestApi.RouteBuilder get(RestApi.MethodHandler<?> handler) {
            return this.addHandler(HttpRequest.Method.GET, handler);
        }

        @Override
        public RestApi.RouteBuilder post(RestApi.MethodHandler<?> handler) {
            return this.addHandler(HttpRequest.Method.POST, handler);
        }

        @Override
        public RestApi.RouteBuilder put(RestApi.MethodHandler<?> handler) {
            return this.addHandler(HttpRequest.Method.PUT, handler);
        }

        @Override
        public RestApi.RouteBuilder delete(RestApi.MethodHandler<?> handler) {
            return this.addHandler(HttpRequest.Method.DELETE, handler);
        }

        @Override
        public RestApi.RouteBuilder patch(RestApi.MethodHandler<?> handler) {
            return this.addHandler(HttpRequest.Method.PATCH, handler);
        }

        @Override
        public RestApi.RouteBuilder defaultHandler(RestApi.MethodHandler<?> handler) {
            this.defaultHandler = handler;
            return this;
        }

        @Override
        public RestApi.RouteBuilder addFilter(RestApi.Filter filter) {
            this.filters.add(filter);
            return this;
        }

        private RestApi.RouteBuilder addHandler(HttpRequest.Method method, RestApi.MethodHandler<?> handler) {
            this.handlerPerMethod.put(method, handler);
            return this;
        }

        private Route build() {
            return new Route(this);
        }
    }

    static class BuilderImpl
    implements RestApi.Builder {
        private final List<Route> routes = new ArrayList<Route>();
        private final List<ExceptionMapperHolder<?>> exceptionMappers = new ArrayList();
        private final List<ResponseMapperHolder<?>> responseMappers = new ArrayList();
        private final List<RestApi.Filter> filters = new ArrayList<RestApi.Filter>();
        private Route defaultRoute;
        private ObjectMapper jacksonJsonMapper;
        private Boolean disableDefaultExceptionMappers;
        private Boolean disableDefaultResponseMappers;

        BuilderImpl() {
        }

        @Override
        public RestApi.Builder setObjectMapper(ObjectMapper mapper) {
            this.jacksonJsonMapper = mapper;
            return this;
        }

        @Override
        public RestApi.Builder setDefaultRoute(RestApi.RouteBuilder route) {
            this.defaultRoute = ((RouteBuilderImpl)route).build();
            return this;
        }

        @Override
        public RestApi.Builder addRoute(RestApi.RouteBuilder route) {
            this.routes.add(((RouteBuilderImpl)route).build());
            return this;
        }

        @Override
        public RestApi.Builder addFilter(RestApi.Filter filter) {
            this.filters.add(filter);
            return this;
        }

        @Override
        public <EXCEPTION extends RuntimeException> RestApi.Builder addExceptionMapper(Class<EXCEPTION> type, RestApi.ExceptionMapper<EXCEPTION> mapper) {
            this.exceptionMappers.add(new ExceptionMapperHolder<EXCEPTION>(type, mapper));
            return this;
        }

        @Override
        public <ENTITY> RestApi.Builder addResponseMapper(Class<ENTITY> type, RestApi.ResponseMapper<ENTITY> mapper) {
            this.responseMappers.add(new ResponseMapperHolder<ENTITY>(type, mapper));
            return this;
        }

        @Override
        public RestApi.Builder disableDefaultExceptionMappers() {
            this.disableDefaultExceptionMappers = true;
            return this;
        }

        @Override
        public RestApi.Builder disableDefaultResponseMappers() {
            this.disableDefaultResponseMappers = true;
            return this;
        }

        @Override
        public RestApi build() {
            return new RestApiImpl(this);
        }
    }
}

