/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.restapi.ErrorResponse;
import java.util.function.Function;

public class RestApiException
extends RuntimeException {
    private final int statusCode;
    private final HttpResponse response;

    public RestApiException(int statusCode, String errorType, String message) {
        this(new ErrorResponse(statusCode, errorType, message), message, null);
    }

    public RestApiException(HttpResponse response, String message) {
        this(response, message, null);
    }

    public RestApiException(int statusCode, String errorType, String message, Throwable cause) {
        this(new ErrorResponse(statusCode, errorType, message), message, cause);
    }

    public RestApiException(HttpResponse response, String message, Throwable cause) {
        super(message, cause);
        this.statusCode = response.getStatus();
        this.response = response;
    }

    private RestApiException(Function<String, HttpResponse> responseFromMessage, String message, Throwable cause) {
        this(responseFromMessage.apply(message), message, cause);
    }

    public int statusCode() {
        return this.statusCode;
    }

    public HttpResponse response() {
        return this.response;
    }

    public static class Forbidden
    extends RestApiException {
        public Forbidden(String message) {
            super(ErrorResponse::forbidden, message, null);
        }

        public Forbidden(String message, Throwable cause) {
            super(ErrorResponse::forbidden, message, cause);
        }
    }

    public static class InternalServerError
    extends RestApiException {
        public InternalServerError(String message) {
            super(ErrorResponse::internalServerError, message, null);
        }

        public InternalServerError(String message, Throwable cause) {
            super(ErrorResponse::internalServerError, message, cause);
        }
    }

    public static class BadRequest
    extends RestApiException {
        public BadRequest(String message) {
            super(ErrorResponse::badRequest, message, null);
        }

        public BadRequest(String message, Throwable cause) {
            super(ErrorResponse::badRequest, message, cause);
        }
    }

    public static class MethodNotAllowed
    extends RestApiException {
        public MethodNotAllowed() {
            super(ErrorResponse::methodNotAllowed, "Method not allowed", null);
        }

        public MethodNotAllowed(HttpRequest request) {
            super(ErrorResponse::methodNotAllowed, "Method '" + request.getMethod().name() + "' is not allowed", null);
        }
    }

    public static class NotFoundException
    extends RestApiException {
        public NotFoundException() {
            super(ErrorResponse::notFoundError, "Not Found", null);
        }
    }
}

