/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.google.inject.Inject;
import com.yahoo.container.core.LogHandlerConfig;
import com.yahoo.container.handler.LogReader;
import com.yahoo.container.jdisc.AsyncHttpResponse;
import com.yahoo.container.jdisc.ContentChannelOutputStream;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public class LogHandler
extends ThreadedHttpRequestHandler {
    private final LogReader logReader;
    private static final long MB = 0x100000L;

    @Inject
    public LogHandler(Executor executor, LogHandlerConfig config) {
        this(executor, new LogReader(config.logDirectory(), config.logPattern()));
    }

    LogHandler(Executor executor, LogReader logReader) {
        super(executor);
        this.logReader = logReader;
    }

    @Override
    public AsyncHttpResponse handle(HttpRequest request) {
        final Instant from = Optional.ofNullable(request.getProperty("from")).map(Long::valueOf).map(Instant::ofEpochMilli).orElse(Instant.MIN);
        final Instant to = Optional.ofNullable(request.getProperty("to")).map(Long::valueOf).map(Instant::ofEpochMilli).orElse(Instant.MAX);
        final Optional<String> hostname = Optional.ofNullable(request.getProperty("hostname"));
        return new AsyncHttpResponse(200){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void render(OutputStream output, ContentChannel networkChannel, CompletionHandler handler) {
                try {
                    MaxPendingContentChannelOutputStream blockingOutput = new MaxPendingContentChannelOutputStream(networkChannel, 0x100000L);
                    LogHandler.this.logReader.writeLogs(blockingOutput, from, to, hostname);
                    ((OutputStream)blockingOutput).close();
                }
                catch (Throwable t) {
                    LogHandler.this.log.log(Level.WARNING, "Failed reading logs from " + from + " to " + to, t);
                }
                finally {
                    networkChannel.close(handler);
                }
            }
        };
    }

    private static class MaxPendingContentChannelOutputStream
    extends ContentChannelOutputStream {
        private final long maxPending;
        private final AtomicLong sent = new AtomicLong(0L);
        private final AtomicLong acked = new AtomicLong(0L);

        public MaxPendingContentChannelOutputStream(ContentChannel endpoint, long maxPending) {
            super(endpoint);
            this.maxPending = maxPending;
        }

        private long pendingBytes() {
            return this.sent.get() - this.acked.get();
        }

        @Override
        public void send(ByteBuffer src) throws IOException {
            try {
                this.stallWhilePendingAbove(this.maxPending);
            }
            catch (InterruptedException ignored) {
                throw new IOException("Interrupted waiting for IO");
            }
            TrackCompletition pendingTracker = new TrackCompletition(src.remaining());
            try {
                this.send(src, pendingTracker);
            }
            catch (Throwable throwable) {
                pendingTracker.failed(throwable);
                throw throwable;
            }
        }

        private void stallWhilePendingAbove(long pending) throws InterruptedException {
            while (this.pendingBytes() > pending) {
                Thread.sleep(1L);
            }
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            try {
                this.stallWhilePendingAbove(0L);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted waiting for IO");
            }
        }

        private class TrackCompletition
        implements CompletionHandler {
            private final long written;
            private final AtomicBoolean replied = new AtomicBoolean(false);

            TrackCompletition(long written) {
                this.written = written;
                MaxPendingContentChannelOutputStream.this.sent.addAndGet(written);
            }

            public void completed() {
                if (!this.replied.getAndSet(true)) {
                    MaxPendingContentChannelOutputStream.this.acked.addAndGet(this.written);
                }
            }

            public void failed(Throwable t) {
                if (!this.replied.getAndSet(true)) {
                    MaxPendingContentChannelOutputStream.this.acked.addAndGet(this.written);
                }
            }
        }
    }
}

