/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class Path {
    private final String pathString;
    private final String optionalPrefix;
    private final String[] elements;
    private final Map<String, String> values = new HashMap<String, String>();
    private String rest = "";

    @Deprecated
    public Path(String path) {
        this(path, "");
    }

    @Deprecated
    public Path(String path, String optionalPrefix) {
        this.optionalPrefix = optionalPrefix;
        this.pathString = path;
        this.elements = path.split("/");
    }

    public Path(URI uri) {
        this(uri, "");
    }

    public Path(URI uri, String optionalPrefix) {
        this.optionalPrefix = optionalPrefix;
        this.pathString = uri.getRawPath();
        this.elements = (String[])Stream.of(this.pathString.split("/")).map(part -> URLDecoder.decode(part, StandardCharsets.UTF_8)).toArray(String[]::new);
    }

    private boolean matchesInner(String pathSpec) {
        this.values.clear();
        String[] specElements = pathSpec.split("/");
        boolean matchPrefix = false;
        if (specElements.length > 1 && specElements[specElements.length - 1].equals("{*}")) {
            matchPrefix = true;
            specElements = Arrays.copyOf(specElements, specElements.length - 1);
        }
        if (matchPrefix ? this.elements.length < specElements.length : this.elements.length != specElements.length) {
            return false;
        }
        for (int i = 0; i < specElements.length; ++i) {
            if (specElements[i].startsWith("{") && specElements[i].endsWith("}")) {
                this.values.put(specElements[i].substring(1, specElements[i].length() - 1), this.elements[i]);
                continue;
            }
            if (specElements[i].equals(this.elements[i])) continue;
            return false;
        }
        if (matchPrefix) {
            StringBuilder rest = new StringBuilder();
            for (int i = specElements.length; i < this.elements.length; ++i) {
                rest.append(this.elements[i]).append("/");
            }
            if (!this.pathString.endsWith("/") && rest.length() > 0) {
                rest.setLength(rest.length() - 1);
            }
            this.rest = rest.toString();
        }
        return true;
    }

    public boolean matches(String pathSpec) {
        if (this.matchesInner(pathSpec)) {
            return true;
        }
        if (this.optionalPrefix.isEmpty()) {
            return false;
        }
        return this.matchesInner(this.optionalPrefix + pathSpec);
    }

    public String get(String placeholder) {
        return this.values.get(placeholder);
    }

    public String getRest() {
        return this.rest;
    }

    public String asString() {
        return this.pathString;
    }

    public String toString() {
        return "path '" + String.join((CharSequence)"/", this.elements) + "'";
    }
}

