/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.metrics;

import ai.vespa.util.http.VespaHttpClientBuilder;
import com.google.inject.Inject;
import com.yahoo.container.handler.metrics.ErrorResponse;
import com.yahoo.container.handler.metrics.HttpHandlerBase;
import com.yahoo.container.handler.metrics.MetricsProxyApiConfig;
import com.yahoo.container.handler.metrics.MetricsV2Handler;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.restapi.Path;
import com.yahoo.restapi.StringResponse;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;

public class PrometheusV1Handler
extends HttpHandlerBase {
    public static final String V1_PATH = "/prometheus/v1";
    static final String VALUES_PATH = "/prometheus/v1/values";
    private static final int HTTP_CONNECT_TIMEOUT = 5000;
    private static final int HTTP_SOCKET_TIMEOUT = 30000;
    private final String metricsProxyUri;
    private final HttpClient httpClient = PrometheusV1Handler.createHttpClient();

    @Inject
    public PrometheusV1Handler(Executor executor, MetricsProxyApiConfig config) {
        super(executor);
        this.metricsProxyUri = "http://localhost:" + config.metricsPort() + config.prometheusApiPath();
    }

    @Override
    protected Optional<HttpResponse> doHandle(URI requestUri, Path apiPath, String consumer) {
        if (apiPath.matches(V1_PATH)) {
            return Optional.of(this.resourceListResponse(requestUri, List.of(VALUES_PATH)));
        }
        if (apiPath.matches(VALUES_PATH)) {
            return Optional.of(this.valuesResponse(consumer));
        }
        return Optional.empty();
    }

    private HttpResponse valuesResponse(String consumer) {
        try {
            String uri = this.metricsProxyUri + MetricsV2Handler.consumerQuery(consumer);
            String prometheusText = (String)this.httpClient.execute((HttpUriRequest)new HttpGet(uri), (ResponseHandler)new BasicResponseHandler());
            return new StringResponse(prometheusText);
        }
        catch (IOException e) {
            this.log.warning("Unable to retrieve metrics from " + this.metricsProxyUri + ": " + Exceptions.toMessageString((Throwable)e));
            return new ErrorResponse(500, e.getMessage());
        }
    }

    private static CloseableHttpClient createHttpClient() {
        return VespaHttpClientBuilder.create().setUserAgent("application-prometheus-receiver").setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(30000).build()).build();
    }
}

