/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.request;

import com.google.common.collect.ImmutableList;
import com.yahoo.text.Lowercase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class CompoundName {
    private final String name;
    private final String lowerCasedName;
    private final ImmutableList<String> compounds;
    private final int hashCode;
    private final CompoundName rest;
    public static final CompoundName empty = new CompoundName("");

    public CompoundName(String name) {
        this(name, CompoundName.parse(name));
    }

    public static CompoundName fromComponents(String ... components) {
        return new CompoundName(Arrays.asList(components));
    }

    public CompoundName(List<String> compounds) {
        this(CompoundName.toCompoundString(compounds), compounds);
    }

    private CompoundName(String name, List<String> compounds) {
        if (name == null) {
            throw new NullPointerException("Name can not be null");
        }
        this.name = name;
        this.lowerCasedName = Lowercase.toLowerCase((String)name);
        this.compounds = compounds.size() == 1 && compounds.get(0).isEmpty() ? ImmutableList.of() : ImmutableList.copyOf(compounds);
        this.hashCode = this.compounds.hashCode();
        int size = this.compounds.size();
        this.rest = size > 1 ? new CompoundName(compounds.subList(1, size)) : (size == 1 ? empty : this);
    }

    private static List<String> parse(String s) {
        ArrayList<String> l = null;
        int p = 0;
        int m = s.length();
        for (int i = 0; i < m; ++i) {
            if (s.charAt(i) != '.') continue;
            if (l == null) {
                l = new ArrayList<String>(8);
            }
            l.add(s.substring(p, i));
            p = i + 1;
        }
        if (p == 0) {
            return ImmutableList.of((Object)s);
        }
        if (p >= m) {
            throw new IllegalArgumentException("'" + s + "' is not a legal compound name. Names can not end with a dot.");
        }
        l.add(s.substring(p, m));
        return l;
    }

    public CompoundName append(String name) {
        if (name.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return new CompoundName(name);
        }
        ArrayList<String> newCompounds = new ArrayList<String>((Collection<String>)this.compounds);
        newCompounds.addAll(CompoundName.parse(name));
        return new CompoundName(this.concat(this.name, name), newCompounds);
    }

    public CompoundName append(CompoundName name) {
        if (name.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return name;
        }
        ArrayList<String> newCompounds = new ArrayList<String>((Collection<String>)this.compounds);
        newCompounds.addAll((Collection<String>)name.compounds);
        return new CompoundName(this.concat(this.name, name.name), newCompounds);
    }

    private String concat(String name1, String name2) {
        return name1 + "." + name2;
    }

    public CompoundName prepend(String ... nameParts) {
        if (nameParts.length == 0) {
            return this;
        }
        if (this.isEmpty()) {
            return CompoundName.fromComponents(nameParts);
        }
        ArrayList<String> newCompounds = new ArrayList<String>(nameParts.length + this.compounds.size());
        newCompounds.addAll(Arrays.asList(nameParts));
        newCompounds.addAll((Collection<String>)this.compounds);
        return new CompoundName(newCompounds);
    }

    public String last() {
        if (this.compounds.isEmpty()) {
            return "";
        }
        return (String)this.compounds.get(this.compounds.size() - 1);
    }

    public String first() {
        if (this.compounds.isEmpty()) {
            return "";
        }
        return (String)this.compounds.get(0);
    }

    public CompoundName first(int n) {
        if (this.compounds.size() < n) {
            throw new IllegalArgumentException("Asked for the first " + n + " components but '" + this + "' only have " + this.compounds.size() + " components.");
        }
        return new CompoundName((List<String>)this.compounds.subList(0, n));
    }

    public CompoundName rest() {
        return this.rest;
    }

    public CompoundName rest(int n) {
        if (n == 0) {
            return this;
        }
        if (this.compounds.size() < n) {
            throw new IllegalArgumentException("Asked for the rest after " + n + " components but '" + this + "' only have " + this.compounds.size() + " components.");
        }
        if (n == 1) {
            return this.rest();
        }
        if (this.compounds.size() == n) {
            return empty;
        }
        return this.rest.rest(n - 1);
    }

    public int size() {
        return this.compounds.size();
    }

    public String get(int i) {
        return (String)this.compounds.get(i);
    }

    public CompoundName set(int i, String name) {
        if (this.get(i) == name) {
            return this;
        }
        ArrayList<String> newCompounds = new ArrayList<String>((Collection<String>)this.compounds);
        newCompounds.set(i, name);
        return new CompoundName(newCompounds);
    }

    public boolean isCompound() {
        return this.compounds.size() > 1;
    }

    public boolean isEmpty() {
        return this.compounds.isEmpty();
    }

    public boolean hasPrefix(CompoundName prefix) {
        if (prefix.size() > this.size()) {
            return false;
        }
        int prefixLength = prefix.name.length();
        if (prefixLength == 0) {
            return true;
        }
        if (this.name.length() > prefixLength && this.name.charAt(prefixLength) != '.') {
            return false;
        }
        return this.name.startsWith(prefix.name);
    }

    public List<String> asList() {
        return this.compounds;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompoundName)) {
            return false;
        }
        CompoundName other = (CompoundName)o;
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }

    public String getLowerCasedName() {
        return this.lowerCasedName;
    }

    private static String toCompoundString(List<String> compounds) {
        StringBuilder b = new StringBuilder();
        for (String compound : compounds) {
            b.append(compound).append(".");
        }
        return b.length() == 0 ? "" : b.substring(0, b.length() - 1);
    }
}

