/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.test;

import com.google.common.annotations.Beta;
import com.yahoo.container.handler.test.MockServiceHandler;
import com.yahoo.container.handler.test.MockserviceConfig;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.HttpRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@Beta
public class MockService
extends LoggingRequestHandler {
    private final MockServiceHandler handler;

    public MockService(Executor executor, FileAcquirer fileAcquirer, MockserviceConfig config, Metric metric) throws InterruptedException, IOException {
        super(executor, metric);
        File dataFile = fileAcquirer.waitFor(config.file(), config.fileAcquirerTimeout(), TimeUnit.SECONDS);
        this.handler = this.createHandler(dataFile);
    }

    protected MockServiceHandler createHandler(File dataFile) throws IOException {
        if (!dataFile.getName().endsWith(".txt")) {
            throw new IllegalArgumentException("Default handler only support .txt files");
        }
        return new TextFileHandler(dataFile);
    }

    @Override
    public final HttpResponse handle(HttpRequest request) {
        try {
            MockServiceHandler.Key key = this.handler.createKey(request);
            MockServiceHandler.Value value = this.handler.get(key);
            if (value == null) {
                return new ErrorResponse(404, key + " was not found");
            }
            return new RawResponse(value.returnCode, value.data, value.contentType);
        }
        catch (Exception e) {
            return new ExceptionResponse(500, e);
        }
    }

    private static class ExceptionResponse
    extends HttpResponse {
        private final Exception e;

        public ExceptionResponse(int code, Exception e) {
            super(code);
            this.e = e;
        }

        @Override
        public void render(OutputStream outputStream) throws IOException {
            try (PrintStream ps = new PrintStream(outputStream);){
                this.e.printStackTrace(ps);
            }
        }
    }

    private static final class TextKey
    implements MockServiceHandler.Key {
        private final HttpRequest.Method method;
        private final String path;

        public TextKey(HttpRequest.Method method, String path) {
            this.method = method;
            this.path = path;
        }

        @Override
        public int hashCode() {
            return this.path.hashCode() + this.method.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other.getClass() != TextKey.class) {
                return false;
            }
            TextKey rhs = (TextKey)other;
            return this.method == rhs.method && this.path.equals(rhs.path);
        }

        public String toString() {
            return this.method.toString() + ":" + this.path;
        }
    }

    private static class ErrorResponse
    extends RawResponse {
        ErrorResponse(int status, String message) {
            super(status, message.getBytes(), "text/plain");
        }
    }

    private static class RawResponse
    extends HttpResponse {
        private final String contentType;
        private final byte[] data;

        RawResponse(int status, byte[] data, String contentType) {
            super(status);
            this.data = data;
            this.contentType = contentType;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public void render(OutputStream outputStream) throws IOException {
            outputStream.write(this.data);
        }
    }

    private static class TextFileHandler
    implements MockServiceHandler {
        private final Map<MockServiceHandler.Key, MockServiceHandler.Value> store = new HashMap<MockServiceHandler.Key, MockServiceHandler.Value>();

        public TextFileHandler(File dataFile) throws IOException {
            BufferedReader reader = new BufferedReader(new FileReader(dataFile));
            this.readInputFile(reader);
        }

        private void readInputFile(BufferedReader reader) throws IOException {
            int ch;
            StringBuilder sb = new StringBuilder();
            char prevChar = '\u0000';
            while ((ch = reader.read()) >= 0) {
                char c = (char)ch;
                if (prevChar == '\n') {
                    if (c == '\n') {
                        this.parseEntry(sb.toString());
                        sb = new StringBuilder();
                        prevChar = '\u0000';
                        continue;
                    }
                    sb.append(prevChar);
                }
                if (c != '\n') {
                    sb.append(c);
                }
                prevChar = c;
            }
            this.parseEntry(sb.toString());
        }

        private void parseEntry(String entry) {
            String[] components = entry.split(":", 4);
            TextKey key = new TextKey(HttpRequest.Method.valueOf((String)components[0]), components[1]);
            MockServiceHandler.Value value = new MockServiceHandler.Value(Integer.parseInt(components[2]), components[3].getBytes(), "text/plain");
            this.store.put(key, value);
        }

        @Override
        public MockServiceHandler.Key createKey(HttpRequest request) {
            StringBuilder sb = new StringBuilder();
            sb.append(request.getUri().getPath());
            String query = request.getUri().getQuery();
            if (query != null) {
                sb.append("?").append(query);
            }
            return new TextKey(request.getMethod(), sb.toString());
        }

        @Override
        public MockServiceHandler.Value get(MockServiceHandler.Key key) {
            return this.store.get(key);
        }
    }
}

