/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class Path {
    private final String pathString;
    private final String optionalPrefix;
    private final String[] elements;
    private final Map<String, String> values = new HashMap<String, String>();
    private String rest = "";

    public Path(String path) {
        this.optionalPrefix = "";
        this.pathString = path;
        this.elements = path.split("/");
    }

    public Path(String path, String optionalPrefix) {
        this.optionalPrefix = optionalPrefix;
        this.pathString = path;
        this.elements = path.split("/");
    }

    private boolean matches_inner(String pathSpec) {
        this.values.clear();
        String[] specElements = pathSpec.split("/");
        boolean matchPrefix = false;
        if (specElements[specElements.length - 1].equals("{*}")) {
            matchPrefix = true;
            specElements = Arrays.copyOf(specElements, specElements.length - 1);
        }
        if (matchPrefix ? this.elements.length < specElements.length : this.elements.length != specElements.length) {
            return false;
        }
        for (int i = 0; i < specElements.length; ++i) {
            if (specElements[i].startsWith("{") && specElements[i].endsWith("}")) {
                this.values.put(specElements[i].substring(1, specElements[i].length() - 1), this.elements[i]);
                continue;
            }
            if (specElements[i].equals(this.elements[i])) continue;
            return false;
        }
        if (matchPrefix) {
            StringBuilder rest = new StringBuilder();
            for (int i = specElements.length; i < this.elements.length; ++i) {
                rest.append(this.elements[i]).append("/");
            }
            if (!this.pathString.endsWith("/") && rest.length() > 0) {
                rest.setLength(rest.length() - 1);
            }
            this.rest = rest.toString();
        }
        return true;
    }

    public boolean matches(String pathSpec) {
        if (this.matches_inner(pathSpec)) {
            return true;
        }
        if (this.optionalPrefix.isEmpty()) {
            return false;
        }
        return this.matches_inner(this.optionalPrefix + pathSpec);
    }

    public String get(String placeholder) {
        return this.values.get(placeholder);
    }

    public String getRest() {
        return this.rest;
    }

    public String asString() {
        return this.pathString;
    }

    public String toString() {
        return "path '" + Arrays.stream(this.elements).collect(Collectors.joining("/")) + "'";
    }
}

