/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.google.inject.Inject;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.jdisc.application.UriPattern;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.BufferedContentChannel;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.OverloadException;
import com.yahoo.jdisc.handler.ReadableContentChannel;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ThreadedRequestHandler
extends AbstractRequestHandler {
    private static final Logger log = Logger.getLogger(ThreadedRequestHandler.class.getName());
    private static final Duration TIMEOUT = Duration.ofSeconds(Integer.parseInt(System.getProperty("ThreadedRequestHandler.timeout", "300")));
    private final Executor executor;
    protected final Metric metric;
    private final boolean allowAsyncResponse;
    private static final Object rejectedExecutionsLock = new Object();
    private static volatile int numRejectedRequests = 0;
    private static long currentFailureIntervalStartedMillis = 0L;

    protected ThreadedRequestHandler(Executor executor) {
        this(executor, new NullRequestMetric());
    }

    @Inject
    protected ThreadedRequestHandler(Executor executor, Metric metric) {
        this(executor, metric, false);
    }

    @Inject
    protected ThreadedRequestHandler(Executor executor, Metric metric, boolean allowAsyncResponse) {
        this.executor = Objects.requireNonNull(executor);
        this.metric = metric == null ? new NullRequestMetric() : metric;
        this.allowAsyncResponse = allowAsyncResponse;
    }

    Metric.Context contextFor(Request request, Map<String, String> extraDimensions) {
        BindingMatch match = request.getBindingMatch();
        if (match == null) {
            return null;
        }
        UriPattern matched = match.matched();
        if (matched == null) {
            return null;
        }
        String name = matched.toString();
        String endpoint = request.headers().containsKey((Object)"Host") ? (String)request.headers().get((Object)"Host").get(0) : null;
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("handler", name);
        if (endpoint != null) {
            dimensions.put("endpoint", endpoint);
        }
        URI uri = request.getUri();
        dimensions.put("scheme", uri.getScheme());
        dimensions.put("port", Integer.toString(uri.getPort()));
        String handlerClassName = ((Object)((Object)this)).getClass().getName();
        dimensions.put("handler-name", handlerClassName);
        dimensions.putAll(extraDimensions);
        return this.metric.createContext(dimensions);
    }

    private Metric.Context contextFor(Request request) {
        return this.contextFor(request, Map.of());
    }

    public final ContentChannel handleRequest(Request request, ResponseHandler responseHandler) {
        Duration timeout;
        this.metric.add("handled.requests", (Number)1, this.contextFor(request));
        if (request.getTimeout(TimeUnit.SECONDS) == null && (timeout = this.getTimeout()) != null) {
            request.setTimeout(timeout.getSeconds(), TimeUnit.SECONDS);
        }
        BufferedContentChannel content = new BufferedContentChannel();
        RequestTask command = new RequestTask(request, content, responseHandler);
        try {
            this.executor.execute(command);
        }
        catch (RejectedExecutionException e) {
            command.failOnOverload();
            throw new OverloadException("No available threads for " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)e);
        }
        finally {
            this.logRejectedRequests();
        }
        return content;
    }

    public Duration getTimeout() {
        return TIMEOUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logRejectedRequests() {
        int numRejectedRequestsSnapshot;
        if (numRejectedRequests == 0) {
            return;
        }
        Object object = rejectedExecutionsLock;
        synchronized (object) {
            if (System.currentTimeMillis() - currentFailureIntervalStartedMillis < 1000L) {
                return;
            }
            numRejectedRequestsSnapshot = numRejectedRequests;
            currentFailureIntervalStartedMillis = 0L;
            numRejectedRequests = 0;
        }
        log.log(Level.WARNING, "Rejected " + numRejectedRequestsSnapshot + " requests on cause of no available worker threads.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementRejectedRequests() {
        Object object = rejectedExecutionsLock;
        synchronized (object) {
            if (numRejectedRequests == 0) {
                currentFailureIntervalStartedMillis = System.currentTimeMillis();
            }
            ++numRejectedRequests;
        }
    }

    protected abstract void handleRequest(Request var1, BufferedContentChannel var2, ResponseHandler var3);

    protected void writeErrorResponseOnOverload(Request request, ResponseHandler responseHandler) {
        ResponseDispatch.newInstance((int)503, (ByteBuffer[])new ByteBuffer[0]).dispatch(responseHandler);
    }

    private static class NullRequestMetric
    implements Metric {
        private NullRequestMetric() {
        }

        public void set(String key, Number val, Metric.Context ctx) {
        }

        public void add(String key, Number val, Metric.Context ctx) {
        }

        public Metric.Context createContext(Map<String, ?> properties) {
            return NullFeedContext.INSTANCE;
        }

        private static class NullFeedContext
        implements Metric.Context {
            private static final NullFeedContext INSTANCE = new NullFeedContext();

            private NullFeedContext() {
            }
        }
    }

    private class RequestTask
    implements ResponseHandler,
    Runnable {
        final Request request;
        private final ResourceReference requestReference;
        final BufferedContentChannel content;
        final ResponseHandler responseHandler;
        private boolean hasResponded = false;

        RequestTask(Request request, BufferedContentChannel content, ResponseHandler responseHandler) {
            this.request = request;
            this.requestReference = request.refer();
            this.content = content;
            this.responseHandler = responseHandler;
        }

        @Override
        public void run() {
            try (ResourceReference reference = this.requestReference;){
                this.processRequest();
            }
        }

        private void processRequest() {
            try {
                ThreadedRequestHandler.this.handleRequest(this.request, this.content, this);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Uncaught exception in " + ((Object)((Object)ThreadedRequestHandler.this)).getClass().getName() + ".", e);
            }
            this.consumeRequestContent();
            if (!ThreadedRequestHandler.this.allowAsyncResponse) {
                this.respondWithErrorIfNotResponded();
            }
        }

        public ContentChannel handleResponse(Response response) {
            if (this.tryHasResponded()) {
                throw new IllegalStateException("Response already handled");
            }
            ContentChannel cc = this.responseHandler.handleResponse(response);
            long millis = this.request.timeElapsed(TimeUnit.MILLISECONDS);
            ThreadedRequestHandler.this.metric.set("handled.latency", (Number)millis, ThreadedRequestHandler.this.contextFor(this.request));
            return cc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tryHasResponded() {
            RequestTask requestTask = this;
            synchronized (requestTask) {
                if (this.hasResponded) {
                    return true;
                }
                this.hasResponded = true;
            }
            return false;
        }

        private void respondWithErrorIfNotResponded() {
            if (this.tryHasResponded()) {
                return;
            }
            ResponseDispatch.newInstance((int)500, (ByteBuffer[])new ByteBuffer[0]).dispatch(this.responseHandler);
            log.warning("This handler is not async but did not produce a response. Responding with status 500.(If this handler is async, pass a boolean true in the super constructor to avoid this.)");
        }

        private void consumeRequestContent() {
            if (this.content.isConnected()) {
                return;
            }
            ReadableContentChannel requestContent = new ReadableContentChannel();
            try {
                this.content.connectTo((ContentChannel)requestContent);
            }
            catch (IllegalStateException e) {
                return;
            }
            while (requestContent.read() != null) {
            }
        }

        void failOnOverload() {
            try (ResourceReference reference = this.requestReference;){
                ThreadedRequestHandler.this.incrementRejectedRequests();
                ThreadedRequestHandler.this.logRejectedRequests();
                ThreadedRequestHandler.this.writeErrorResponseOnOverload(this.request, this.responseHandler);
            }
        }
    }
}

