/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.documentapi;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.AsyncParameters;
import com.yahoo.documentapi.AsyncSession;
import com.yahoo.documentapi.DocumentAccess;
import com.yahoo.documentapi.DocumentAccessParams;
import com.yahoo.documentapi.SubscriptionParameters;
import com.yahoo.documentapi.SubscriptionSession;
import com.yahoo.documentapi.SyncParameters;
import com.yahoo.documentapi.SyncSession;
import com.yahoo.documentapi.VisitorDestinationParameters;
import com.yahoo.documentapi.VisitorDestinationSession;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.messagebus.MessageBusDocumentAccess;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.documentapi.messagebus.loadtypes.LoadTypeSet;
import com.yahoo.vespa.config.content.LoadTypeConfig;

public class MessageBusDocumentAccessProvider
extends AbstractComponent
implements Provider<DocumentAccess> {
    private final DocumentAccess access;

    @Inject
    public MessageBusDocumentAccessProvider(DocumentmanagerConfig documentmanagerConfig, LoadTypeConfig loadTypeConfig) {
        this.access = new LazyForwardingMessageBusDocumentAccess(documentmanagerConfig, loadTypeConfig);
    }

    public DocumentAccess get() {
        return this.access;
    }

    public void deconstruct() {
        this.access.shutdown();
    }

    private static class LazyForwardingMessageBusDocumentAccess
    extends DocumentAccess {
        private final DocumentmanagerConfig documentmanagerConfig;
        private final LoadTypeConfig loadTypeConfig;
        private final Object monitor = new Object();
        private DocumentAccess delegate = null;
        private boolean shutDown = false;

        public LazyForwardingMessageBusDocumentAccess(DocumentmanagerConfig documentmanagerConfig, LoadTypeConfig loadTypeConfig) {
            super(new DocumentAccessParams().setDocumentmanagerConfig(documentmanagerConfig));
            this.documentmanagerConfig = documentmanagerConfig;
            this.loadTypeConfig = loadTypeConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DocumentAccess delegate() {
            Object object = this.monitor;
            synchronized (object) {
                if (this.delegate == null) {
                    if (this.shutDown) {
                        throw new IllegalStateException("This document access has been shut down");
                    }
                    this.delegate = new MessageBusDocumentAccess((MessageBusParams)new MessageBusParams(new LoadTypeSet(this.loadTypeConfig)).setDocumentmanagerConfig(this.documentmanagerConfig));
                }
                return this.delegate;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.monitor;
            synchronized (object) {
                super.shutdown();
                this.shutDown = true;
                if (this.delegate != null) {
                    this.delegate.shutdown();
                }
            }
        }

        public SyncSession createSyncSession(SyncParameters parameters) {
            return this.delegate().createSyncSession(parameters);
        }

        public AsyncSession createAsyncSession(AsyncParameters parameters) {
            return this.delegate().createAsyncSession(parameters);
        }

        public VisitorSession createVisitorSession(VisitorParameters parameters) throws ParseException {
            return this.delegate().createVisitorSession(parameters);
        }

        public VisitorDestinationSession createVisitorDestinationSession(VisitorDestinationParameters parameters) {
            return this.delegate().createVisitorDestinationSession(parameters);
        }

        public SubscriptionSession createSubscription(SubscriptionParameters parameters) {
            return this.delegate().createSubscription(parameters);
        }

        public SubscriptionSession openSubscription(SubscriptionParameters parameters) {
            return this.delegate().openSubscription(parameters);
        }
    }
}

