/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.container.handler.threadpool.ContainerThreadPool;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.container.protect.ProcessTerminator;
import com.yahoo.jdisc.Metric;
import java.util.concurrent.Executor;

public class ThreadPoolProvider
extends AbstractComponent
implements Provider<Executor> {
    private final ContainerThreadPool threadpool;

    @Inject
    public ThreadPoolProvider(ThreadpoolConfig config, Metric metric) {
        this.threadpool = new ContainerThreadPool(ThreadPoolProvider.translateConfig(config), metric);
    }

    public ThreadPoolProvider(ThreadpoolConfig config, Metric metric, ProcessTerminator processTerminator) {
        this.threadpool = new ContainerThreadPool(ThreadPoolProvider.translateConfig(config), metric, processTerminator);
    }

    private static ContainerThreadpoolConfig translateConfig(ThreadpoolConfig config) {
        return new ContainerThreadpoolConfig(new ContainerThreadpoolConfig.Builder().maxThreads(config.maxthreads()).minThreads(config.corePoolSize()).name(config.name()).queueSize(config.queueSize()).keepAliveTime(config.keepAliveTime()).maxThreadExecutionTimeSeconds(config.maxThreadExecutionTimeSeconds()));
    }

    public Executor get() {
        return this.threadpool.executor();
    }

    public void deconstruct() {
        this.threadpool.close();
    }
}

