/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.restapi.SlimeJsonResponse;
import com.yahoo.restapi.Uri;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import java.net.URI;
import java.util.List;

public class ResourceResponse
extends SlimeJsonResponse {
    public ResourceResponse(URI parentUrl, List<String> subResources) {
        super(200, ResourceResponse.toSlime(parentUrl, subResources));
    }

    public ResourceResponse(URI parentUrl, String ... subResources) {
        this(parentUrl, List.of(subResources));
    }

    public ResourceResponse(HttpRequest request, String ... subResources) {
        this(request.getUri(), subResources);
    }

    private static Slime toSlime(URI parentUrl, List<String> subResources) {
        Slime slime = new Slime();
        Cursor resourceArray = slime.setObject().setArray("resources");
        for (String subResource : subResources) {
            Cursor resourceEntry = resourceArray.addObject();
            resourceEntry.setString("url", new Uri(parentUrl).append(subResource).withTrailingSlash().toString());
        }
        return slime;
    }
}

