/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.IntegerNode;
import java.util.HashSet;
import java.util.Set;

public final class ThreadpoolConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "083e5f0aa77da439fa1bd74106bcf35a";
    public static final String CONFIG_DEF_NAME = "threadpool";
    public static final String CONFIG_DEF_NAMESPACE = "container.handler";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container.handler", "maxthreads int default=500", "queueSize int default=0", "maxThreadExecutionTimeSeconds int default=190", "softStartSeconds double default=0"};
    private final IntegerNode maxthreads;
    private final IntegerNode queueSize;
    private final IntegerNode maxThreadExecutionTimeSeconds;
    private final DoubleNode softStartSeconds;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ThreadpoolConfig(Builder builder) {
        this(builder, true);
    }

    private ThreadpoolConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for threadpool must be initialized: " + builder.__uninitialized);
        }
        this.maxthreads = builder.maxthreads == null ? new IntegerNode(500) : new IntegerNode(builder.maxthreads.intValue());
        this.queueSize = builder.queueSize == null ? new IntegerNode(0) : new IntegerNode(builder.queueSize.intValue());
        this.maxThreadExecutionTimeSeconds = builder.maxThreadExecutionTimeSeconds == null ? new IntegerNode(190) : new IntegerNode(builder.maxThreadExecutionTimeSeconds.intValue());
        this.softStartSeconds = builder.softStartSeconds == null ? new DoubleNode(0.0) : new DoubleNode(builder.softStartSeconds.doubleValue());
    }

    public int maxthreads() {
        return this.maxthreads.value();
    }

    public int queueSize() {
        return this.queueSize.value();
    }

    public int maxThreadExecutionTimeSeconds() {
        return this.maxThreadExecutionTimeSeconds.value();
    }

    public double softStartSeconds() {
        return this.softStartSeconds.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ThreadpoolConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer maxthreads = null;
        private Integer queueSize = null;
        private Integer maxThreadExecutionTimeSeconds = null;
        private Double softStartSeconds = null;

        public Builder() {
        }

        public Builder(ThreadpoolConfig config) {
            this.maxthreads(config.maxthreads());
            this.queueSize(config.queueSize());
            this.maxThreadExecutionTimeSeconds(config.maxThreadExecutionTimeSeconds());
            this.softStartSeconds(config.softStartSeconds());
        }

        private Builder override(Builder __superior) {
            if (__superior.maxthreads != null) {
                this.maxthreads(__superior.maxthreads);
            }
            if (__superior.queueSize != null) {
                this.queueSize(__superior.queueSize);
            }
            if (__superior.maxThreadExecutionTimeSeconds != null) {
                this.maxThreadExecutionTimeSeconds(__superior.maxThreadExecutionTimeSeconds);
            }
            if (__superior.softStartSeconds != null) {
                this.softStartSeconds(__superior.softStartSeconds);
            }
            return this;
        }

        public Builder maxthreads(int __value) {
            this.maxthreads = __value;
            return this;
        }

        private Builder maxthreads(String __value) {
            return this.maxthreads(Integer.valueOf(__value));
        }

        public Builder queueSize(int __value) {
            this.queueSize = __value;
            return this;
        }

        private Builder queueSize(String __value) {
            return this.queueSize(Integer.valueOf(__value));
        }

        public Builder maxThreadExecutionTimeSeconds(int __value) {
            this.maxThreadExecutionTimeSeconds = __value;
            return this;
        }

        private Builder maxThreadExecutionTimeSeconds(String __value) {
            return this.maxThreadExecutionTimeSeconds(Integer.valueOf(__value));
        }

        public Builder softStartSeconds(double __value) {
            this.softStartSeconds = __value;
            return this;
        }

        private Builder softStartSeconds(String __value) {
            return this.softStartSeconds(Double.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ThreadpoolConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ThreadpoolConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ThreadpoolConfig.CONFIG_DEF_NAMESPACE;
        }

        public ThreadpoolConfig build() {
            return new ThreadpoolConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

