/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.google.inject.Inject;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.core.VipStatusConfig;
import com.yahoo.container.handler.ClustersStatus;

public class VipStatus {
    private final ClustersStatus clustersStatus;
    private Boolean inRotationOverride;

    public VipStatus() {
        this(new QrSearchersConfig(new QrSearchersConfig.Builder()), new VipStatusConfig(new VipStatusConfig.Builder()), new ClustersStatus());
    }

    public VipStatus(QrSearchersConfig dispatchers) {
        this(dispatchers, new VipStatusConfig(new VipStatusConfig.Builder()), new ClustersStatus());
    }

    public VipStatus(ClustersStatus clustersStatus) {
        this.clustersStatus = clustersStatus;
    }

    @Inject
    public VipStatus(QrSearchersConfig dispatchers, VipStatusConfig vipStatusConfig, ClustersStatus clustersStatus) {
        this.clustersStatus = clustersStatus;
        clustersStatus.setReceiveTrafficByDefault(vipStatusConfig.initiallyInRotation());
        clustersStatus.setContainerHasClusters(!dispatchers.searchcluster().isEmpty());
    }

    public void setInRotation(Boolean inRotation) {
        this.inRotationOverride = inRotation;
    }

    public void addToRotation(Object clusterIdentifier) {
        this.clustersStatus.setUp(clusterIdentifier);
    }

    public void removeFromRotation(Object clusterIdentifier) {
        this.clustersStatus.setDown(clusterIdentifier);
    }

    public boolean isInRotation() {
        if (this.inRotationOverride != null) {
            return this.inRotationOverride;
        }
        return this.clustersStatus.containerShouldReceiveTraffic();
    }
}

