/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import java.util.HashMap;
import java.util.Map;

public class ClustersStatus
extends AbstractComponent {
    private boolean containerHasClusters;
    private boolean receiveTrafficByDefault;
    private final Object mutex = new Object();
    private final Map<Object, Boolean> clusterStatus = new HashMap<Object, Boolean>();

    @Inject
    public ClustersStatus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainerHasClusters(boolean containerHasClusters) {
        Object object = this.mutex;
        synchronized (object) {
            this.containerHasClusters = containerHasClusters;
            if (!containerHasClusters) {
                this.clusterStatus.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceiveTrafficByDefault(boolean receiveTrafficByDefault) {
        Object object = this.mutex;
        synchronized (object) {
            this.receiveTrafficByDefault = receiveTrafficByDefault;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp(Object clusterIdentifier) {
        Object object = this.mutex;
        synchronized (object) {
            this.clusterStatus.put(clusterIdentifier, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDown(Object clusterIdentifier) {
        Object object = this.mutex;
        synchronized (object) {
            this.clusterStatus.put(clusterIdentifier, Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containerShouldReceiveTraffic() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.containerHasClusters) {
                return this.clusterStatus.values().stream().anyMatch(status -> status == true);
            }
            return this.receiveTrafficByDefault;
        }
    }
}

