/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.osgi;

import com.yahoo.container.osgi.AbstractRpcAdaptor;
import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.jrt.slobrok.api.Register;
import com.yahoo.jrt.slobrok.api.SlobrokList;
import com.yahoo.log.LogLevel;
import com.yahoo.net.HostName;
import com.yahoo.osgi.Osgi;
import com.yahoo.yolean.Exceptions;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class ContainerRpcAdaptor
extends AbstractRpcAdaptor {
    private static final Logger log = Logger.getLogger(ContainerRpcAdaptor.class.getName());
    private Acceptor acceptor;
    private final Supervisor supervisor;
    private final Osgi osgi;
    private final String hostname;
    private Optional<String> slobrokId = Optional.empty();
    private Optional<Register> slobrokRegistrator = Optional.empty();

    public ContainerRpcAdaptor(Osgi osgi) {
        this.osgi = osgi;
        this.supervisor = new Supervisor(new Transport());
        this.hostname = HostName.getLocalhost();
        this.bindCommands(this.supervisor);
    }

    public void list(Request request) {
        try {
            StringBuilder buffer = new StringBuilder("Installed bundles:");
            for (Bundle bundle : this.osgi.getBundles()) {
                if (bundle.getSymbolicName().equals("system.bundle")) continue;
                buffer.append("\n");
                buffer.append(bundle.getSymbolicName());
                buffer.append(" (");
                buffer.append(bundle.getLocation());
                buffer.append(")");
            }
            request.returnValues().add((Value)new StringValue(buffer.toString()));
        }
        catch (Exception e) {
            request.setError(111, Exceptions.toMessageString((Throwable)e));
        }
    }

    @Override
    public void bindCommands(Supervisor supervisor) {
        supervisor.addMethod(new Method("list", "", "s", (Object)this, "list"));
    }

    public synchronized void listen(int port) {
        Spec spec = new Spec(port);
        try {
            this.acceptor = this.supervisor.listen(spec);
            log.log((Level)LogLevel.DEBUG, "Added new rpc server listening at port '" + port + "'.");
        }
        catch (ListenFailedException e) {
            throw new RuntimeException("Could not create rpc server listening on " + spec, e);
        }
    }

    public synchronized void setSlobrokId(String slobrokId) {
        this.slobrokId = Optional.of(slobrokId);
    }

    public synchronized void registerInSlobrok(List<String> slobrokConnectionSpecs) {
        this.shutdownSlobrokRegistrator();
        if (slobrokConnectionSpecs.isEmpty()) {
            return;
        }
        if (!this.slobrokId.isPresent()) {
            throw new AssertionError((Object)"Slobrok id must be set first");
        }
        SlobrokList slobrokList = new SlobrokList();
        slobrokList.setup((String[])slobrokConnectionSpecs.stream().toArray(String[]::new));
        Spec mySpec = new Spec(this.hostname, this.acceptor.port());
        Register register = new Register(this.supervisor, slobrokList, mySpec);
        register.registerName(this.slobrokId.get());
        this.slobrokRegistrator = Optional.of(register);
        log.log(LogLevel.INFO, "Registered name '" + this.slobrokId.get() + "' at " + mySpec + " with: " + slobrokList);
    }

    private synchronized void shutdownSlobrokRegistrator() {
        this.slobrokRegistrator.ifPresent(Register::shutdown);
        this.slobrokRegistrator = Optional.empty();
    }

    public synchronized void shutdown() {
        this.shutdownSlobrokRegistrator();
        if (this.acceptor != null) {
            this.acceptor.shutdown().join();
        }
        this.supervisor.transport().shutdown().join();
    }

    public synchronized void bindRpcAdaptor(AbstractRpcAdaptor adaptor) {
        adaptor.bindCommands(this.supervisor);
    }
}

