/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.yahoo.collections.Tuple2;
import com.yahoo.container.handler.Coverage;
import com.yahoo.container.handler.Timing;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.logging.HitCounts;
import com.yahoo.container.protect.Error;
import com.yahoo.jdisc.HeaderFields;
import com.yahoo.processing.request.ErrorMessage;
import java.util.Iterator;

public final class VespaHeaders {
    private static final int GATEWAY_TIMEOUT = 504;
    private static final int BAD_GATEWAY = 502;
    private static final int PRECONDITION_REQUIRED = 428;
    private static final int TOO_MANY_REQUESTS = 429;
    private static final int REQUEST_HEADER_FIELDS_TOO_LARGE = 431;
    private static final int NETWORK_AUTHENTICATION_REQUIRED = 511;
    private static final Tuple2<Boolean, Integer> NO_MATCH = new Tuple2((Object)false, (Object)200);

    public static boolean benchmarkCoverage(boolean benchmarkOutput, HeaderFields headers) {
        return benchmarkOutput && headers.get((Object)"X-Yahoo-Vespa-Benchmarkdata-Coverage") != null;
    }

    public static boolean benchmarkOutput(HttpRequest request) {
        return request.getHeader("X-Yahoo-Vespa-Benchmarkdata") != null;
    }

    public static void benchmarkOutput(HeaderFields responseHeaders, boolean benchmarkCoverage, Timing t, HitCounts c, int errorCount, Coverage coverage) {
        long renderStartTime = System.currentTimeMillis();
        if (c != null) {
            responseHeaders.add("X-Yahoo-Vespa-NumHits", String.valueOf(c.getRetrievedHitCount()));
            responseHeaders.add("X-Yahoo-Vespa-NumFastHits", String.valueOf(c.getSummaryCount()));
            responseHeaders.add("X-Yahoo-Vespa-TotalHitCount", String.valueOf(c.getTotalHitCount()));
            responseHeaders.add("X-Yahoo-Vespa-QueryHits", String.valueOf(c.getRequestedHits()));
            responseHeaders.add("X-Yahoo-Vespa-QueryOffset", String.valueOf(c.getRequestedOffset()));
        }
        responseHeaders.add("X-Yahoo-Vespa-NumErrors", String.valueOf(errorCount));
        if (t != null) {
            if (t.getSummaryStartTime() != 0L) {
                responseHeaders.add("X-Yahoo-Vespa-SearchTime", String.valueOf(t.getSummaryStartTime() - t.getQueryStartTime()));
                responseHeaders.add("X-Yahoo-Vespa-AttributeFetchTime", "0");
                responseHeaders.add("X-Yahoo-Vespa-FillTime", String.valueOf(renderStartTime - t.getSummaryStartTime()));
            } else {
                responseHeaders.add("X-Yahoo-Vespa-SearchTime", String.valueOf(renderStartTime - t.getQueryStartTime()));
                responseHeaders.add("X-Yahoo-Vespa-AttributeFetchTime", "0");
                responseHeaders.add("X-Yahoo-Vespa-FillTime", "0");
            }
        }
        if (benchmarkCoverage && coverage != null) {
            responseHeaders.add("X-Yahoo-Vespa-DocsSearched", String.valueOf(coverage.getDocs()));
            responseHeaders.add("X-Yahoo-Vespa-NodesSearched", String.valueOf(coverage.getNodes()));
            responseHeaders.add("X-Yahoo-Vespa-FullCoverage", String.valueOf(coverage.getFull() ? 1 : 0));
        }
    }

    public static int getStatus(boolean isSuccess, ErrorMessage mainError, Iterator<? extends ErrorMessage> allErrors) {
        if (isSuccess) {
            Tuple2<Boolean, Integer> status = VespaHeaders.webServiceCodes(mainError, allErrors);
            if (((Boolean)status.first).booleanValue()) {
                return (Integer)status.second;
            }
            return 200;
        }
        return VespaHeaders.getEagerErrorStatus(mainError, allErrors);
    }

    private static Tuple2<Boolean, Integer> webServiceCodes(ErrorMessage mainError, Iterator<? extends ErrorMessage> allErrors) {
        if (mainError == null) {
            return NO_MATCH;
        }
        Iterator<? extends ErrorMessage> errorIterator = allErrors;
        if (errorIterator != null && errorIterator.hasNext()) {
            while (errorIterator.hasNext()) {
                ErrorMessage error = errorIterator.next();
                Tuple2<Boolean, Integer> status = VespaHeaders.chooseWebServiceStatus(error);
                if (!((Boolean)status.first).booleanValue()) continue;
                return status;
            }
        } else {
            Tuple2<Boolean, Integer> status = VespaHeaders.chooseWebServiceStatus(mainError);
            if (((Boolean)status.first).booleanValue()) {
                return status;
            }
        }
        return NO_MATCH;
    }

    private static Tuple2<Boolean, Integer> chooseWebServiceStatus(ErrorMessage error) {
        if (VespaHeaders.isHttpStatusCode(error.getCode())) {
            return new Tuple2((Object)true, (Object)error.getCode());
        }
        if (error.getCode() == Error.FORBIDDEN.code) {
            return new Tuple2((Object)true, (Object)403);
        }
        if (error.getCode() == Error.UNAUTHORIZED.code) {
            return new Tuple2((Object)true, (Object)401);
        }
        if (error.getCode() == Error.NOT_FOUND.code) {
            return new Tuple2((Object)true, (Object)404);
        }
        if (error.getCode() == Error.BAD_REQUEST.code) {
            return new Tuple2((Object)true, (Object)400);
        }
        if (error.getCode() == Error.INTERNAL_SERVER_ERROR.code) {
            return new Tuple2((Object)true, (Object)500);
        }
        return NO_MATCH;
    }

    private static boolean isHttpStatusCode(int code) {
        switch (code) {
            case 200: 
            case 301: 
            case 302: 
            case 307: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 408: 
            case 428: 
            case 429: 
            case 431: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 511: {
                return true;
            }
        }
        return false;
    }

    public static int getEagerErrorStatus(ErrorMessage mainError, Iterator<? extends ErrorMessage> allErrors) {
        if (mainError == null) {
            return 200;
        }
        if (allErrors != null && allErrors.hasNext()) {
            while (allErrors.hasNext()) {
                ErrorMessage error = allErrors.next();
                Tuple2<Boolean, Integer> status = VespaHeaders.chooseStatusFromError(error);
                if (!((Boolean)status.first).booleanValue()) continue;
                return (Integer)status.second;
            }
        } else {
            Tuple2<Boolean, Integer> status = VespaHeaders.chooseStatusFromError(mainError);
            if (((Boolean)status.first).booleanValue()) {
                return (Integer)status.second;
            }
        }
        return 500;
    }

    private static Tuple2<Boolean, Integer> chooseStatusFromError(ErrorMessage error) {
        Tuple2<Boolean, Integer> webServiceStatus = VespaHeaders.chooseWebServiceStatus(error);
        if (((Boolean)webServiceStatus.first).booleanValue()) {
            return webServiceStatus;
        }
        if (error.getCode() == Error.NO_BACKENDS_IN_SERVICE.code) {
            return new Tuple2((Object)true, (Object)503);
        }
        if (error.getCode() == Error.TIMEOUT.code) {
            return new Tuple2((Object)true, (Object)504);
        }
        if (error.getCode() == Error.BACKEND_COMMUNICATION_ERROR.code) {
            return new Tuple2((Object)true, (Object)503);
        }
        if (error.getCode() == Error.ILLEGAL_QUERY.code) {
            return new Tuple2((Object)true, (Object)400);
        }
        if (error.getCode() == Error.INVALID_QUERY_PARAMETER.code) {
            return new Tuple2((Object)true, (Object)400);
        }
        return NO_MATCH;
    }
}

