/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.protect;

import com.yahoo.concurrent.ThreadLocalDirectory;
import com.yahoo.container.protect.TimeoutRate;
import com.yahoo.log.LogLevel;
import com.yahoo.protect.Process;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
class Watchdog
extends TimerTask {
    public static final String FREEZEDETECTOR_DISABLE = "vespa.freezedetector.disable";
    Logger log = Logger.getLogger(Watchdog.class.getName());
    private long lastRun = 0L;
    private long lastQpsCheck = 0L;
    private boolean breakdownCopy = false;
    private volatile boolean breakdown;
    private final double timeoutThreshold;
    private final int minimalQps;
    private final boolean disableSevereBreakdownCheck;
    private final List<ThreadLocalDirectory<TimeoutRate, Boolean>> timeoutRegistry = new ArrayList<ThreadLocalDirectory<TimeoutRate, Boolean>>();
    private final boolean shutdownIfFrozen;

    Watchdog(double timeoutThreshold, int minimalQps, boolean shutdownIfFrozen) {
        this.timeoutThreshold = timeoutThreshold;
        this.minimalQps = minimalQps;
        this.disableSevereBreakdownCheck = System.getProperty(FREEZEDETECTOR_DISABLE) != null;
        this.shutdownIfFrozen = shutdownIfFrozen;
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        if (this.lastRun != 0L) {
            this.severeBreakdown(now);
            this.queryTimeouts(now);
        } else {
            this.lastQpsCheck = now;
        }
        this.lastRun = now;
    }

    private void severeBreakdown(long now) {
        if (this.disableSevereBreakdownCheck) {
            return;
        }
        if (now - this.lastRun < 5000L) {
            return;
        }
        this.threadStackMessage();
        if (this.shutdownIfFrozen) {
            Process.logAndDie((String)"Watchdog timer meant to run ten times per second not run for five seconds or more. Assuming severe failure or overloaded node, shutting down container.");
        } else {
            this.log.log((Level)LogLevel.ERROR, "A watchdog meant to run 10 times a second has not been invoked for 5 seconds. This usually means this machine is swapping or otherwise severely overloaded.");
        }
    }

    private void threadStackMessage() {
        this.log.log(LogLevel.INFO, "System seems unresponsive, performing full thread dump for diagnostics.");
        this.threadDump();
        this.log.log(LogLevel.INFO, "End of diagnostic thread dump.");
    }

    private void threadDump() {
        try {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> e : allStackTraces.entrySet()) {
                Thread t = e.getKey();
                StackTraceElement[] stack = e.getValue();
                StringBuilder forOneThread = new StringBuilder();
                forOneThread.append("Stack for thread: ").append(t.getName()).append(": ");
                int initLen = forOneThread.length();
                for (StackTraceElement s : stack) {
                    if (forOneThread.length() > initLen) {
                        forOneThread.append(" ");
                    }
                    forOneThread.append(s.toString());
                }
                this.log.log(LogLevel.INFO, forOneThread.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryTimeouts(long now) {
        if (now - this.lastQpsCheck < 10000L) {
            return;
        }
        this.lastQpsCheck = now;
        TimeoutRate globalState = new TimeoutRate();
        List<ThreadLocalDirectory<TimeoutRate, Boolean>> list = this.timeoutRegistry;
        synchronized (list) {
            for (ThreadLocalDirectory<TimeoutRate, Boolean> timeouts : this.timeoutRegistry) {
                List threadStates = timeouts.fetch();
                for (TimeoutRate t : threadStates) {
                    globalState.merge(t);
                }
            }
        }
        if (globalState.timeoutFraction() > this.timeoutThreshold && globalState.getTotal() > 10 * this.minimalQps) {
            this.setBreakdown(true);
            this.log.log(Level.WARNING, "Too many queries timed out. Assuming container is in breakdown.");
        } else {
            if (!this.breakdown()) {
                return;
            }
            this.setBreakdown(false);
            this.log.log(Level.WARNING, "Fewer queries timed out. Assuming container is no longer in breakdown.");
        }
    }

    private void setBreakdown(boolean state) {
        this.breakdown = state;
        this.breakdownCopy = state;
    }

    private boolean breakdown() {
        return this.breakdownCopy;
    }

    boolean isBreakdown() {
        return this.breakdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTimeouts(ThreadLocalDirectory<TimeoutRate, Boolean> t) {
        List<ThreadLocalDirectory<TimeoutRate, Boolean>> list = this.timeoutRegistry;
        synchronized (list) {
            this.timeoutRegistry.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTimeouts(ThreadLocalDirectory<TimeoutRate, Boolean> timeouts) {
        List<ThreadLocalDirectory<TimeoutRate, Boolean>> list = this.timeoutRegistry;
        synchronized (list) {
            this.timeoutRegistry.remove(timeouts);
        }
    }
}

