/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class QrTemplatesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "9bc133313acf8166384e0f39484f8710";
    public static final String CONFIG_DEF_NAME = "qr-templates";
    public static final String CONFIG_DEF_NAMESPACE = "container.core";
    public static final String CONFIG_DEF_VERSION = "8";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container.core", "templateset[].urlprefix string", "templateset[].classid string default=\"\"", "templateset[].bundle string default=\"\"", "templateset[].mimetype string default=\"text/html\"", "templateset[].encoding string default=\"iso-8859-1\"", "templateset[].rankprofile int default=0", "templateset[].keepalive bool default=false", "templateset[].headertemplate string default=\"\"", "templateset[].footertemplate string default=\"\"", "templateset[].nohitstemplate string default=\"\"", "templateset[].hittemplate string default=\"\"", "templateset[].errortemplate string default=\"\"", "templateset[].groupsheadertemplate string default=\"[DEFAULT]\"", "templateset[].rangegrouptemplate string default=\"[DEFAULT]\"", "templateset[].exactgrouptemplate string default=\"[DEFAULT]\"", "templateset[].groupsfootertemplate string default=\"[DEFAULT]\"", "templateset[].highlightstarttag string default=\"\"", "templateset[].highlightendtag string default=\"\"", "templateset[].highlightseptag string default=\"\"", "templateset[].defaultsummaryclass string default=\"\""};
    private final InnerNodeVector<Templateset> templateset;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public QrTemplatesConfig(Builder builder) {
        this(builder, true);
    }

    private QrTemplatesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for qr-templates must be initialized: " + builder.__uninitialized);
        }
        this.templateset = Templateset.createVector(builder.templateset);
    }

    public List<Templateset> templateset() {
        return this.templateset;
    }

    public Templateset templateset(int i) {
        return (Templateset)((Object)this.templateset.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(QrTemplatesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Templateset
    extends InnerNode {
        private final StringNode urlprefix;
        private final StringNode classid;
        private final StringNode bundle;
        private final StringNode mimetype;
        private final StringNode encoding;
        private final IntegerNode rankprofile;
        private final BooleanNode keepalive;
        private final StringNode headertemplate;
        private final StringNode footertemplate;
        private final StringNode nohitstemplate;
        private final StringNode hittemplate;
        private final StringNode errortemplate;
        private final StringNode groupsheadertemplate;
        private final StringNode rangegrouptemplate;
        private final StringNode exactgrouptemplate;
        private final StringNode groupsfootertemplate;
        private final StringNode highlightstarttag;
        private final StringNode highlightendtag;
        private final StringNode highlightseptag;
        private final StringNode defaultsummaryclass;

        @Deprecated
        private Templateset() {
            this(new Builder(), false);
        }

        public Templateset(Builder builder) {
            this(builder, true);
        }

        private Templateset(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr-templates.templateset[] must be initialized: " + builder.__uninitialized);
            }
            this.urlprefix = builder.urlprefix == null ? new StringNode() : new StringNode(builder.urlprefix);
            this.classid = builder.classid == null ? new StringNode("") : new StringNode(builder.classid);
            this.bundle = builder.bundle == null ? new StringNode("") : new StringNode(builder.bundle);
            this.mimetype = builder.mimetype == null ? new StringNode("text/html") : new StringNode(builder.mimetype);
            this.encoding = builder.encoding == null ? new StringNode("iso-8859-1") : new StringNode(builder.encoding);
            this.rankprofile = builder.rankprofile == null ? new IntegerNode(0) : new IntegerNode(builder.rankprofile.intValue());
            this.keepalive = builder.keepalive == null ? new BooleanNode(false) : new BooleanNode(builder.keepalive.booleanValue());
            this.headertemplate = builder.headertemplate == null ? new StringNode("") : new StringNode(builder.headertemplate);
            this.footertemplate = builder.footertemplate == null ? new StringNode("") : new StringNode(builder.footertemplate);
            this.nohitstemplate = builder.nohitstemplate == null ? new StringNode("") : new StringNode(builder.nohitstemplate);
            this.hittemplate = builder.hittemplate == null ? new StringNode("") : new StringNode(builder.hittemplate);
            this.errortemplate = builder.errortemplate == null ? new StringNode("") : new StringNode(builder.errortemplate);
            this.groupsheadertemplate = builder.groupsheadertemplate == null ? new StringNode("[DEFAULT]") : new StringNode(builder.groupsheadertemplate);
            this.rangegrouptemplate = builder.rangegrouptemplate == null ? new StringNode("[DEFAULT]") : new StringNode(builder.rangegrouptemplate);
            this.exactgrouptemplate = builder.exactgrouptemplate == null ? new StringNode("[DEFAULT]") : new StringNode(builder.exactgrouptemplate);
            this.groupsfootertemplate = builder.groupsfootertemplate == null ? new StringNode("[DEFAULT]") : new StringNode(builder.groupsfootertemplate);
            this.highlightstarttag = builder.highlightstarttag == null ? new StringNode("") : new StringNode(builder.highlightstarttag);
            this.highlightendtag = builder.highlightendtag == null ? new StringNode("") : new StringNode(builder.highlightendtag);
            this.highlightseptag = builder.highlightseptag == null ? new StringNode("") : new StringNode(builder.highlightseptag);
            this.defaultsummaryclass = builder.defaultsummaryclass == null ? new StringNode("") : new StringNode(builder.defaultsummaryclass);
        }

        public String urlprefix() {
            return this.urlprefix.value();
        }

        public String classid() {
            return this.classid.value();
        }

        public String bundle() {
            return this.bundle.value();
        }

        public String mimetype() {
            return this.mimetype.value();
        }

        public String encoding() {
            return this.encoding.value();
        }

        public int rankprofile() {
            return this.rankprofile.value();
        }

        public boolean keepalive() {
            return this.keepalive.value();
        }

        public String headertemplate() {
            return this.headertemplate.value();
        }

        public String footertemplate() {
            return this.footertemplate.value();
        }

        public String nohitstemplate() {
            return this.nohitstemplate.value();
        }

        public String hittemplate() {
            return this.hittemplate.value();
        }

        public String errortemplate() {
            return this.errortemplate.value();
        }

        public String groupsheadertemplate() {
            return this.groupsheadertemplate.value();
        }

        public String rangegrouptemplate() {
            return this.rangegrouptemplate.value();
        }

        public String exactgrouptemplate() {
            return this.exactgrouptemplate.value();
        }

        public String groupsfootertemplate() {
            return this.groupsfootertemplate.value();
        }

        public String highlightstarttag() {
            return this.highlightstarttag.value();
        }

        public String highlightendtag() {
            return this.highlightendtag.value();
        }

        public String highlightseptag() {
            return this.highlightseptag.value();
        }

        public String defaultsummaryclass() {
            return this.defaultsummaryclass.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Templateset newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("templateset");
            return changes;
        }

        private static InnerNodeVector<Templateset> createVector(List<Builder> builders) {
            ArrayList<Templateset> elems = new ArrayList<Templateset>();
            for (Builder b : builders) {
                elems.add(new Templateset(b));
            }
            return new InnerNodeVector(elems, (InnerNode)new Templateset());
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("urlprefix"));
            private String urlprefix = null;
            private String classid = null;
            private String bundle = null;
            private String mimetype = null;
            private String encoding = null;
            private Integer rankprofile = null;
            private Boolean keepalive = null;
            private String headertemplate = null;
            private String footertemplate = null;
            private String nohitstemplate = null;
            private String hittemplate = null;
            private String errortemplate = null;
            private String groupsheadertemplate = null;
            private String rangegrouptemplate = null;
            private String exactgrouptemplate = null;
            private String groupsfootertemplate = null;
            private String highlightstarttag = null;
            private String highlightendtag = null;
            private String highlightseptag = null;
            private String defaultsummaryclass = null;

            public Builder() {
            }

            public Builder(Templateset config) {
                this.urlprefix(config.urlprefix());
                this.classid(config.classid());
                this.bundle(config.bundle());
                this.mimetype(config.mimetype());
                this.encoding(config.encoding());
                this.rankprofile(config.rankprofile());
                this.keepalive(config.keepalive());
                this.headertemplate(config.headertemplate());
                this.footertemplate(config.footertemplate());
                this.nohitstemplate(config.nohitstemplate());
                this.hittemplate(config.hittemplate());
                this.errortemplate(config.errortemplate());
                this.groupsheadertemplate(config.groupsheadertemplate());
                this.rangegrouptemplate(config.rangegrouptemplate());
                this.exactgrouptemplate(config.exactgrouptemplate());
                this.groupsfootertemplate(config.groupsfootertemplate());
                this.highlightstarttag(config.highlightstarttag());
                this.highlightendtag(config.highlightendtag());
                this.highlightseptag(config.highlightseptag());
                this.defaultsummaryclass(config.defaultsummaryclass());
            }

            private Builder override(Builder __superior) {
                if (__superior.urlprefix != null) {
                    this.urlprefix(__superior.urlprefix);
                }
                if (__superior.classid != null) {
                    this.classid(__superior.classid);
                }
                if (__superior.bundle != null) {
                    this.bundle(__superior.bundle);
                }
                if (__superior.mimetype != null) {
                    this.mimetype(__superior.mimetype);
                }
                if (__superior.encoding != null) {
                    this.encoding(__superior.encoding);
                }
                if (__superior.rankprofile != null) {
                    this.rankprofile(__superior.rankprofile);
                }
                if (__superior.keepalive != null) {
                    this.keepalive(__superior.keepalive);
                }
                if (__superior.headertemplate != null) {
                    this.headertemplate(__superior.headertemplate);
                }
                if (__superior.footertemplate != null) {
                    this.footertemplate(__superior.footertemplate);
                }
                if (__superior.nohitstemplate != null) {
                    this.nohitstemplate(__superior.nohitstemplate);
                }
                if (__superior.hittemplate != null) {
                    this.hittemplate(__superior.hittemplate);
                }
                if (__superior.errortemplate != null) {
                    this.errortemplate(__superior.errortemplate);
                }
                if (__superior.groupsheadertemplate != null) {
                    this.groupsheadertemplate(__superior.groupsheadertemplate);
                }
                if (__superior.rangegrouptemplate != null) {
                    this.rangegrouptemplate(__superior.rangegrouptemplate);
                }
                if (__superior.exactgrouptemplate != null) {
                    this.exactgrouptemplate(__superior.exactgrouptemplate);
                }
                if (__superior.groupsfootertemplate != null) {
                    this.groupsfootertemplate(__superior.groupsfootertemplate);
                }
                if (__superior.highlightstarttag != null) {
                    this.highlightstarttag(__superior.highlightstarttag);
                }
                if (__superior.highlightendtag != null) {
                    this.highlightendtag(__superior.highlightendtag);
                }
                if (__superior.highlightseptag != null) {
                    this.highlightseptag(__superior.highlightseptag);
                }
                if (__superior.defaultsummaryclass != null) {
                    this.defaultsummaryclass(__superior.defaultsummaryclass);
                }
                return this;
            }

            public Builder urlprefix(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.urlprefix = __value;
                this.__uninitialized.remove("urlprefix");
                return this;
            }

            public Builder classid(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.classid = __value;
                return this;
            }

            public Builder bundle(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.bundle = __value;
                return this;
            }

            public Builder mimetype(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.mimetype = __value;
                return this;
            }

            public Builder encoding(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.encoding = __value;
                return this;
            }

            public Builder rankprofile(int __value) {
                this.rankprofile = __value;
                return this;
            }

            private Builder rankprofile(String __value) {
                return this.rankprofile(Integer.valueOf(__value));
            }

            public Builder keepalive(boolean __value) {
                this.keepalive = __value;
                return this;
            }

            private Builder keepalive(String __value) {
                return this.keepalive(Boolean.valueOf(__value));
            }

            public Builder headertemplate(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.headertemplate = __value;
                return this;
            }

            public Builder footertemplate(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.footertemplate = __value;
                return this;
            }

            public Builder nohitstemplate(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.nohitstemplate = __value;
                return this;
            }

            public Builder hittemplate(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.hittemplate = __value;
                return this;
            }

            public Builder errortemplate(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.errortemplate = __value;
                return this;
            }

            public Builder groupsheadertemplate(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.groupsheadertemplate = __value;
                return this;
            }

            public Builder rangegrouptemplate(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.rangegrouptemplate = __value;
                return this;
            }

            public Builder exactgrouptemplate(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.exactgrouptemplate = __value;
                return this;
            }

            public Builder groupsfootertemplate(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.groupsfootertemplate = __value;
                return this;
            }

            public Builder highlightstarttag(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.highlightstarttag = __value;
                return this;
            }

            public Builder highlightendtag(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.highlightendtag = __value;
                return this;
            }

            public Builder highlightseptag(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.highlightseptag = __value;
                return this;
            }

            public Builder defaultsummaryclass(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.defaultsummaryclass = __value;
                return this;
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Templateset.Builder> templateset = new ArrayList<Templateset.Builder>();

        public Builder() {
        }

        public Builder(QrTemplatesConfig config) {
            for (Templateset t : config.templateset()) {
                this.templateset(new Templateset.Builder(t));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.templateset.isEmpty()) {
                this.templateset.addAll(__superior.templateset);
            }
            return this;
        }

        public Builder templateset(Templateset.Builder __builder) {
            this.templateset.add(__builder);
            return this;
        }

        public Builder templateset(List<Templateset.Builder> __builders) {
            this.templateset = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return QrTemplatesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return QrTemplatesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return QrTemplatesConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

