/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.concurrent.maintenance.Maintainer;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.application.ConfigConvergenceChecker;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import com.yahoo.vespa.config.server.maintenance.ApplicationPackageMaintainer;
import com.yahoo.vespa.config.server.maintenance.FileDistributionMaintainer;
import com.yahoo.vespa.config.server.maintenance.ReindexingMaintainer;
import com.yahoo.vespa.config.server.maintenance.SessionsMaintainer;
import com.yahoo.vespa.config.server.maintenance.TenantsMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConfigServerMaintenance {
    private final List<Maintainer> maintainers = new CopyOnWriteArrayList<Maintainer>();
    private final ConfigserverConfig configserverConfig;
    private final ApplicationRepository applicationRepository;
    private final Curator curator;
    private final FlagSource flagSource;
    private final ConfigConvergenceChecker convergenceChecker;
    private final FileDirectory fileDirectory;

    public ConfigServerMaintenance(ApplicationRepository applicationRepository, FileDirectory fileDirectory) {
        this.configserverConfig = applicationRepository.configserverConfig();
        this.applicationRepository = applicationRepository;
        this.curator = applicationRepository.tenantRepository().getCurator();
        this.flagSource = applicationRepository.flagSource();
        this.convergenceChecker = applicationRepository.configConvergenceChecker();
        this.fileDirectory = fileDirectory;
    }

    public void startBeforeBootstrap() {
        this.maintainers.add(new ApplicationPackageMaintainer(this.applicationRepository, this.curator, Duration.ofSeconds(30L), this.flagSource));
        this.maintainers.add(new TenantsMaintainer(this.applicationRepository, this.curator, this.flagSource, new DefaultTimes((ConfigserverConfig)this.configserverConfig).defaultInterval, Clock.systemUTC()));
    }

    public void startAfterBootstrap() {
        this.maintainers.add(new FileDistributionMaintainer(this.applicationRepository, this.curator, new DefaultTimes((ConfigserverConfig)this.configserverConfig).defaultInterval, this.flagSource, this.fileDirectory));
        this.maintainers.add(new SessionsMaintainer(this.applicationRepository, this.curator, Duration.ofSeconds(30L), this.flagSource));
        this.maintainers.add(new ReindexingMaintainer(this.applicationRepository, this.curator, this.flagSource, Duration.ofMinutes(3L), this.convergenceChecker, Clock.systemUTC()));
    }

    public void shutdown() {
        this.maintainers.forEach(Maintainer::shutdown);
        this.maintainers.forEach(Maintainer::awaitShutdown);
    }

    public List<Maintainer> maintainers() {
        return List.copyOf(this.maintainers);
    }

    private static class DefaultTimes {
        private final Duration defaultInterval;

        DefaultTimes(ConfigserverConfig configserverConfig) {
            this.defaultInterval = Duration.ofMinutes(configserverConfig.maintainerIntervalMinutes());
        }
    }
}

