/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.google.common.collect.ImmutableMap;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.net.HostName;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.server.filedistribution.AddFileInterface;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.jpountz.xxhash.XXHashFactory;

public class FileDBRegistry
implements FileRegistry {
    private final boolean silenceNonExistingFiles;
    private final AddFileInterface manager;
    private final Map<String, FileReference> fileReferenceCache = new HashMap<String, FileReference>();
    private static final String entryDelimiter = "\t";
    private static final Pattern entryDelimiterPattern = Pattern.compile("\t", 16);

    public FileDBRegistry(AddFileInterface manager) {
        this(manager, Map.of(), false);
    }

    private FileDBRegistry(AddFileInterface manager, Map<String, FileReference> knownReferences, boolean silenceNonExistingFiles) {
        this.silenceNonExistingFiles = silenceNonExistingFiles;
        this.manager = manager;
        this.fileReferenceCache.putAll(knownReferences);
    }

    public static FileDBRegistry create(AddFileInterface manager, Reader persistedState) {
        FileDBRegistry fileDBRegistry;
        BufferedReader reader = new BufferedReader(persistedState);
        try {
            String ignoredFileSourceHost = reader.readLine();
            if (ignoredFileSourceHost == null) {
                throw new RuntimeException("No file source host");
            }
            fileDBRegistry = new FileDBRegistry(manager, FileDBRegistry.decode(reader), true);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error while reading pre-generated file registry", e);
            }
        }
        reader.close();
        return fileDBRegistry;
    }

    static Map<String, FileReference> decode(BufferedReader reader) {
        HashMap<String, FileReference> refs = new HashMap<String, FileReference>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts = entryDelimiterPattern.split(line);
                if (parts.length < 2) {
                    throw new IllegalArgumentException("Cannot split '" + line + "' into two parts");
                }
                refs.put(parts[0], new FileReference(parts[1]));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading pre-generated file registry", e);
        }
        return refs;
    }

    public synchronized FileReference addFile(String relativePath) {
        if (relativePath.startsWith("/")) {
            throw new IllegalArgumentException(relativePath + " is not relative");
        }
        Optional<FileReference> cachedReference = Optional.ofNullable(this.fileReferenceCache.get(relativePath));
        return cachedReference.orElseGet(() -> {
            try {
                FileReference newRef = this.manager.addFile(Path.fromString((String)relativePath));
                this.fileReferenceCache.put(relativePath, newRef);
                return newRef;
            }
            catch (FileNotFoundException e) {
                if (this.silenceNonExistingFiles) {
                    return new FileReference("non-existing-file");
                }
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    public synchronized FileReference addUri(String uri) {
        String relativePath = FileDBRegistry.uriToRelativeFile(uri);
        Optional<FileReference> cachedReference = Optional.ofNullable(this.fileReferenceCache.get(uri));
        return cachedReference.orElseGet(() -> {
            FileReference newRef = this.manager.addUri(uri, Path.fromString((String)relativePath));
            this.fileReferenceCache.put(uri, newRef);
            return newRef;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileReference addBlob(String blobName, ByteBuffer blob) {
        String relativePath = FileDBRegistry.blobToRelativeFile(blobName);
        FileDBRegistry fileDBRegistry = this;
        synchronized (fileDBRegistry) {
            Optional<FileReference> cachedReference = Optional.ofNullable(this.fileReferenceCache.get(blobName));
            return cachedReference.orElseGet(() -> {
                FileReference newRef = this.manager.addBlob(blob, Path.fromString((String)relativePath));
                this.fileReferenceCache.put(blobName, newRef);
                return newRef;
            });
        }
    }

    public synchronized List<FileRegistry.Entry> export() {
        ArrayList<FileRegistry.Entry> entries = new ArrayList<FileRegistry.Entry>();
        for (Map.Entry<String, FileReference> entry : this.fileReferenceCache.entrySet()) {
            entries.add(new FileRegistry.Entry(entry.getKey(), entry.getValue()));
        }
        return entries;
    }

    synchronized Map<String, FileReference> getMap() {
        return ImmutableMap.copyOf(this.fileReferenceCache);
    }

    public static String exportRegistry(FileRegistry registry) {
        List entries = registry.export();
        StringBuilder builder = new StringBuilder();
        builder.append(HostName.getLocalhost()).append('\n');
        for (FileRegistry.Entry entry : entries) {
            builder.append(entry.relativePath).append(entryDelimiter).append(entry.reference.value()).append('\n');
        }
        return builder.toString();
    }

    private static String uriToRelativeFile(String uri) {
        String relative = "uri/" + XXHashFactory.fastestJavaInstance().hash64().hash(ByteBuffer.wrap(Utf8.toBytes((String)uri)), 0L);
        if (uri.endsWith(".json")) {
            relative = relative + ".json";
        } else if (uri.endsWith(".json.lz4")) {
            relative = relative + ".json.lz4";
        } else if (uri.endsWith(".lz4")) {
            relative = relative + ".lz4";
        }
        return relative;
    }

    private static String blobToRelativeFile(String blobName) {
        return "blob/" + blobName;
    }
}

