/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.collections.Tuple2;
import com.yahoo.component.annotation.Inject;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.http.HttpConfigRequest;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.HttpListConfigsHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.util.Optional;
import java.util.Set;

public class HttpListNamedConfigsHandler
extends HttpHandler {
    private final RequestHandler requestHandler;

    public HttpListNamedConfigsHandler(ThreadedHttpRequestHandler.Context ctx, RequestHandler requestHandler) {
        super(ctx);
        this.requestHandler = requestHandler;
    }

    @Inject
    public HttpListNamedConfigsHandler(ThreadedHttpRequestHandler.Context ctx, TenantRepository tenantRepository) {
        this(ctx, tenantRepository.defaultTenant().getRequestHandler());
    }

    @Override
    public HttpResponse handleGET(HttpRequest req) {
        boolean recursive = req.getBooleanProperty("recursive");
        ConfigKey<?> listKey = this.parseReqToKey(req);
        HttpConfigRequest.validateRequestKey(listKey, this.requestHandler, ApplicationId.defaultId());
        Set<ConfigKey<?>> configs = this.requestHandler.listNamedConfigs(ApplicationId.defaultId(), Optional.empty(), listKey, recursive);
        String urlBase = Utils.getUrlBase(req, "/config/v1/");
        return new HttpListConfigsHandler.ListConfigsResponse(configs, this.requestHandler.allConfigsProduced(ApplicationId.defaultId(), Optional.empty()), urlBase, recursive);
    }

    private ConfigKey<?> parseReqToKey(HttpRequest req) {
        BindingMatch<?> bm = Utils.getBindingMatch(req, "http://*/config/v1/*/*");
        String config = bm.group(2);
        Tuple2<String, String> nns = HttpConfigRequest.nameAndNamespace(config);
        String name = (String)nns.first;
        String namespace = (String)nns.second;
        String idSegment = "";
        if (bm.groupCount() == 4) {
            idSegment = bm.group(3);
        }
        return new ConfigKey(name, idSegment, namespace);
    }
}

