/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FlagSource;
import java.io.File;
import java.time.Duration;

public class FileDistributionMaintainer
extends ConfigServerMaintainer {
    private static final int numberToAlwaysKeep = 10;
    private final ApplicationRepository applicationRepository;
    private final File fileReferencesDir;
    private final Duration maxUnusedFileReferenceAge;

    FileDistributionMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, FlagSource flagSource) {
        super(applicationRepository, curator, flagSource, applicationRepository.clock().instant(), interval, false);
        this.applicationRepository = applicationRepository;
        ConfigserverConfig configserverConfig = applicationRepository.configserverConfig();
        this.maxUnusedFileReferenceAge = Duration.ofMinutes(configserverConfig.keepUnusedFileReferencesMinutes());
        this.fileReferencesDir = new File(Defaults.getDefaults().underVespaHome(configserverConfig.fileReferencesDir()));
    }

    protected double maintain() {
        this.applicationRepository.deleteUnusedFileDistributionReferences(this.fileReferencesDir, this.maxUnusedFileReferenceAge, 10);
        return 1.0;
    }
}

