/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.config.provision.ApplicationLockException;
import com.yahoo.config.provision.CertificateNotReadyException;
import com.yahoo.config.provision.NodeAllocationException;
import com.yahoo.config.provision.ParentHostUnavailableException;
import com.yahoo.config.provision.exception.ActivationConflictException;
import com.yahoo.config.provision.exception.LoadBalancerServiceException;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.application.ConfigNotConvergedException;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.InvalidApplicationException;
import com.yahoo.vespa.config.server.http.ReindexingStatusException;
import com.yahoo.vespa.config.server.http.RequestTimeoutException;
import com.yahoo.vespa.config.server.http.UnknownVespaVersionException;
import com.yahoo.yolean.Exceptions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.logging.Level;

public class HttpHandler
extends ThreadedHttpRequestHandler {
    public HttpHandler(ThreadedHttpRequestHandler.Context ctx) {
        super(ctx);
    }

    public HttpResponse handle(HttpRequest request) {
        this.log.log(Level.FINE, () -> request.getMethod() + " " + request.getUri().toString());
        try {
            return switch (request.getMethod()) {
                case HttpRequest.Method.POST -> this.handlePOST(request);
                case HttpRequest.Method.GET -> this.handleGET(request);
                case HttpRequest.Method.PUT -> this.handlePUT(request);
                case HttpRequest.Method.DELETE -> this.handleDELETE(request);
                default -> this.createErrorResponse(request.getMethod());
            };
        }
        catch (NotFoundException | com.yahoo.vespa.config.server.http.NotFoundException e) {
            return HttpErrorResponse.notFoundError(this.getMessage(e, request));
        }
        catch (ActivationConflictException e) {
            return HttpErrorResponse.conflictWhenActivating(this.getMessage((Exception)((Object)e), request));
        }
        catch (InvalidApplicationException e) {
            return HttpErrorResponse.invalidApplicationPackage(this.getMessage(e, request));
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            return HttpErrorResponse.badRequest(this.getMessage(e, request));
        }
        catch (NodeAllocationException e) {
            return HttpErrorResponse.nodeAllocationFailure(this.getMessage((Exception)((Object)e), request));
        }
        catch (InternalServerException e) {
            return HttpErrorResponse.internalServerError(this.getMessage(e, request));
        }
        catch (UnknownVespaVersionException e) {
            return HttpErrorResponse.unknownVespaVersion(this.getMessage(e, request));
        }
        catch (RequestTimeoutException e) {
            return HttpErrorResponse.requestTimeout(this.getMessage(e, request));
        }
        catch (ApplicationLockException e) {
            return HttpErrorResponse.applicationLockFailure(this.getMessage((Exception)((Object)e), request));
        }
        catch (ParentHostUnavailableException e) {
            return HttpErrorResponse.parentHostNotReady(this.getMessage((Exception)((Object)e), request));
        }
        catch (CertificateNotReadyException e) {
            return HttpErrorResponse.certificateNotReady(this.getMessage((Exception)((Object)e), request));
        }
        catch (ConfigNotConvergedException e) {
            return HttpErrorResponse.configNotConverged(this.getMessage(e, request));
        }
        catch (LoadBalancerServiceException e) {
            return HttpErrorResponse.loadBalancerNotReady(this.getMessage((Exception)((Object)e), request));
        }
        catch (ReindexingStatusException e) {
            return HttpErrorResponse.reindexingStatusUnavailable(this.getMessage(e, request));
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Unexpected exception handling a config server request", e);
            return HttpErrorResponse.internalServerError(this.getMessage(e, request));
        }
    }

    protected static Duration getRequestTimeout(HttpRequest request, Duration defaultTimeout) {
        if (!request.hasProperty("timeout")) {
            return defaultTimeout;
        }
        try {
            return Duration.ofMillis((long)(Double.parseDouble(request.getProperty("timeout")) * 1000.0));
        }
        catch (Exception e) {
            return defaultTimeout;
        }
    }

    private String getMessage(Exception e, HttpRequest request) {
        if (request.getBooleanProperty("debug")) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return sw.toString();
        }
        return Exceptions.toMessageString((Throwable)e);
    }

    protected HttpResponse handleGET(HttpRequest request) {
        return this.createErrorResponse(request.getMethod());
    }

    protected HttpResponse handlePOST(HttpRequest request) {
        return this.createErrorResponse(request.getMethod());
    }

    protected HttpResponse handlePUT(HttpRequest request) {
        return this.createErrorResponse(request.getMethod());
    }

    protected HttpResponse handleDELETE(HttpRequest request) {
        return this.createErrorResponse(request.getMethod());
    }

    private HttpResponse createErrorResponse(HttpRequest.Method method) {
        return HttpErrorResponse.methodNotAllowed("Method '" + method + "' is not supported");
    }
}

