/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.FileReference;
import com.yahoo.net.HostName;
import com.yahoo.vespa.config.server.ConfigServerSpec;
import com.yahoo.vespa.filedistribution.maintenance.FileDistributionCleanup;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public class FileDistributionUtil {
    public static List<String> getOtherConfigServersInCluster(ConfigserverConfig configserverConfig) {
        return ConfigServerSpec.fromConfig(configserverConfig).stream().filter(spec -> !spec.getHostName().equals(HostName.getLocalhost())).map(spec -> "tcp/" + spec.getHostName() + ":" + spec.getConfigServerPort()).collect(Collectors.toList());
    }

    public static boolean fileReferenceExistsOnDisk(File downloadDirectory, FileReference applicationPackageReference) {
        return FileDistributionCleanup.getFileReferencesOnDisk((Path)downloadDirectory.toPath()).anyMatch(fileReference -> fileReference.equals(applicationPackageReference.value()));
    }
}

