/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.provision;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.provision.Provisioner;
import java.util.Optional;

public class HostProvisionerProvider {
    private final Optional<Provisioner> hostProvisioner;

    public HostProvisionerProvider(ComponentRegistry<Provisioner> hostProvisionerRegistry, ConfigserverConfig configserverConfig) {
        this.hostProvisioner = hostProvisionerRegistry.allComponents().isEmpty() || !configserverConfig.hostedVespa() ? Optional.empty() : Optional.of((Provisioner)hostProvisionerRegistry.allComponents().get(0));
    }

    private HostProvisionerProvider(ComponentRegistry<Provisioner> componentRegistry) {
        this(componentRegistry, new ConfigserverConfig(new ConfigserverConfig.Builder()));
    }

    public Optional<Provisioner> getHostProvisioner() {
        return this.hostProvisioner;
    }

    public static HostProvisionerProvider empty() {
        return new HostProvisionerProvider((ComponentRegistry<Provisioner>)new ComponentRegistry());
    }

    public static HostProvisionerProvider withProvisioner(Provisioner provisioner, boolean hostedVespa) {
        return HostProvisionerProvider.withProvisioner(provisioner, new ConfigserverConfig(new ConfigserverConfig.Builder().hostedVespa(hostedVespa)));
    }

    public static HostProvisionerProvider withProvisioner(Provisioner provisioner, ConfigserverConfig config) {
        ComponentRegistry registry = new ComponentRegistry();
        registry.register(ComponentId.createAnonymousComponentId((String)"foobar"), (Object)provisioner);
        return new HostProvisionerProvider((ComponentRegistry<Provisioner>)registry, config);
    }
}

