/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.model.api.TenantVault;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.Type;
import java.util.ArrayList;
import java.util.List;

public class TenantVaultSerializer {
    private static final String idField = "id";
    private static final String nameField = "name";
    private static final String externalIdField = "externalId";
    private static final String secretsArray = "secrets";

    public static Slime toSlime(List<TenantVault> vaults) {
        Slime slime = new Slime();
        Cursor cursor = slime.setArray();
        TenantVaultSerializer.toSlime(vaults, cursor);
        return slime;
    }

    public static void toSlime(List<TenantVault> vaults, Cursor cursor) {
        vaults.forEach(tenantVault -> TenantVaultSerializer.toSlime(tenantVault, cursor.addObject()));
    }

    private static void toSlime(TenantVault vault, Cursor object) {
        object.setString(idField, vault.id());
        object.setString(nameField, vault.name());
        object.setString(externalIdField, vault.externalId());
        Cursor secrets = object.setArray(secretsArray);
        vault.secrets().forEach(secret -> TenantVaultSerializer.toSlime(secret, secrets.addObject()));
    }

    private static void toSlime(TenantVault.Secret secret, Cursor object) {
        object.setString(nameField, secret.name());
        object.setString(idField, secret.id());
    }

    public static TenantVault fromSlime(Inspector inspector) {
        if (inspector.type() == Type.OBJECT) {
            return new TenantVault(inspector.field(idField).asString(), inspector.field(nameField).asString(), inspector.field(externalIdField).asString(), TenantVaultSerializer.secretsFromSlime(inspector.field(secretsArray)));
        }
        throw new IllegalArgumentException("Unknown format encountered for tenant vaults!");
    }

    private static List<TenantVault.Secret> secretsFromSlime(Inspector inspector) {
        ArrayList<TenantVault.Secret> secrets = new ArrayList<TenantVault.Secret>();
        inspector.traverse((idx, secret) -> secrets.add(TenantVaultSerializer.secretFromSlime(secret)));
        return secrets;
    }

    private static TenantVault.Secret secretFromSlime(Inspector inspector) {
        return new TenantVault.Secret(inspector.field(idField).asString(), inspector.field(nameField).asString());
    }

    public static List<TenantVault> listFromSlime(Inspector inspector) {
        ArrayList<TenantVault> tenantVaults = new ArrayList<TenantVault>();
        inspector.traverse((idx, vault) -> tenantVaults.add(TenantVaultSerializer.fromSlime(vault)));
        return tenantVaults;
    }
}

