/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import ai.vespa.http.HttpURL;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.vespa.config.server.http.BadRequestException;
import com.yahoo.vespa.config.server.http.NotFoundException;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.session.Session;
import java.io.InputStream;

public abstract class ContentRequest {
    private static final String RETURN_QUERY_PROPERTY = "return";
    private final long sessionId;
    private final HttpURL.Path path;
    private final ApplicationFile file;
    private final HttpRequest request;

    protected ContentRequest(HttpRequest request, long sessionId, HttpURL.Path path, ApplicationFile applicationFile) {
        this.request = request;
        this.sessionId = sessionId;
        this.path = path;
        this.file = applicationFile;
    }

    public static Session.Mode getApplicationFileMode(HttpRequest.Method method) {
        return switch (method) {
            case HttpRequest.Method.GET, HttpRequest.Method.OPTIONS -> Session.Mode.READ;
            default -> Session.Mode.WRITE;
        };
    }

    ReturnType getReturnType() {
        if (this.request.hasProperty(RETURN_QUERY_PROPERTY)) {
            String type;
            return switch (type = this.request.getProperty(RETURN_QUERY_PROPERTY)) {
                case "content" -> ReturnType.CONTENT;
                case "status" -> ReturnType.STATUS;
                default -> throw new BadRequestException("return=" + type + " is an illegal argument. Only " + ReturnType.CONTENT.name() + " and " + ReturnType.STATUS.name() + " are allowed");
            };
        }
        return ReturnType.CONTENT;
    }

    protected abstract String getPathPrefix();

    String getUrlBase(String appendStr) {
        return Utils.getUrlBase(this.request, this.getPathPrefix() + appendStr);
    }

    boolean isRecursive() {
        return this.request.getBooleanProperty("recursive");
    }

    boolean hasRequestBody() {
        return this.request.getData() != null;
    }

    InputStream getData() {
        return this.request.getData();
    }

    HttpURL.Path getPath() {
        return this.path;
    }

    ApplicationFile getFile() {
        return this.file;
    }

    ApplicationFile getExistingFile() {
        if (!this.file.exists()) {
            throw new NotFoundException("Session " + this.sessionId + " does not contain a file at " + String.valueOf(this.path));
        }
        return this.file;
    }

    static enum ReturnType {
        CONTENT,
        STATUS;

    }
}

