/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.modelfactory;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.InMemoryFlagSource;
import com.yahoo.vespa.flags.OrderedFlagSource;
import java.util.Map;

public class LegacyFlags {
    public static final String GEO_POSITIONS = "v7-geo-positions";
    public static final String FOO_BAR = "foo-bar";

    private static FlagSource buildFrom(Map<String, String> legacyOverrides) {
        InMemoryFlagSource flags = new InMemoryFlagSource();
        block8: for (Map.Entry<String, String> entry : legacyOverrides.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            boolean legacyWanted = Boolean.valueOf(value);
            switch (key) {
                case "v7-geo-positions": {
                    if (!legacyWanted) continue block8;
                    throw new IllegalArgumentException("Legacy flag 'v7-geo-positions' no longer supported");
                }
                case "foo-bar": {
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown legacy override: " + key);
        }
        return flags;
    }

    public static FlagSource from(ApplicationPackage pkg, FlagSource input) {
        FlagSource overrides = LegacyFlags.buildFrom(pkg.legacyOverrides());
        OrderedFlagSource result = new OrderedFlagSource(new FlagSource[]{overrides, input});
        return result;
    }
}

