/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.component.Version;
import com.yahoo.config.FileReference;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.model.api.TenantVault;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.DataplaneToken;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.server.session.ActivationTriggers;
import com.yahoo.vespa.config.server.session.ActivationTriggersSerializer;
import com.yahoo.vespa.config.server.tenant.DataplaneTokenSerializer;
import com.yahoo.vespa.config.server.tenant.OperatorCertificateSerializer;
import com.yahoo.vespa.config.server.tenant.TenantSecretStoreSerializer;
import com.yahoo.vespa.config.server.tenant.TenantVaultSerializer;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public record SessionData(ApplicationId applicationId, Optional<FileReference> applicationPackageReference, Version version, Optional<Version> versionToBuildFirst, Instant created, Optional<DockerImage> dockerImageRepository, Optional<AthenzDomain> athenzDomain, Optional<Quota> quota, List<TenantVault> tenantVaults, List<TenantSecretStore> tenantSecretStores, List<X509Certificate> operatorCertificates, Optional<CloudAccount> cloudAccount, List<DataplaneToken> dataplaneTokens, ActivationTriggers activationTriggers) {
    static final String APPLICATION_ID_PATH = "applicationId";
    static final String APPLICATION_PACKAGE_REFERENCE_PATH = "applicationPackageReference";
    static final String VERSION_PATH = "version";
    static final String VERSION_TO_BUILD_FIRST_PATH = "versionToBuildFirst";
    static final String CREATE_TIME_PATH = "createTime";
    static final String DOCKER_IMAGE_REPOSITORY_PATH = "dockerImageRepository";
    static final String ATHENZ_DOMAIN = "athenzDomain";
    static final String QUOTA_PATH = "quota";
    static final String TENANT_VAULTS_PATH = "tenantVaults";
    static final String TENANT_SECRET_STORES_PATH = "tenantSecretStores";
    static final String OPERATOR_CERTIFICATES_PATH = "operatorCertificates";
    static final String CLOUD_ACCOUNT_PATH = "cloudAccount";
    static final String DATAPLANE_TOKENS_PATH = "dataplaneTokens";
    static final String SESSION_DATA_PATH = "sessionData";
    static final String ACTIVATION_TRIGGERS_PATH = "activationTriggers";

    public byte[] toJson() {
        try {
            Slime slime = new Slime();
            this.toSlime(slime.setObject());
            return SlimeUtils.toJsonBytes((Slime)slime);
        }
        catch (IOException e) {
            throw new RuntimeException("Serialization of session data to json failed", e);
        }
    }

    private void toSlime(Cursor object) {
        object.setString(APPLICATION_ID_PATH, this.applicationId.serializedForm());
        this.applicationPackageReference.ifPresent(ref -> object.setString(APPLICATION_PACKAGE_REFERENCE_PATH, ref.value()));
        object.setString(VERSION_PATH, this.version.toString());
        this.versionToBuildFirst.ifPresent(v -> object.setString(VERSION_TO_BUILD_FIRST_PATH, v.toString()));
        object.setLong(CREATE_TIME_PATH, this.created.toEpochMilli());
        this.dockerImageRepository.ifPresent(image -> object.setString(DOCKER_IMAGE_REPOSITORY_PATH, image.asString()));
        this.athenzDomain.ifPresent(domain -> object.setString(ATHENZ_DOMAIN, domain.value()));
        this.quota.ifPresent(q -> q.toSlime(object.setObject(QUOTA_PATH)));
        Cursor tenantVaultArray = object.setArray(TENANT_VAULTS_PATH);
        TenantVaultSerializer.toSlime(this.tenantVaults, tenantVaultArray);
        Cursor tenantSecretStoresArray = object.setArray(TENANT_SECRET_STORES_PATH);
        TenantSecretStoreSerializer.toSlime(this.tenantSecretStores, tenantSecretStoresArray);
        Cursor operatorCertificatesArray = object.setArray(OPERATOR_CERTIFICATES_PATH);
        OperatorCertificateSerializer.toSlime(this.operatorCertificates, operatorCertificatesArray);
        this.cloudAccount.ifPresent(account -> object.setString(CLOUD_ACCOUNT_PATH, account.value()));
        Cursor dataplaneTokensArray = object.setArray(DATAPLANE_TOKENS_PATH);
        DataplaneTokenSerializer.toSlime(this.dataplaneTokens, dataplaneTokensArray);
        ActivationTriggersSerializer.toSlime(this.activationTriggers, object.setObject(ACTIVATION_TRIGGERS_PATH));
    }

    static SessionData fromSlime(Slime slime) {
        Cursor cursor = slime.get();
        return new SessionData(ApplicationId.fromSerializedForm((String)cursor.field(APPLICATION_ID_PATH).asString()), SlimeUtils.optionalString((Inspector)cursor.field(APPLICATION_PACKAGE_REFERENCE_PATH)).map(FileReference::new), Version.fromString((String)cursor.field(VERSION_PATH).asString()), SlimeUtils.isPresent((Inspector)cursor.field(VERSION_TO_BUILD_FIRST_PATH)) ? Optional.of(Version.fromString((String)cursor.field(VERSION_TO_BUILD_FIRST_PATH).asString())) : Optional.empty(), Instant.ofEpochMilli(cursor.field(CREATE_TIME_PATH).asLong()), SlimeUtils.optionalString((Inspector)cursor.field(DOCKER_IMAGE_REPOSITORY_PATH)).map(DockerImage::fromString), SlimeUtils.optionalString((Inspector)cursor.field(ATHENZ_DOMAIN)).map(AthenzDomain::from), SlimeUtils.isPresent((Inspector)cursor.field(QUOTA_PATH)) ? Optional.of(Quota.fromSlime((Inspector)cursor.field(QUOTA_PATH))) : Optional.empty(), TenantVaultSerializer.listFromSlime((Inspector)cursor.field(TENANT_VAULTS_PATH)), TenantSecretStoreSerializer.listFromSlime((Inspector)cursor.field(TENANT_SECRET_STORES_PATH)), OperatorCertificateSerializer.fromSlime((Inspector)cursor.field(OPERATOR_CERTIFICATES_PATH)), SlimeUtils.optionalString((Inspector)cursor.field(CLOUD_ACCOUNT_PATH)).map(CloudAccount::from), DataplaneTokenSerializer.fromSlime((Inspector)cursor.field(DATAPLANE_TOKENS_PATH)), ActivationTriggersSerializer.fromSlime(cursor.field(ACTIVATION_TRIGGERS_PATH)));
    }
}

