/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.path.Path;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.text.Utf8;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.application.ApplicationData;
import com.yahoo.vespa.config.server.application.ApplicationReindexing;
import com.yahoo.vespa.config.server.application.PendingRestarts;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.Lock;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import com.yahoo.yolean.Exceptions;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class ApplicationCuratorDatabase {
    final TenantName tenant;
    final Path applicationsPath;
    final Path locksPath;
    private final Curator curator;

    public ApplicationCuratorDatabase(TenantName tenant, Curator curator) {
        this.tenant = tenant;
        this.applicationsPath = TenantRepository.getApplicationsPath(tenant);
        this.locksPath = TenantRepository.getLocksPath(tenant);
        this.curator = curator;
    }

    public Lock lock(ApplicationId id) {
        return this.curator.lock(this.lockPath(id), Duration.ofMinutes(1L));
    }

    public void modifyReindexing(ApplicationId id, ApplicationReindexing emptyValue, UnaryOperator<ApplicationReindexing> modifications) {
        try (Lock lock = this.curator.lock(this.reindexingLockPath(id), Duration.ofMinutes(1L));){
            this.writeReindexingStatus(id, (ApplicationReindexing)modifications.apply(this.readReindexingStatus(id).orElse(emptyValue)));
        }
    }

    public boolean exists(ApplicationId id) {
        return this.curator.exists(this.applicationPath(id));
    }

    public void createApplication(ApplicationId id) {
        if (!id.tenant().equals((Object)this.tenant)) {
            throw new IllegalArgumentException("Cannot write application id '" + String.valueOf(id) + "' for tenant '" + String.valueOf(this.tenant) + "'");
        }
        try (Lock lock = this.lock(id);){
            if (this.curator.exists(this.applicationPath(id))) {
                return;
            }
            ApplicationData applicationData = new ApplicationData(id, OptionalLong.empty(), OptionalLong.empty());
            this.curator.set(this.applicationPath(id), applicationData.toJson());
            this.modifyReindexing(id, ApplicationReindexing.empty(), UnaryOperator.identity());
        }
    }

    public void createApplicationInOldFormat(ApplicationId id) {
        if (!id.tenant().equals((Object)this.tenant)) {
            throw new IllegalArgumentException("Cannot write application id '" + String.valueOf(id) + "' for tenant '" + String.valueOf(this.tenant) + "'");
        }
        try (Lock lock = this.lock(id);){
            if (this.curator.exists(this.applicationPath(id))) {
                return;
            }
            this.curator.create(this.applicationPath(id));
            this.modifyReindexing(id, ApplicationReindexing.empty(), UnaryOperator.identity());
        }
    }

    public Transaction createWriteActiveTransaction(Transaction transaction, ApplicationId applicationId, long sessionId) {
        String path = this.applicationPath(applicationId).getAbsolute();
        return transaction.add((Transaction.Operation)CuratorOperations.setData((String)path, (byte[])new ApplicationData(applicationId, OptionalLong.of(sessionId), OptionalLong.of(sessionId)).toJson()));
    }

    public Transaction createWriteActiveTransactionInOldFormat(Transaction transaction, ApplicationId applicationId, long sessionId) {
        String path = this.applicationPath(applicationId).getAbsolute();
        return transaction.add((Transaction.Operation)CuratorOperations.setData((String)path, (byte[])Utf8.toAsciiBytes((long)sessionId)));
    }

    public Transaction createWritePrepareTransaction(Transaction transaction, ApplicationId applicationId, long sessionId, OptionalLong activeSessionId) {
        String path = this.applicationPath(applicationId).getAbsolute();
        return transaction.add((Transaction.Operation)CuratorOperations.setData((String)path, (byte[])new ApplicationData(applicationId, activeSessionId, OptionalLong.of(sessionId)).toJson()));
    }

    public CuratorTransaction createDeleteTransaction(ApplicationId applicationId) {
        return CuratorTransaction.from((List)CuratorOperations.deleteAll((String)this.applicationPath(applicationId).getAbsolute(), (Curator)this.curator), (Curator)this.curator);
    }

    public Optional<Long> activeSessionOf(ApplicationId id) {
        return this.applicationData(id).flatMap(ApplicationData::activeSession);
    }

    public Optional<ApplicationData> applicationData(ApplicationId id) {
        Optional data = this.curator.getData(this.applicationPath(id));
        if (data.isEmpty() || ((byte[])data.get()).length == 0) {
            return Optional.empty();
        }
        try {
            return Optional.of(ApplicationData.fromBytes((byte[])data.get()));
        }
        catch (IllegalArgumentException e) {
            return this.applicationDataOldFormat(id);
        }
    }

    public Optional<ApplicationData> applicationDataOldFormat(ApplicationId id) {
        Optional data = this.curator.getData(this.applicationPath(id));
        if (data.isEmpty() || ((byte[])data.get()).length == 0) {
            return Optional.empty();
        }
        return Optional.of(new ApplicationData(id, OptionalLong.of(data.map(bytes -> Long.parseLong(Utf8.toString((byte[])bytes))).get()), OptionalLong.empty()));
    }

    public List<ApplicationId> activeApplications() {
        return this.curator.getChildren(this.applicationsPath).stream().sorted().map(ApplicationId::fromSerializedForm).filter(id -> this.activeSessionOf((ApplicationId)id).isPresent()).toList();
    }

    public PendingRestarts readPendingRestarts(ApplicationId id) {
        try (Lock lock = this.curator.lock(this.restartsLockPath(id), Duration.ofMinutes(1L));){
            PendingRestarts pendingRestarts = this.curator.getData(this.pendingRestartsPath(id)).map(PendingRestartsSerializer::fromBytes).orElse(PendingRestarts.empty());
            return pendingRestarts;
        }
    }

    public void modifyPendingRestarts(ApplicationId id, UnaryOperator<PendingRestarts> modification) {
        try (Lock lock = this.curator.lock(this.restartsLockPath(id), Duration.ofMinutes(1L));){
            PendingRestarts original = this.readPendingRestarts(id);
            PendingRestarts modified = (PendingRestarts)modification.apply(original);
            if (original != modified) {
                if (modified.isEmpty()) {
                    this.curator.delete(this.pendingRestartsPath(id));
                } else {
                    this.curator.set(this.pendingRestartsPath(id), PendingRestartsSerializer.toBytes(modified));
                }
            }
        }
    }

    public Optional<ApplicationReindexing> readReindexingStatus(ApplicationId id) {
        return this.curator.getData(this.reindexingDataPath(id)).map(ReindexingStatusSerializer::fromBytes);
    }

    void writeReindexingStatus(ApplicationId id, ApplicationReindexing status) {
        this.curator.set(this.reindexingDataPath(id), ReindexingStatusSerializer.toBytes(status));
    }

    public Curator.DirectoryCache createApplicationsPathCache(ExecutorService zkCacheExecutor) {
        return this.curator.createDirectoryCache(this.applicationsPath.getAbsolute(), false, false, zkCacheExecutor);
    }

    private Path restartsLockPath(ApplicationId id) {
        return this.locksPath.append(id.serializedForm() + "::restarts");
    }

    private Path reindexingLockPath(ApplicationId id) {
        return this.locksPath.append(id.serializedForm()).append("reindexing");
    }

    private Path lockPath(ApplicationId id) {
        return this.locksPath.append(id.serializedForm());
    }

    private Path applicationPath(ApplicationId id) {
        return this.applicationsPath.append(id.serializedForm());
    }

    private Path reindexingDataPath(ApplicationId id) {
        return this.applicationPath(id).append("reindexing");
    }

    private Path pendingRestartsPath(ApplicationId id) {
        return this.applicationPath(id).append("restarts");
    }

    private static class PendingRestartsSerializer {
        private static final String GENERATIONS = "generations";
        private static final String GENERATION = "generation";
        private static final String HOSTNAMES = "hostnames";

        private PendingRestartsSerializer() {
        }

        private static byte[] toBytes(PendingRestarts pendingRestarts) {
            Cursor root = new Slime().setObject();
            Cursor generationsArray = root.setArray(GENERATIONS);
            pendingRestarts.generationsForRestarts().forEach((generation, hostnames) -> {
                Cursor generationObject = generationsArray.addObject();
                generationObject.setLong(GENERATION, generation.longValue());
                hostnames.forEach(arg_0 -> ((Cursor)generationObject.setArray(HOSTNAMES)).addString(arg_0));
            });
            return (byte[])Exceptions.uncheck(() -> SlimeUtils.toJsonBytes((Inspector)root));
        }

        private static PendingRestarts fromBytes(byte[] data) {
            Cursor root = SlimeUtils.jsonToSlimeOrThrow((byte[])data).get();
            return new PendingRestarts(SlimeUtils.entriesStream((Inspector)root.field(GENERATIONS)).collect(Collectors.toMap(entry -> entry.field(GENERATION).asLong(), entry -> SlimeUtils.entriesStream((Inspector)entry.field(HOSTNAMES)).map(Inspector::asString).toList())));
        }
    }

    private static class ReindexingStatusSerializer {
        private static final String ENABLED = "enabled";
        private static final String CLUSTERS = "clusters";
        private static final String PENDING = "pending";
        private static final String READY = "ready";
        private static final String TYPE = "type";
        private static final String NAME = "name";
        private static final String GENERATION = "generation";
        private static final String EPOCH_MILLIS = "epochMillis";
        private static final String SPEED = "speed";
        private static final String CAUSE = "cause";

        private ReindexingStatusSerializer() {
        }

        private static byte[] toBytes(ApplicationReindexing reindexing) {
            Cursor root = new Slime().setObject();
            root.setBool(ENABLED, reindexing.enabled());
            Cursor clustersArray = root.setArray(CLUSTERS);
            reindexing.clusters().forEach((name, cluster) -> {
                Cursor clusterObject = clustersArray.addObject();
                clusterObject.setString(NAME, name);
                Cursor pendingArray = clusterObject.setArray(PENDING);
                cluster.pending().forEach((type, generation) -> {
                    Cursor pendingObject = pendingArray.addObject();
                    pendingObject.setString(TYPE, type);
                    pendingObject.setLong(GENERATION, generation.longValue());
                });
                Cursor readyArray = clusterObject.setArray(READY);
                cluster.ready().forEach((type, status) -> {
                    Cursor statusObject = readyArray.addObject();
                    statusObject.setString(TYPE, type);
                    ReindexingStatusSerializer.setStatus(statusObject, status);
                });
            });
            return (byte[])Exceptions.uncheck(() -> SlimeUtils.toJsonBytes((Inspector)root));
        }

        private static void setStatus(Cursor statusObject, ApplicationReindexing.Status status) {
            statusObject.setLong(EPOCH_MILLIS, status.ready().toEpochMilli());
            statusObject.setDouble(SPEED, status.speed());
            statusObject.setString(CAUSE, status.cause());
        }

        private static ApplicationReindexing fromBytes(byte[] data) {
            Cursor root = SlimeUtils.jsonToSlimeOrThrow((byte[])data).get();
            return new ApplicationReindexing(root.field(ENABLED).valid() ? root.field(ENABLED).asBool() : true, SlimeUtils.entriesStream((Inspector)root.field(CLUSTERS)).collect(Collectors.toUnmodifiableMap(object -> object.field(NAME).asString(), object -> ReindexingStatusSerializer.getCluster(object))));
        }

        private static ApplicationReindexing.Cluster getCluster(Inspector object) {
            return new ApplicationReindexing.Cluster(SlimeUtils.entriesStream((Inspector)object.field(PENDING)).collect(Collectors.toUnmodifiableMap(entry -> entry.field(TYPE).asString(), entry -> entry.field(GENERATION).asLong())), SlimeUtils.entriesStream((Inspector)object.field(READY)).collect(Collectors.toUnmodifiableMap(entry -> entry.field(TYPE).asString(), entry -> ReindexingStatusSerializer.getStatus(entry))));
        }

        private static ApplicationReindexing.Status getStatus(Inspector statusObject) {
            return new ApplicationReindexing.Status(Instant.ofEpochMilli(statusObject.field(EPOCH_MILLIS).asLong()), statusObject.field(SPEED).valid() ? statusObject.field(SPEED).asDouble() : 0.2, statusObject.field(CAUSE).asString());
        }
    }
}

