/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.log.LogLevel;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeployHandlerLogger
implements DeployLogger {
    private static final Logger log = Logger.getLogger(DeployHandlerLogger.class.getName());
    private final String prefix;
    private final boolean verbose;
    private final Slime slime;
    private final Cursor logroot;

    private DeployHandlerLogger(String prefix, boolean verbose) {
        this.prefix = prefix;
        this.verbose = verbose;
        this.slime = new Slime();
        this.logroot = this.slime.setObject().setArray("log");
    }

    public void log(Level level, String message) {
        this.log(level, () -> message);
    }

    public void log(Level level, Supplier<String> message) {
        this.log(level, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Level level, Supplier<String> supplier, Throwable throwable) {
        log.log(Level.FINE, throwable, () -> this.prefix + (String)supplier.get());
        if (level.intValue() <= LogLevel.DEBUG.intValue() && !this.verbose) {
            return;
        }
        Cursor cursor = this.logroot;
        synchronized (cursor) {
            this.logJson(level, supplier.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logApplicationPackage(Level level, String message) {
        if (level.intValue() <= LogLevel.DEBUG.intValue() && !this.verbose) {
            return;
        }
        Cursor cursor = this.logroot;
        synchronized (cursor) {
            Cursor entry = this.logJson(level, message);
            entry.setBool("applicationPackage", true);
        }
        log.log(Level.FINE, () -> this.prefix + message);
    }

    private Cursor logJson(Level level, String message) {
        Cursor entry = this.logroot.addObject();
        entry.setLong("time", System.currentTimeMillis());
        entry.setString("level", level.getName());
        entry.setString("message", message);
        return entry;
    }

    public Slime slime() {
        return this.slime;
    }

    public static DeployHandlerLogger forApplication(ApplicationId app, boolean verbose) {
        return new DeployHandlerLogger(TenantRepository.logPre(app), verbose);
    }

    public static DeployHandlerLogger forTenant(TenantName tenantName, boolean verbose) {
        return new DeployHandlerLogger(TenantRepository.logPre(tenantName), verbose);
    }

    public static DeployHandlerLogger forPrepareParams(PrepareParams prepareParams) {
        return DeployHandlerLogger.forApplication(prepareParams.getApplicationId(), prepareParams.isVerbose());
    }
}

