/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.provision.TenantName;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.text.Utf8;
import java.io.IOException;
import java.time.Instant;

public class TenantMetaData {
    private static final String createTimestampKey = "createTimestampKey";
    private static final String lastDeployTimestampKey = "lastDeployTimestamp";
    private final TenantName tenantName;
    private final Instant created;
    private final Instant lastDeployed;

    public TenantMetaData(TenantName tenantName, Instant lastDeployed, Instant created) {
        this.tenantName = tenantName;
        this.created = created;
        this.lastDeployed = lastDeployed;
    }

    public TenantMetaData withLastDeployTimestamp(Instant deployTimestamp) {
        return new TenantMetaData(this.tenantName, deployTimestamp, this.created);
    }

    public TenantName tenantName() {
        return this.tenantName;
    }

    public Instant lastDeployTimestamp() {
        return this.lastDeployed;
    }

    public Instant createdTimestamp() {
        return this.created;
    }

    public byte[] asJsonBytes() {
        try {
            return SlimeUtils.toJsonBytes((Slime)this.getSlime());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to encode metadata", e);
        }
    }

    public static TenantMetaData fromJsonString(TenantName tenantName, String jsonString) {
        try {
            Slime data = SlimeUtils.jsonToSlime((String)jsonString);
            Cursor root = data.get();
            Inspector created = root.field(createTimestampKey);
            Inspector lastDeployTimestamp = root.field(lastDeployTimestampKey);
            return new TenantMetaData(tenantName, Instant.ofEpochMilli(lastDeployTimestamp.asLong()), Instant.ofEpochMilli(created.asLong()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing json metadata", e);
        }
    }

    private Slime getSlime() {
        Slime slime = new Slime();
        Cursor meta = slime.setObject();
        meta.setLong(createTimestampKey, this.created.toEpochMilli());
        meta.setLong(lastDeployTimestampKey, this.lastDeployed.toEpochMilli());
        return slime;
    }

    public String toString() {
        return String.valueOf(this.tenantName) + ": " + Utf8.toString((byte[])this.asJsonBytes());
    }
}

