/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.zookeeper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.io.IOUtils;
import com.yahoo.json.Jackson;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.server.zookeeper.ZKApplication;
import com.yahoo.vespa.config.util.ConfigUtils;
import com.yahoo.yolean.Exceptions;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class ZKApplicationFile
extends ApplicationFile {
    private static final Logger log = Logger.getLogger("ZKApplicationFile");
    private final ZKApplication zkApp;
    private final ObjectMapper mapper = Jackson.mapper();

    public ZKApplicationFile(Path path, ZKApplication app) {
        super(path);
        this.zkApp = app;
    }

    public boolean isDirectory() {
        Path zkPath = ZKApplicationFile.getZKPath(this.path);
        if (this.zkApp.exists(zkPath)) {
            String data = this.zkApp.getData(zkPath);
            return data == null || data.isEmpty() || !this.zkApp.getChildren(zkPath).isEmpty();
        }
        return false;
    }

    public boolean exists() {
        try {
            Path zkPath = ZKApplicationFile.getZKPath(this.path);
            return this.zkApp.exists(zkPath);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public ApplicationFile delete() {
        if (!this.listFiles().isEmpty()) {
            throw new RuntimeException("Can't delete, directory not empty: " + String.valueOf((Object)this));
        }
        this.zkApp.deleteRecurse(ZKApplicationFile.getZKPath(this.path));
        this.writeMetaFile("deleted");
        return this;
    }

    public Reader createReader() throws FileNotFoundException {
        Path zkPath = ZKApplicationFile.getZKPath(this.path);
        if (!this.zkApp.exists(zkPath)) {
            throw new FileNotFoundException("No such path: " + String.valueOf(this.path));
        }
        return new StringReader(this.zkApp.getData(zkPath));
    }

    public InputStream createInputStream() throws FileNotFoundException {
        Path zkPath = ZKApplicationFile.getZKPath(this.path);
        if (!this.zkApp.exists(zkPath)) {
            throw new FileNotFoundException("No such path: " + String.valueOf(this.path));
        }
        return new ByteArrayInputStream(this.zkApp.getBytes(zkPath));
    }

    public ApplicationFile createDirectory() {
        Path zkPath = ZKApplicationFile.getZKPath(this.path);
        if (this.isDirectory()) {
            return this;
        }
        if (this.exists()) {
            throw new IllegalArgumentException("Unable to create directory, file exists: " + String.valueOf(this.path));
        }
        this.zkApp.create(zkPath);
        this.writeMetaFile("new");
        return this;
    }

    public ApplicationFile writeFile(Reader input) {
        return (ApplicationFile)Exceptions.uncheck(() -> this.writeFile(Utf8.toBytes((String)IOUtils.readAll((Reader)input))));
    }

    public ApplicationFile writeFile(InputStream input) {
        return (ApplicationFile)Exceptions.uncheck(() -> this.writeFile(input.readAllBytes()));
    }

    private ApplicationFile writeFile(byte[] data) {
        Path zkPath = ZKApplicationFile.getZKPath(this.path);
        String status = "new";
        if (this.zkApp.exists(zkPath)) {
            status = "changed";
        }
        this.zkApp.putData(zkPath, data);
        this.writeMetaFile(data, status);
        return this;
    }

    public ApplicationFile appendFile(String value) {
        String existingData;
        Path zkPath = ZKApplicationFile.getZKPath(this.path);
        String status = "new";
        if (this.zkApp.exists(zkPath)) {
            status = "changed";
        }
        if ((existingData = this.zkApp.getData(zkPath)) == null) {
            existingData = "";
        }
        this.zkApp.putData(zkPath, Utf8.toBytes((String)(existingData + value)));
        this.writeMetaFile(value, status);
        return this;
    }

    public List<ApplicationFile> listFiles(ApplicationFile.PathFilter filter) {
        Path userPath = ZKApplicationFile.getZKPath(this.path);
        ArrayList<ApplicationFile> ret = new ArrayList<ApplicationFile>();
        for (String zkChild : this.zkApp.getChildren(userPath)) {
            Path childPath = this.path.append(zkChild);
            if (childPath.getName().startsWith(".") || !filter.accept(childPath)) continue;
            ret.add(new ZKApplicationFile(childPath, this.zkApp));
        }
        return ret;
    }

    private static Path getZKPath(Path path) {
        if (path.isRoot()) {
            return Path.fromString((String)"/userapp");
        }
        return Path.fromString((String)"/userapp").append(path);
    }

    private void writeMetaFile(String status) {
        this.writeMetaFile((byte[])null, status);
    }

    private void writeMetaFile(String input, String status) {
        this.writeMetaFile(Utf8.toBytes((String)input), status);
    }

    private void writeMetaFile(byte[] input, String status) {
        Path metaPath = ZKApplicationFile.getZKPath(this.getMetaPath());
        StringWriter writer = new StringWriter();
        try {
            this.mapper.writeValue((Writer)writer, (Object)new ApplicationFile.MetaData(status, input == null ? "" : ConfigUtils.getMd5((byte[])input)));
            log.log(Level.FINE, () -> "Writing meta file to " + String.valueOf(metaPath));
            this.zkApp.putData(metaPath, writer.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing meta file to " + String.valueOf(metaPath), e);
        }
    }

    public ApplicationFile.MetaData getMetaData() {
        Path metaPath = ZKApplicationFile.getZKPath(this.getMetaPath());
        log.log(Level.FINE, () -> "Getting metadata for " + String.valueOf(metaPath));
        if (!this.zkApp.exists(ZKApplicationFile.getZKPath(this.path))) {
            if (this.zkApp.exists(metaPath)) {
                return this.getMetaDataFromZk(metaPath);
            }
            return null;
        }
        if (this.zkApp.exists(metaPath)) {
            return this.getMetaDataFromZk(metaPath);
        }
        return new ApplicationFile.MetaData("new", this.isDirectory() ? "" : ConfigUtils.getMd5((byte[])this.zkApp.getBytes(ZKApplicationFile.getZKPath(this.path))));
    }

    private ApplicationFile.MetaData getMetaDataFromZk(Path metaPath) {
        try {
            return (ApplicationFile.MetaData)this.mapper.readValue(this.zkApp.getBytes(metaPath), ApplicationFile.MetaData.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public long getSize() {
        return this.zkApp.getSize(ZKApplicationFile.getZKPath(this.path));
    }

    public int compareTo(ApplicationFile other) {
        if (other == this) {
            return 0;
        }
        return this.getPath().getName().compareTo(other.getPath().getName());
    }
}

