/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.Reindexing;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.vespa.config.server.ConfigServerSpec;
import com.yahoo.vespa.config.server.tenant.SecretStoreExternalIdRetriever;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.Flag;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.vespa.flags.ListFlag;
import com.yahoo.vespa.flags.PermanentFlags;
import com.yahoo.vespa.flags.StringFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import java.io.File;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.ToIntFunction;

public class ModelContextImpl
implements ModelContext {
    private final ApplicationPackage applicationPackage;
    private final Optional<Model> previousModel;
    private final Optional<ApplicationPackage> permanentApplicationPackage;
    private final DeployLogger deployLogger;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final FileRegistry fileRegistry;
    private final ExecutorService executor;
    private final HostProvisioner hostProvisioner;
    private final Provisioned provisioned;
    private final Optional<? extends Reindexing> reindexing;
    private final ModelContext.Properties properties;
    private final Optional<File> appDir;
    private final Optional<DockerImage> wantedDockerImageRepository;
    private final Version modelVespaVersion;
    private final Version wantedNodeVespaVersion;

    public ModelContextImpl(ApplicationPackage applicationPackage, Optional<Model> previousModel, Optional<ApplicationPackage> permanentApplicationPackage, DeployLogger deployLogger, ConfigDefinitionRepo configDefinitionRepo, FileRegistry fileRegistry, ExecutorService executor, Optional<? extends Reindexing> reindexing, HostProvisioner hostProvisioner, Provisioned provisioned, ModelContext.Properties properties, Optional<File> appDir, Optional<DockerImage> wantedDockerImageRepository, Version modelVespaVersion, Version wantedNodeVespaVersion) {
        this.applicationPackage = applicationPackage;
        this.previousModel = previousModel;
        this.permanentApplicationPackage = permanentApplicationPackage;
        this.deployLogger = deployLogger;
        this.configDefinitionRepo = configDefinitionRepo;
        this.fileRegistry = fileRegistry;
        this.executor = executor;
        this.reindexing = reindexing;
        this.hostProvisioner = hostProvisioner;
        this.provisioned = provisioned;
        this.properties = properties;
        this.appDir = appDir;
        this.wantedDockerImageRepository = wantedDockerImageRepository;
        this.modelVespaVersion = modelVespaVersion;
        this.wantedNodeVespaVersion = wantedNodeVespaVersion;
    }

    public ApplicationPackage applicationPackage() {
        return this.applicationPackage;
    }

    public Optional<Model> previousModel() {
        return this.previousModel;
    }

    public Optional<ApplicationPackage> permanentApplicationPackage() {
        return this.permanentApplicationPackage;
    }

    public HostProvisioner getHostProvisioner() {
        return this.hostProvisioner;
    }

    public Provisioned provisioned() {
        return this.provisioned;
    }

    public DeployLogger deployLogger() {
        return this.deployLogger;
    }

    public ConfigDefinitionRepo configDefinitionRepo() {
        return this.configDefinitionRepo;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Optional<? extends Reindexing> reindexing() {
        return this.reindexing;
    }

    public ModelContext.Properties properties() {
        return this.properties;
    }

    public Optional<File> appDir() {
        return this.appDir;
    }

    public Optional<DockerImage> wantedDockerImageRepo() {
        return this.wantedDockerImageRepository;
    }

    public Version modelVespaVersion() {
        return this.modelVespaVersion;
    }

    public Version wantedNodeVespaVersion() {
        return this.wantedNodeVespaVersion;
    }

    public static class Properties
    implements ModelContext.Properties {
        private final ModelContext.FeatureFlags featureFlags;
        private final ApplicationId applicationId;
        private final boolean multitenant;
        private final List<com.yahoo.config.model.api.ConfigServerSpec> configServerSpecs;
        private final HostName loadBalancerName;
        private final URI ztsUrl;
        private final String athenzDnsSuffix;
        private final boolean hostedVespa;
        private final Zone zone;
        private final Set<ContainerEndpoint> endpoints;
        private final boolean isBootstrap;
        private final boolean isFirstTimeDeployment;
        private final Optional<EndpointCertificateSecrets> endpointCertificateSecrets;
        private final Optional<AthenzDomain> athenzDomain;
        private final Quota quota;
        private final List<TenantSecretStore> tenantSecretStores;
        private final SecretStore secretStore;
        private final StringFlag jvmGCOptionsFlag;
        private final boolean allowDisableMtls;
        private final List<X509Certificate> operatorCertificates;
        private final List<String> tlsCiphersOverride;
        private final List<String> zoneDnsSuffixes;
        private final List<String> environmentVariables;
        private final Optional<CloudAccount> cloudAccount;

        public Properties(ApplicationId applicationId, Version modelVersion, ConfigserverConfig configserverConfig, Zone zone, Set<ContainerEndpoint> endpoints, boolean isBootstrap, boolean isFirstTimeDeployment, FlagSource flagSource, Optional<EndpointCertificateSecrets> endpointCertificateSecrets, Optional<AthenzDomain> athenzDomain, Optional<Quota> maybeQuota, List<TenantSecretStore> tenantSecretStores, SecretStore secretStore, List<X509Certificate> operatorCertificates, Optional<CloudAccount> cloudAccount) {
            this.featureFlags = new FeatureFlags(flagSource, applicationId, modelVersion);
            this.applicationId = applicationId;
            this.multitenant = configserverConfig.multitenant() || configserverConfig.hostedVespa() || Boolean.getBoolean("multitenant");
            this.configServerSpecs = ConfigServerSpec.fromConfig(configserverConfig);
            this.loadBalancerName = configserverConfig.loadBalancerAddress().isEmpty() ? null : HostName.of((String)configserverConfig.loadBalancerAddress());
            this.ztsUrl = configserverConfig.ztsUrl() != null ? URI.create(configserverConfig.ztsUrl()) : null;
            this.athenzDnsSuffix = configserverConfig.athenzDnsSuffix();
            this.hostedVespa = configserverConfig.hostedVespa();
            this.zone = zone;
            this.endpoints = endpoints;
            this.isBootstrap = isBootstrap;
            this.isFirstTimeDeployment = isFirstTimeDeployment;
            this.endpointCertificateSecrets = endpointCertificateSecrets;
            this.athenzDomain = athenzDomain;
            this.quota = maybeQuota.orElseGet(Quota::unlimited);
            this.tenantSecretStores = tenantSecretStores;
            this.secretStore = secretStore;
            this.jvmGCOptionsFlag = (StringFlag)((StringFlag)PermanentFlags.JVM_GC_OPTIONS.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm());
            this.allowDisableMtls = ((BooleanFlag)((BooleanFlag)PermanentFlags.ALLOW_DISABLE_MTLS.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.operatorCertificates = operatorCertificates;
            this.tlsCiphersOverride = ((ListFlag)((ListFlag)PermanentFlags.TLS_CIPHERS_OVERRIDE.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.zoneDnsSuffixes = configserverConfig.zoneDnsSuffixes();
            this.environmentVariables = ((ListFlag)((ListFlag)PermanentFlags.ENVIRONMENT_VARIABLES.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.cloudAccount = cloudAccount;
        }

        public ModelContext.FeatureFlags featureFlags() {
            return this.featureFlags;
        }

        public boolean multitenant() {
            return this.multitenant;
        }

        public ApplicationId applicationId() {
            return this.applicationId;
        }

        public List<com.yahoo.config.model.api.ConfigServerSpec> configServerSpecs() {
            return this.configServerSpecs;
        }

        public HostName loadBalancerName() {
            return this.loadBalancerName;
        }

        public URI ztsUrl() {
            return this.ztsUrl;
        }

        public String athenzDnsSuffix() {
            return this.athenzDnsSuffix;
        }

        public boolean hostedVespa() {
            return this.hostedVespa;
        }

        public Zone zone() {
            return this.zone;
        }

        public Set<ContainerEndpoint> endpoints() {
            return this.endpoints;
        }

        public boolean isBootstrap() {
            return this.isBootstrap;
        }

        public boolean isFirstTimeDeployment() {
            return this.isFirstTimeDeployment;
        }

        public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
            return this.endpointCertificateSecrets;
        }

        public Optional<AthenzDomain> athenzDomain() {
            return this.athenzDomain;
        }

        public Quota quota() {
            return this.quota;
        }

        public List<TenantSecretStore> tenantSecretStores() {
            return SecretStoreExternalIdRetriever.populateExternalId(this.secretStore, this.applicationId.tenant(), this.zone.system(), this.tenantSecretStores);
        }

        public String jvmGCOptions(Optional<ClusterSpec.Type> clusterType) {
            return this.flagValueForClusterType(this.jvmGCOptionsFlag, clusterType);
        }

        public boolean allowDisableMtls() {
            return this.allowDisableMtls;
        }

        public List<X509Certificate> operatorCertificates() {
            return this.operatorCertificates;
        }

        public List<String> tlsCiphersOverride() {
            return this.tlsCiphersOverride;
        }

        public List<String> zoneDnsSuffixes() {
            return this.zoneDnsSuffixes;
        }

        public String flagValueForClusterType(StringFlag flag, Optional<ClusterSpec.Type> clusterType) {
            return clusterType.map(type -> (StringFlag)flag.with(FetchVector.Dimension.CLUSTER_TYPE, type.name())).orElse(flag).value();
        }

        public List<String> environmentVariables() {
            return this.environmentVariables;
        }

        public Optional<CloudAccount> cloudAccount() {
            return this.cloudAccount;
        }
    }

    public static class FeatureFlags
    implements ModelContext.FeatureFlags {
        private final String queryDispatchPolicy;
        private final String phraseOptimization;
        private final double defaultTermwiseLimit;
        private final boolean useThreePhaseUpdates;
        private final String feedSequencer;
        private final String responseSequencer;
        private final int numResponseThreads;
        private final boolean skipCommunicationManagerThread;
        private final boolean skipMbusRequestThread;
        private final boolean skipMbusReplyThread;
        private final boolean useAsyncMessageHandlingOnSchedule;
        private final double feedConcurrency;
        private final double feedNiceness;
        private final List<String> allowedAthenzProxyIdentities;
        private final int maxActivationInhibitedOutOfSyncGroups;
        private final ToIntFunction<ClusterSpec.Type> jvmOmitStackTraceInFastThrow;
        private final int maxConcurrentMergesPerContentNode;
        private final int maxMergeQueueSize;
        private final double resourceLimitDisk;
        private final double resourceLimitMemory;
        private final double minNodeRatioPerGroup;
        private final int metricsproxyNumThreads;
        private final int availableProcessors;
        private final boolean containerDumpHeapOnShutdownTimeout;
        private final boolean loadCodeAsHugePages;
        private final double containerShutdownTimeout;
        private final int maxUnCommittedMemory;
        private final boolean forwardIssuesAsErrors;
        private final boolean ignoreThreadStackSizes;
        private final boolean unorderedMergeChaining;
        private final boolean useV8GeoPositions;
        private final int maxCompactBuffers;
        private final List<String> ignoredHttpUserAgents;
        private final String mergeThrottlingPolicy;
        private final double persistenceThrottlingWsDecrementFactor;
        private final double persistenceThrottlingWsBackoff;
        private final int persistenceThrottlingWindowSize;
        private final double persistenceThrottlingWsResizeRate;
        private final boolean persistenceThrottlingOfMergeFeedOps;
        private final boolean useQrserverServiceName;
        private final boolean avoidRenamingSummaryFeatures;
        private final boolean enableBitVectors;
        private final NodeResources.Architecture adminClusterArchitecture;
        private final boolean enableProxyProtocolMixedMode;
        private final boolean sharedStringRepoNoReclaim;
        private final String logFileCompressionAlgorithm;
        private final boolean useTwoPhaseDocumentGc;
        private final boolean mbus_dispatch_on_decode;
        private final boolean mbus_dispatch_on_encode;
        private final int mbus_threads;
        private final int mbus_network_threads;
        private final int mbus_java_num_targets;
        private final int mbus_java_events_before_wakeup;
        private final int mbus_cpp_num_targets;
        private final int mbus_cpp_events_before_wakeup;
        private final int rpc_num_targets;
        private final int rpc_events_before_wakeup;
        private final int clusterControllerStateGatherCount;
        private final boolean useRestrictedDataPlaneBindings;
        private final boolean computeCoverageFromTargetActiveDocs;

        public FeatureFlags(FlagSource source, ApplicationId appId, Version version) {
            this.defaultTermwiseLimit = (Double)FeatureFlags.flagValue(source, appId, version, Flags.DEFAULT_TERM_WISE_LIMIT);
            this.useThreePhaseUpdates = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.USE_THREE_PHASE_UPDATES);
            this.feedSequencer = (String)FeatureFlags.flagValue(source, appId, version, Flags.FEED_SEQUENCER_TYPE);
            this.responseSequencer = (String)FeatureFlags.flagValue(source, appId, version, Flags.RESPONSE_SEQUENCER_TYPE);
            this.numResponseThreads = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.RESPONSE_NUM_THREADS);
            this.skipCommunicationManagerThread = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.SKIP_COMMUNICATIONMANAGER_THREAD);
            this.skipMbusRequestThread = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.SKIP_MBUS_REQUEST_THREAD);
            this.skipMbusReplyThread = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.SKIP_MBUS_REPLY_THREAD);
            this.useAsyncMessageHandlingOnSchedule = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.USE_ASYNC_MESSAGE_HANDLING_ON_SCHEDULE);
            this.feedConcurrency = (Double)FeatureFlags.flagValue(source, appId, version, Flags.FEED_CONCURRENCY);
            this.feedNiceness = (Double)FeatureFlags.flagValue(source, appId, version, Flags.FEED_NICENESS);
            this.mbus_dispatch_on_decode = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.MBUS_DISPATCH_ON_DECODE);
            this.mbus_dispatch_on_encode = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.MBUS_DISPATCH_ON_ENCODE);
            this.mbus_threads = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MBUS_NUM_THREADS);
            this.mbus_network_threads = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MBUS_NUM_NETWORK_THREADS);
            this.allowedAthenzProxyIdentities = (List)FeatureFlags.flagValue(source, appId, version, Flags.ALLOWED_ATHENZ_PROXY_IDENTITIES);
            this.maxActivationInhibitedOutOfSyncGroups = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MAX_ACTIVATION_INHIBITED_OUT_OF_SYNC_GROUPS);
            this.jvmOmitStackTraceInFastThrow = type -> FeatureFlags.flagValueAsInt(source, appId, version, type, PermanentFlags.JVM_OMIT_STACK_TRACE_IN_FAST_THROW);
            this.maxConcurrentMergesPerContentNode = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MAX_CONCURRENT_MERGES_PER_NODE);
            this.maxMergeQueueSize = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MAX_MERGE_QUEUE_SIZE);
            this.resourceLimitDisk = (Double)FeatureFlags.flagValue(source, appId, version, PermanentFlags.RESOURCE_LIMIT_DISK);
            this.resourceLimitMemory = (Double)FeatureFlags.flagValue(source, appId, version, PermanentFlags.RESOURCE_LIMIT_MEMORY);
            this.minNodeRatioPerGroup = (Double)FeatureFlags.flagValue(source, appId, version, Flags.MIN_NODE_RATIO_PER_GROUP);
            this.metricsproxyNumThreads = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.METRICSPROXY_NUM_THREADS);
            this.availableProcessors = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.AVAILABLE_PROCESSORS);
            this.containerDumpHeapOnShutdownTimeout = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.CONTAINER_DUMP_HEAP_ON_SHUTDOWN_TIMEOUT);
            this.loadCodeAsHugePages = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.LOAD_CODE_AS_HUGEPAGES);
            this.containerShutdownTimeout = (Double)FeatureFlags.flagValue(source, appId, version, Flags.CONTAINER_SHUTDOWN_TIMEOUT);
            this.maxUnCommittedMemory = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MAX_UNCOMMITTED_MEMORY);
            this.forwardIssuesAsErrors = (Boolean)FeatureFlags.flagValue(source, appId, version, PermanentFlags.FORWARD_ISSUES_AS_ERRORS);
            this.ignoreThreadStackSizes = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.IGNORE_THREAD_STACK_SIZES);
            this.unorderedMergeChaining = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.UNORDERED_MERGE_CHAINING);
            this.useV8GeoPositions = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.USE_V8_GEO_POSITIONS);
            this.maxCompactBuffers = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MAX_COMPACT_BUFFERS);
            this.ignoredHttpUserAgents = (List)FeatureFlags.flagValue(source, appId, version, PermanentFlags.IGNORED_HTTP_USER_AGENTS);
            this.mergeThrottlingPolicy = (String)FeatureFlags.flagValue(source, appId, version, Flags.MERGE_THROTTLING_POLICY);
            this.persistenceThrottlingWsDecrementFactor = (Double)FeatureFlags.flagValue(source, appId, version, Flags.PERSISTENCE_THROTTLING_WS_DECREMENT_FACTOR);
            this.persistenceThrottlingWsBackoff = (Double)FeatureFlags.flagValue(source, appId, version, Flags.PERSISTENCE_THROTTLING_WS_BACKOFF);
            this.persistenceThrottlingWindowSize = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.PERSISTENCE_THROTTLING_WINDOW_SIZE);
            this.persistenceThrottlingWsResizeRate = (Double)FeatureFlags.flagValue(source, appId, version, Flags.PERSISTENCE_THROTTLING_WS_RESIZE_RATE);
            this.persistenceThrottlingOfMergeFeedOps = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.PERSISTENCE_THROTTLING_OF_MERGE_FEED_OPS);
            this.useQrserverServiceName = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.USE_QRSERVER_SERVICE_NAME);
            this.avoidRenamingSummaryFeatures = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.AVOID_RENAMING_SUMMARY_FEATURES);
            this.enableBitVectors = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.ENABLE_BIT_VECTORS);
            this.adminClusterArchitecture = NodeResources.Architecture.valueOf((String)((String)FeatureFlags.flagValue(source, appId, version, PermanentFlags.ADMIN_CLUSTER_NODE_ARCHITECTURE)));
            this.enableProxyProtocolMixedMode = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.ENABLE_PROXY_PROTOCOL_MIXED_MODE);
            this.sharedStringRepoNoReclaim = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.SHARED_STRING_REPO_NO_RECLAIM);
            this.logFileCompressionAlgorithm = (String)FeatureFlags.flagValue(source, appId, version, Flags.LOG_FILE_COMPRESSION_ALGORITHM);
            this.useTwoPhaseDocumentGc = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.USE_TWO_PHASE_DOCUMENT_GC);
            this.mbus_java_num_targets = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MBUS_JAVA_NUM_TARGETS);
            this.mbus_java_events_before_wakeup = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MBUS_JAVA_EVENTS_BEFORE_WAKEUP);
            this.mbus_cpp_num_targets = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MBUS_CPP_NUM_TARGETS);
            this.mbus_cpp_events_before_wakeup = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MBUS_CPP_EVENTS_BEFORE_WAKEUP);
            this.rpc_num_targets = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.RPC_NUM_TARGETS);
            this.rpc_events_before_wakeup = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.RPC_EVENTS_BEFORE_WAKEUP);
            this.queryDispatchPolicy = (String)FeatureFlags.flagValue(source, appId, version, Flags.QUERY_DISPATCH_POLICY);
            this.phraseOptimization = (String)FeatureFlags.flagValue(source, appId, version, Flags.PHRASE_OPTIMIZATION);
            this.clusterControllerStateGatherCount = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.CLUSTER_CONTROLLER_STATE_GATHER_COUNT);
            this.useRestrictedDataPlaneBindings = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.RESTRICT_DATA_PLANE_BINDINGS);
            this.computeCoverageFromTargetActiveDocs = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.COMPUTE_COVERAGE_FROM_TARGET_ACTIVE_DOCS);
        }

        public String queryDispatchPolicy() {
            return this.queryDispatchPolicy;
        }

        public String phraseOptimization() {
            return this.phraseOptimization;
        }

        public double defaultTermwiseLimit() {
            return this.defaultTermwiseLimit;
        }

        public boolean useThreePhaseUpdates() {
            return this.useThreePhaseUpdates;
        }

        public String feedSequencerType() {
            return this.feedSequencer;
        }

        public String responseSequencerType() {
            return this.responseSequencer;
        }

        public int defaultNumResponseThreads() {
            return this.numResponseThreads;
        }

        public boolean skipCommunicationManagerThread() {
            return this.skipCommunicationManagerThread;
        }

        public boolean skipMbusRequestThread() {
            return this.skipMbusRequestThread;
        }

        public boolean skipMbusReplyThread() {
            return this.skipMbusReplyThread;
        }

        public boolean useAsyncMessageHandlingOnSchedule() {
            return this.useAsyncMessageHandlingOnSchedule;
        }

        public double feedConcurrency() {
            return this.feedConcurrency;
        }

        public double feedNiceness() {
            return this.feedNiceness;
        }

        public boolean mbusDispatchOnDecode() {
            return this.mbus_dispatch_on_decode;
        }

        public boolean mbusDispatchOnEncode() {
            return this.mbus_dispatch_on_encode;
        }

        public int mbusNetworkThreads() {
            return this.mbus_network_threads;
        }

        public int mbusThreads() {
            return this.mbus_threads;
        }

        public List<String> allowedAthenzProxyIdentities() {
            return this.allowedAthenzProxyIdentities;
        }

        public int maxActivationInhibitedOutOfSyncGroups() {
            return this.maxActivationInhibitedOutOfSyncGroups;
        }

        public String jvmOmitStackTraceInFastThrowOption(ClusterSpec.Type type) {
            return this.translateJvmOmitStackTraceInFastThrowIntToString(this.jvmOmitStackTraceInFastThrow, type);
        }

        public int maxConcurrentMergesPerNode() {
            return this.maxConcurrentMergesPerContentNode;
        }

        public int maxMergeQueueSize() {
            return this.maxMergeQueueSize;
        }

        public double resourceLimitDisk() {
            return this.resourceLimitDisk;
        }

        public double resourceLimitMemory() {
            return this.resourceLimitMemory;
        }

        public double minNodeRatioPerGroup() {
            return this.minNodeRatioPerGroup;
        }

        public int defaultPoolNumThreads() {
            return this.metricsproxyNumThreads;
        }

        public int availableProcessors() {
            return this.availableProcessors;
        }

        public double containerShutdownTimeout() {
            return this.containerShutdownTimeout;
        }

        public boolean containerDumpHeapOnShutdownTimeout() {
            return this.containerDumpHeapOnShutdownTimeout;
        }

        public boolean loadCodeAsHugePages() {
            return this.loadCodeAsHugePages;
        }

        public int maxUnCommittedMemory() {
            return this.maxUnCommittedMemory;
        }

        public boolean forwardIssuesAsErrors() {
            return this.forwardIssuesAsErrors;
        }

        public boolean ignoreThreadStackSizes() {
            return this.ignoreThreadStackSizes;
        }

        public boolean unorderedMergeChaining() {
            return this.unorderedMergeChaining;
        }

        public boolean useV8GeoPositions() {
            return this.useV8GeoPositions;
        }

        public int maxCompactBuffers() {
            return this.maxCompactBuffers;
        }

        public List<String> ignoredHttpUserAgents() {
            return this.ignoredHttpUserAgents;
        }

        public String mergeThrottlingPolicy() {
            return this.mergeThrottlingPolicy;
        }

        public double persistenceThrottlingWsDecrementFactor() {
            return this.persistenceThrottlingWsDecrementFactor;
        }

        public double persistenceThrottlingWsBackoff() {
            return this.persistenceThrottlingWsBackoff;
        }

        public int persistenceThrottlingWindowSize() {
            return this.persistenceThrottlingWindowSize;
        }

        public double persistenceThrottlingWsResizeRate() {
            return this.persistenceThrottlingWsResizeRate;
        }

        public boolean persistenceThrottlingOfMergeFeedOps() {
            return this.persistenceThrottlingOfMergeFeedOps;
        }

        public boolean useQrserverServiceName() {
            return this.useQrserverServiceName;
        }

        public boolean avoidRenamingSummaryFeatures() {
            return this.avoidRenamingSummaryFeatures;
        }

        public boolean enableBitVectors() {
            return this.enableBitVectors;
        }

        public NodeResources.Architecture adminClusterArchitecture() {
            return this.adminClusterArchitecture;
        }

        public boolean enableProxyProtocolMixedMode() {
            return this.enableProxyProtocolMixedMode;
        }

        public boolean sharedStringRepoNoReclaim() {
            return this.sharedStringRepoNoReclaim;
        }

        public int mbusJavaRpcNumTargets() {
            return this.mbus_java_num_targets;
        }

        public int mbusJavaEventsBeforeWakeup() {
            return this.mbus_java_events_before_wakeup;
        }

        public int mbusCppRpcNumTargets() {
            return this.mbus_cpp_num_targets;
        }

        public int mbusCppEventsBeforeWakeup() {
            return this.mbus_cpp_events_before_wakeup;
        }

        public int rpcNumTargets() {
            return this.rpc_num_targets;
        }

        public int rpcEventsBeforeWakeup() {
            return this.rpc_events_before_wakeup;
        }

        public String logFileCompressionAlgorithm(String defVal) {
            String fflag = this.logFileCompressionAlgorithm;
            if (fflag != null && !fflag.equals("")) {
                return fflag;
            }
            return defVal;
        }

        public boolean useTwoPhaseDocumentGc() {
            return this.useTwoPhaseDocumentGc;
        }

        public int clusterControllerStateGatherCount() {
            return this.clusterControllerStateGatherCount;
        }

        public boolean useRestrictedDataPlaneBindings() {
            return this.useRestrictedDataPlaneBindings;
        }

        public boolean computeCoverageFromTargetActiveDocs() {
            return this.computeCoverageFromTargetActiveDocs;
        }

        private static <V> V flagValue(FlagSource source, ApplicationId appId, Version vespaVersion, UnboundFlag<? extends V, ?, ?> flag) {
            return (V)((Flag)((Flag)flag.bindTo(source).with(FetchVector.Dimension.APPLICATION_ID, appId.serializedForm())).with(FetchVector.Dimension.VESPA_VERSION, vespaVersion.toFullString())).boxedValue();
        }

        private static <V> V flagValue(FlagSource source, TenantName tenant, Version vespaVersion, UnboundFlag<? extends V, ?, ?> flag) {
            return (V)((Flag)((Flag)flag.bindTo(source).with(FetchVector.Dimension.TENANT_ID, tenant.value())).with(FetchVector.Dimension.VESPA_VERSION, vespaVersion.toFullString())).boxedValue();
        }

        private static <V> V flagValue(FlagSource source, ApplicationId appId, Version vespaVersion, ClusterSpec.Type clusterType, UnboundFlag<? extends V, ?, ?> flag) {
            return (V)((Flag)((Flag)((Flag)flag.bindTo(source).with(FetchVector.Dimension.APPLICATION_ID, appId.serializedForm())).with(FetchVector.Dimension.CLUSTER_TYPE, clusterType.name())).with(FetchVector.Dimension.VESPA_VERSION, vespaVersion.toFullString())).boxedValue();
        }

        static int flagValueAsInt(FlagSource source, ApplicationId appId, Version version, ClusterSpec.Type clusterType, UnboundFlag<? extends Boolean, ?, ?> flag) {
            return FeatureFlags.flagValue(source, appId, version, clusterType, flag) != false ? 1 : 0;
        }

        private String translateJvmOmitStackTraceInFastThrowIntToString(ToIntFunction<ClusterSpec.Type> function, ClusterSpec.Type clusterType) {
            return function.applyAsInt(clusterType) == 1 ? "" : "-XX:-OmitStackTraceInFastThrow";
        }
    }
}

