/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import ai.vespa.http.DomainName;
import ai.vespa.http.HttpURL;
import ai.vespa.util.http.hc5.VespaHttpClientBuilder;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.ProxyResponse;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;

public class TesterClient {
    private final CloseableHttpClient httpClient = VespaHttpClientBuilder.custom().buildClient();
    private static final Logger logger = Logger.getLogger(TesterClient.class.getName());

    public HttpResponse getStatus(String testerHostname, int port) {
        URI testerUri = this.testerUrl(testerHostname, port, "tester", "v1", "status").asURI();
        return this.execute((HttpUriRequest)new HttpGet(testerUri), "Failed to get tester status");
    }

    public HttpResponse getLog(String testerHostname, int port, Long after) {
        URI testerUri = this.testerUrl(testerHostname, port, "tester", "v1", "log").withQuery(HttpURL.Query.empty().set("after", Long.toString(after))).asURI();
        return this.execute((HttpUriRequest)new HttpGet(testerUri), "Failed to get tester logs");
    }

    public HttpResponse startTests(String testerHostname, int port, String suite, byte[] config) {
        URI testerUri = this.testerUrl(testerHostname, port, "tester", "v1", "run", suite).asURI();
        HttpPost request = new HttpPost(testerUri);
        request.setEntity((HttpEntity)new ByteArrayEntity(config, ContentType.DEFAULT_BINARY));
        return this.execute((HttpUriRequest)request, "Failed to start tests");
    }

    public HttpResponse isTesterReady(String testerHostname, int port) {
        URI testerUri = this.testerUrl(testerHostname, port, "status.html").asURI();
        return this.execute((HttpUriRequest)new HttpGet(testerUri), "/status.html did not return 200 OK");
    }

    public HttpResponse getReport(String testerHostname, int port) {
        URI testerUri = this.testerUrl(testerHostname, port, "tester", "v1", "report").asURI();
        return this.execute((HttpUriRequest)new HttpGet(testerUri), "Failed to get test report");
    }

    private HttpResponse execute(HttpUriRequest request, String messageIfRequestFails) {
        logger.log(Level.FINE, () -> "Sending request to tester container " + request.getRequestUri());
        try {
            return new ProxyResponse(this.httpClient.execute((ClassicHttpRequest)request));
        }
        catch (IOException e) {
            logger.warning(messageIfRequestFails + ": " + Exceptions.toMessageString((Throwable)e));
            return HttpErrorResponse.internalServerError(Exceptions.toMessageString((Throwable)e));
        }
    }

    private HttpURL testerUrl(String testerHostname, int port, String ... path) {
        return HttpURL.create((HttpURL.Scheme)HttpURL.Scheme.https, (DomainName)DomainName.of((String)testerHostname), (int)port, (HttpURL.Path)HttpURL.Path.empty().append(List.of(path)).withoutTrailingSlash());
    }
}

