/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.modelfactory;

import com.yahoo.collections.Pair;
import com.yahoo.component.Version;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.HostSpec;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class AllocatedHostsFromAllModels {
    private final Map<String, Pair<HostSpec, Version>> hosts = new LinkedHashMap<String, Pair<HostSpec, Version>>();

    public void add(AllocatedHosts allocatedHosts, Version version) {
        for (HostSpec newHost : allocatedHosts.getHosts()) {
            Pair<HostSpec, Version> presentHost = this.hosts.get(newHost.hostname());
            if (presentHost != null && !version.isAfter((Version)presentHost.getSecond())) continue;
            this.hosts.put(newHost.hostname(), (Pair<HostSpec, Version>)new Pair((Object)newHost, (Object)version));
        }
    }

    public AllocatedHosts toAllocatedHosts() {
        LinkedHashSet<HostSpec> hostSet = new LinkedHashSet<HostSpec>();
        for (Pair<HostSpec, Version> host : this.hosts.values()) {
            hostSet.add((HostSpec)host.getFirst());
        }
        return AllocatedHosts.withHosts(hostSet);
    }
}

