/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.curator.Curator;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.recipes.cache.ChildData;

public class SessionStateWatcher {
    private static final Logger log = Logger.getLogger(SessionStateWatcher.class.getName());
    private final Curator.FileCache fileCache;
    private final long sessionId;
    private final MetricUpdater metrics;
    private final Executor zkWatcherExecutor;
    private final SessionRepository sessionRepository;

    SessionStateWatcher(Curator.FileCache fileCache, long sessionId, MetricUpdater metrics, Executor zkWatcherExecutor, SessionRepository sessionRepository) {
        this.fileCache = fileCache;
        this.sessionId = sessionId;
        this.metrics = metrics;
        this.fileCache.addListener(this::nodeChanged);
        this.fileCache.start();
        this.zkWatcherExecutor = zkWatcherExecutor;
        this.sessionRepository = sessionRepository;
    }

    private synchronized void sessionStatusChanged(Session.Status newStatus) {
        switch (newStatus) {
            case NEW: 
            case UNKNOWN: {
                break;
            }
            case DELETE: 
            case DEACTIVATE: {
                this.sessionRepository.deactivateSession(this.sessionId);
                break;
            }
            case PREPARE: {
                this.sessionRepository.prepareRemoteSession(this.sessionId);
                break;
            }
            case ACTIVATE: {
                this.sessionRepository.activate(this.sessionId);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown status " + String.valueOf((Object)newStatus));
            }
        }
    }

    public void close() {
        try {
            this.fileCache.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception when closing watcher", e);
        }
    }

    private void nodeChanged() {
        this.zkWatcherExecutor.execute(() -> {
            Session.Status newStatus = Session.Status.UNKNOWN;
            try {
                ChildData node = this.fileCache.getCurrentData();
                if (node != null) {
                    newStatus = Session.Status.parse(Utf8.toString((byte[])node.getData()));
                    this.sessionStatusChanged(newStatus);
                }
            }
            catch (NotFoundException e) {
                log.log(Level.INFO, "Session or application not found when handling session change to " + newStatus.name() + " for session " + this.sessionId);
                this.metrics.incSessionChangeErrors();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error handling session change to " + newStatus.name() + " for session " + this.sessionId, e);
                this.metrics.incSessionChangeErrors();
            }
        });
    }
}

