/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringArray;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Value;
import com.yahoo.net.HostName;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import java.time.Duration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileDistributionImpl
implements FileDistribution,
RequestWaiter {
    private static final Logger log = Logger.getLogger(FileDistributionImpl.class.getName());
    private static final Duration rpcTimeout = Duration.ofSeconds(11L);
    private final Supervisor supervisor;
    private final FlagSource flagSource;

    public FileDistributionImpl(Supervisor supervisor, FlagSource flagSource) {
        this.supervisor = supervisor;
        this.flagSource = flagSource;
    }

    public void triggerDownload(String hostName, int port, Set<FileReference> fileReferences) {
        if (((BooleanFlag)Flags.CONFIG_SERVER_TRIGGER_DOWNLOAD_WITH_SOURCE.bindTo(this.flagSource)).value()) {
            this.triggerDownloadIncludeHost(hostName, port, fileReferences);
        } else {
            Target target = this.supervisor.connect(new Spec(hostName, port));
            Request request = new Request("filedistribution.setFileReferencesToDownload");
            request.setContext((Object)target);
            request.parameters().add((Value)new StringArray((String[])fileReferences.stream().map(FileReference::value).toArray(String[]::new)));
            log.log(Level.FINE, () -> "Executing " + request.methodName() + " against " + target + ": " + fileReferences);
            target.invokeAsync(request, rpcTimeout, (RequestWaiter)this);
        }
    }

    private void triggerDownloadIncludeHost(String hostName, int port, Set<FileReference> fileReferences) {
        Target target = this.supervisor.connect(new Spec(hostName, port));
        Request request = new Request("filedistribution.triggerDownload");
        request.setContext((Object)target);
        request.parameters().add((Value)new StringArray((String[])fileReferences.stream().map(FileReference::value).toArray(String[]::new)));
        request.parameters().add((Value)new StringValue(new Spec(HostName.getLocalhost(), 19070).toString()));
        log.log(Level.FINE, () -> "Executing " + request.methodName() + " against " + target + ": " + fileReferences);
        target.invokeAsync(request, rpcTimeout, (RequestWaiter)this);
    }

    public void handleRequestDone(Request req) {
        Target target = (Target)req.getContext();
        if (req.isError()) {
            log.log(Level.FINE, () -> req.methodName() + " failed for " + target + ": " + req.errorCode() + " (" + req.errorMessage() + ")");
        }
        if (target != null) {
            target.close();
        }
    }
}

