/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.yahoo.component.annotation.Inject;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.JSONResponse;
import com.yahoo.vespa.config.server.http.v2.request.HttpConfigRequests;

public class HostHandler
extends HttpHandler {
    private final ApplicationRepository applicationRepository;

    @Inject
    public HostHandler(ThreadedHttpRequestHandler.Context ctx, ApplicationRepository applicationRepository) {
        super(ctx);
        this.applicationRepository = applicationRepository;
    }

    @Override
    public HttpResponse handleGET(HttpRequest request) {
        String hostname = HostHandler.getBindingMatch(request).group(2);
        ApplicationId applicationId = this.applicationRepository.getApplicationIdForHostname(hostname);
        return applicationId == null ? this.createError(hostname) : new HostResponse(200, applicationId, this.applicationRepository.zone());
    }

    private HttpErrorResponse createError(String hostname) {
        return HttpErrorResponse.notFoundError("Could not find any application using host '" + hostname + "'");
    }

    private static BindingMatch<?> getBindingMatch(HttpRequest request) {
        return HttpConfigRequests.getBindingMatch(request, "http://*/application/v2/host/*");
    }

    private static class HostResponse
    extends JSONResponse {
        public HostResponse(int status, ApplicationId applicationId, Zone zone) {
            super(status);
            this.object.setString("tenant", applicationId.tenant().value());
            this.object.setString("application", applicationId.application().value());
            this.object.setString("environment", zone.environment().value());
            this.object.setString("region", zone.region().value());
            this.object.setString("instance", applicationId.instance().value());
        }
    }
}

