/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.monitoring;

import com.yahoo.jdisc.Metric;
import com.yahoo.vespa.config.server.monitoring.Metrics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MetricUpdater {
    private static final String METRIC_UNKNOWN_HOSTS = Metrics.getMetricName("unknownHostRequests");
    private static final String METRIC_SESSION_CHANGE_ERRORS = Metrics.getMetricName("sessionChangeErrors");
    private static final String METRIC_NEW_SESSIONS = Metrics.getMetricName("newSessions");
    private static final String METRIC_PREPARED_SESSIONS = Metrics.getMetricName("preparedSessions");
    private static final String METRIC_ACTIVATED_SESSIONS = Metrics.getMetricName("activeSessions");
    private static final String METRIC_DEACTIVATED_SESSIONS = Metrics.getMetricName("inactiveSessions");
    private static final String METRIC_ADDED_SESSIONS = Metrics.getMetricName("addedSessions");
    private static final String METRIC_REMOVED_SESSIONS = Metrics.getMetricName("removedSessions");
    private static final String METRIC_ZK_CONNECTION_LOST = Metrics.getMetricName("zkConnectionLost");
    private static final String METRIC_ZK_RECONNECTED = Metrics.getMetricName("zkReconnected");
    private static final String METRIC_ZK_CONNECTED = Metrics.getMetricName("zkConnected");
    private static final String METRIC_ZK_SUSPENDED = Metrics.getMetricName("zkSuspended");
    private static final String METRIC_TENANTS = Metrics.getMetricName("tenants");
    private static final String METRIC_HOSTS = Metrics.getMetricName("hosts");
    private static final String METRIC_APPLICATIONS = Metrics.getMetricName("applications");
    private static final String METRIC_CACHE_CONFIG_ELEMENTS = Metrics.getMetricName("cacheConfigElems");
    private static final String METRIC_CACHE_CONFIG_CHECKSUMS = Metrics.getMetricName("cacheChecksumElems");
    private static final String METRIC_DELAYED_RESPONSES = Metrics.getMetricName("delayedResponses");
    private static final String METRIC_RPCSERVER_WORK_QUEUE_SIZE = Metrics.getMetricName("rpcServerWorkQueueSize");
    private final Metrics metrics;
    private final Map<String, String> dimensions;
    private final Metric.Context metricContext;
    private final Map<String, Number> staticMetrics = new ConcurrentHashMap<String, Number>();

    public MetricUpdater(Metrics metrics, Map<String, String> dimensions) {
        this.metrics = metrics;
        this.dimensions = dimensions;
        this.metricContext = this.createContext(metrics, dimensions);
    }

    public void incrementRequests() {
        this.metrics.incrementRequests(this.metricContext);
    }

    public void incrementFailedRequests() {
        this.metrics.incrementFailedRequests(this.metricContext);
    }

    public void incrementProcTime(long increment) {
        this.metrics.incrementProcTime(increment, this.metricContext);
    }

    public void setCacheConfigElems(long elems) {
        this.staticMetrics.put(METRIC_CACHE_CONFIG_ELEMENTS, elems);
    }

    public void setCacheChecksumElems(long elems) {
        this.staticMetrics.put(METRIC_CACHE_CONFIG_CHECKSUMS, elems);
    }

    public void setDelayedResponses(long elems) {
        this.staticMetrics.put(METRIC_DELAYED_RESPONSES, elems);
    }

    private void setStaticMetric(String name, int size) {
        this.staticMetrics.put(name, size);
    }

    public void incUnknownHostRequests() {
        this.metrics.increment(METRIC_UNKNOWN_HOSTS, this.metricContext);
    }

    private Metric.Context createContext(Metrics metrics, Map<String, String> dimensions) {
        if (metrics == null) {
            return null;
        }
        return metrics.getMetric().createContext(dimensions);
    }

    public Map<String, Number> getStaticMetrics() {
        return this.staticMetrics;
    }

    public Metric.Context getMetricContext() {
        return this.metricContext;
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public void incSessionChangeErrors() {
        this.metrics.increment(METRIC_SESSION_CHANGE_ERRORS, this.metricContext);
    }

    public void setNewSessions(int numNew) {
        this.setStaticMetric(METRIC_NEW_SESSIONS, numNew);
    }

    public void setPreparedSessions(int numPrepared) {
        this.setStaticMetric(METRIC_PREPARED_SESSIONS, numPrepared);
    }

    public void setActivatedSessions(int numActivated) {
        this.setStaticMetric(METRIC_ACTIVATED_SESSIONS, numActivated);
    }

    public void setDeactivatedSessions(int numDeactivated) {
        this.setStaticMetric(METRIC_DEACTIVATED_SESSIONS, numDeactivated);
    }

    public void incRemovedSessions() {
        this.metrics.increment(METRIC_REMOVED_SESSIONS, this.metricContext);
    }

    public void incAddedSessions() {
        this.metrics.increment(METRIC_ADDED_SESSIONS, this.metricContext);
    }

    public static MetricUpdater createTestUpdater() {
        return new MetricUpdater(Metrics.createTestMetrics(), null);
    }

    public void incZKConnectionLost() {
        this.metrics.increment(METRIC_ZK_CONNECTION_LOST, this.metricContext);
    }

    public void incZKConnected() {
        this.metrics.increment(METRIC_ZK_CONNECTED, this.metricContext);
    }

    public void incZKSuspended() {
        this.metrics.increment(METRIC_ZK_SUSPENDED, this.metricContext);
    }

    public void incZKReconnected() {
        this.metrics.increment(METRIC_ZK_RECONNECTED, this.metricContext);
    }

    public void setTenants(int numTenants) {
        this.setStaticMetric(METRIC_TENANTS, numTenants);
    }

    public void setHosts(int numHosts) {
        this.setStaticMetric(METRIC_HOSTS, numHosts);
    }

    public void setApplications(int numApplications) {
        this.setStaticMetric(METRIC_APPLICATIONS, numApplications);
    }

    public void setRpcServerQueueSize(int numQueued) {
        this.metrics.set(METRIC_RPCSERVER_WORK_QUEUE_SIZE, numQueued, this.metricContext);
    }
}

