/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationCuratorDatabase;
import com.yahoo.vespa.config.server.application.ApplicationReindexing;
import com.yahoo.vespa.config.server.application.ConfigConvergenceChecker;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.yolean.Exceptions;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReindexingMaintainer
extends ConfigServerMaintainer {
    private static final Logger log = Logger.getLogger(ReindexingMaintainer.class.getName());
    private static final Duration timeout = Duration.ofSeconds(10L);
    public static final double SPEED = 1.0;
    static final String CAUSE = "reindexing due to a schema change";
    private final ConfigConvergenceChecker convergence;
    private final Clock clock;

    public ReindexingMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, ConfigConvergenceChecker convergence, Clock clock) {
        super(applicationRepository, curator, applicationRepository.flagSource(), clock, interval, true);
        this.convergence = convergence;
        this.clock = clock;
    }

    protected double maintain() {
        AtomicInteger attempts = new AtomicInteger(0);
        AtomicInteger failures = new AtomicInteger(0);
        for (Tenant tenant : this.applicationRepository.tenantRepository().getAllTenants()) {
            ApplicationCuratorDatabase database = tenant.getApplicationRepo().database();
            for (ApplicationId id : database.activeApplications()) {
                this.applicationRepository.getActiveApplicationVersions(id).map(application -> application.getForVersionOrLatest(Optional.empty(), this.clock.instant())).ifPresent(application -> {
                    try {
                        attempts.incrementAndGet();
                        this.applicationRepository.modifyReindexing(id, reindexing -> {
                            reindexing = ReindexingMaintainer.withNewReady(reindexing, this.lazyGeneration((Application)application), this.clock.instant());
                            reindexing = ReindexingMaintainer.withOnlyCurrentData(reindexing, application);
                            return reindexing;
                        });
                    }
                    catch (RuntimeException e) {
                        log.log(Level.INFO, "Failed to update reindexing status for " + id + ": " + Exceptions.toMessageString((Throwable)e));
                        failures.incrementAndGet();
                    }
                });
            }
        }
        return this.asSuccessFactorDeviation(attempts.get(), failures.get());
    }

    private Supplier<Long> lazyGeneration(Application application) {
        AtomicLong oldest = new AtomicLong();
        return () -> {
            if (oldest.get() == 0L) {
                oldest.set(this.convergence.getServiceConfigGenerations(application, timeout).values().stream().min(Comparator.naturalOrder()).orElse(-1L));
            }
            return oldest.get();
        };
    }

    static ApplicationReindexing withNewReady(ApplicationReindexing reindexing, Supplier<Long> oldestGeneration, Instant now) {
        for (Map.Entry<String, ApplicationReindexing.Cluster> cluster : reindexing.clusters().entrySet()) {
            for (Map.Entry<String, Long> pending : cluster.getValue().pending().entrySet()) {
                if (pending.getValue() > oldestGeneration.get()) continue;
                reindexing = reindexing.withReady(cluster.getKey(), pending.getKey(), now, 1.0, CAUSE).withoutPending(cluster.getKey(), pending.getKey());
            }
        }
        return reindexing;
    }

    static ApplicationReindexing withOnlyCurrentData(ApplicationReindexing reindexing, Application application) {
        return ReindexingMaintainer.withOnlyCurrentData(reindexing, application.getModel().documentTypesByCluster());
    }

    static ApplicationReindexing withOnlyCurrentData(ApplicationReindexing reindexing, Map<String, ? extends Collection<String>> clusterDocumentTypes) {
        for (String clusterId : reindexing.clusters().keySet()) {
            if (!clusterDocumentTypes.containsKey(clusterId)) {
                reindexing = reindexing.without(clusterId);
                continue;
            }
            ApplicationReindexing.Cluster cluster = reindexing.clusters().get(clusterId);
            Collection<String> documentTypes = clusterDocumentTypes.get(clusterId);
            for (String pending : cluster.pending().keySet()) {
                if (documentTypes.contains(pending)) continue;
                reindexing = reindexing.withoutPending(clusterId, pending);
            }
            for (String ready : cluster.ready().keySet()) {
                if (documentTypes.contains(ready)) continue;
                reindexing = reindexing.without(clusterId, ready);
            }
        }
        return reindexing;
    }
}

