/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.concurrent.StripedExecutor;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.EndpointCertificateSecretStore;
import com.yahoo.config.model.api.OnnxModelCost;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.model.application.provider.DeployData;
import com.yahoo.config.model.application.provider.FilesApplicationPackage;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.CloudName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.io.IOUtils;
import com.yahoo.path.Path;
import com.yahoo.transaction.AbstractTransaction;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.ConfigServerDB;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.application.ApplicationVersions;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.deploy.TenantFileSystemDirs;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionFactory;
import com.yahoo.vespa.config.server.http.InvalidApplicationException;
import com.yahoo.vespa.config.server.http.UnknownVespaVersionException;
import com.yahoo.vespa.config.server.modelfactory.ActivatedModelsBuilder;
import com.yahoo.vespa.config.server.modelfactory.AllocatedHostsFromAllModels;
import com.yahoo.vespa.config.server.modelfactory.ModelFactoryRegistry;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.monitoring.Metrics;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.session.ActivationTriggers;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionData;
import com.yahoo.vespa.config.server.session.SessionPreparer;
import com.yahoo.vespa.config.server.session.SessionSerializer;
import com.yahoo.vespa.config.server.session.SessionStateWatcher;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.config.server.zookeeper.SessionCounter;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.Lock;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.Dimension;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.vespa.flags.LongFlag;
import com.yahoo.vespa.flags.PermanentFlags;
import com.yahoo.vespa.flags.StringFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import com.yahoo.yolean.Exceptions;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.zookeeper.KeeperException;

public class SessionRepository {
    private static final Logger log = Logger.getLogger(SessionRepository.class.getName());
    private static final FilenameFilter sessionApplicationsFilter = (dir, name) -> name.matches("\\d+");
    private static final long nonExistingActiveSessionId = 0L;
    private final Object monitor = new Object();
    private final Map<Long, LocalSession> localSessionCache = Collections.synchronizedMap(new HashMap());
    private final Map<Long, RemoteSession> remoteSessionCache = Collections.synchronizedMap(new HashMap());
    private final Map<Long, SessionStateWatcher> sessionStateWatchers = Collections.synchronizedMap(new HashMap());
    private final Clock clock;
    private final Curator curator;
    private final Executor zkWatcherExecutor;
    private final FileDistributionFactory fileDistributionFactory;
    private final FlagSource flagSource;
    private final TenantFileSystemDirs tenantFileSystemDirs;
    private final Metrics metrics;
    private final MetricUpdater metricUpdater;
    private final Curator.DirectoryCache directoryCache;
    private final TenantApplications applicationRepo;
    private final SessionPreparer sessionPreparer;
    private final Path sessionsPath;
    private final TenantName tenantName;
    private final OnnxModelCost onnxModelCost;
    private final List<EndpointCertificateSecretStore> endpointCertificateSecretStores;
    private final SessionCounter sessionCounter;
    private final SecretStore secretStore;
    private final HostProvisionerProvider hostProvisionerProvider;
    private final ConfigserverConfig configserverConfig;
    private final ConfigServerDB configServerDB;
    private final Zone zone;
    private final ModelFactoryRegistry modelFactoryRegistry;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final int maxNodeSize;
    private final LongFlag expiryTimeFlag;
    private final BooleanFlag writeSessionData;
    private final BooleanFlag readSessionData;

    public SessionRepository(TenantName tenantName, TenantApplications applicationRepo, SessionPreparer sessionPreparer, Curator curator, Metrics metrics, StripedExecutor<TenantName> zkWatcherExecutor, FileDistributionFactory fileDistributionFactory, FlagSource flagSource, ExecutorService zkCacheExecutor, SecretStore secretStore, HostProvisionerProvider hostProvisionerProvider, ConfigserverConfig configserverConfig, ConfigServerDB configServerDB, Zone zone, Clock clock, ModelFactoryRegistry modelFactoryRegistry, ConfigDefinitionRepo configDefinitionRepo, int maxNodeSize, OnnxModelCost onnxModelCost, List<EndpointCertificateSecretStore> endpointCertificateSecretStores) {
        this.tenantName = tenantName;
        this.onnxModelCost = onnxModelCost;
        this.endpointCertificateSecretStores = endpointCertificateSecretStores;
        this.sessionCounter = new SessionCounter(curator, tenantName);
        this.sessionsPath = TenantRepository.getSessionsPath(tenantName);
        this.clock = clock;
        this.curator = curator;
        this.zkWatcherExecutor = command -> zkWatcherExecutor.execute((Object)tenantName, command);
        this.fileDistributionFactory = fileDistributionFactory;
        this.flagSource = flagSource;
        this.tenantFileSystemDirs = new TenantFileSystemDirs(configServerDB, tenantName);
        this.applicationRepo = applicationRepo;
        this.sessionPreparer = sessionPreparer;
        this.metrics = metrics;
        this.metricUpdater = metrics.getOrCreateMetricUpdater(Metrics.createDimensions(tenantName));
        this.secretStore = secretStore;
        this.hostProvisionerProvider = hostProvisionerProvider;
        this.configserverConfig = configserverConfig;
        this.configServerDB = configServerDB;
        this.zone = zone;
        this.modelFactoryRegistry = modelFactoryRegistry;
        this.configDefinitionRepo = configDefinitionRepo;
        this.maxNodeSize = maxNodeSize;
        this.expiryTimeFlag = (LongFlag)PermanentFlags.CONFIG_SERVER_SESSION_EXPIRY_TIME.bindTo(flagSource);
        this.writeSessionData = (BooleanFlag)Flags.WRITE_CONFIG_SERVER_SESSION_DATA_AS_ONE_BLOB.bindTo(flagSource);
        this.readSessionData = (BooleanFlag)Flags.READ_CONFIG_SERVER_SESSION_DATA_AS_ONE_BLOB.bindTo(flagSource);
        this.loadSessions();
        this.directoryCache = curator.createDirectoryCache(this.sessionsPath.getAbsolute(), false, false, zkCacheExecutor);
        this.directoryCache.addListener(this::childEvent);
        this.directoryCache.start();
    }

    private void loadSessions() {
        ExecutorService executor = Executors.newFixedThreadPool(Math.max(8, Runtime.getRuntime().availableProcessors()), (ThreadFactory)new DaemonThreadFactory("load-sessions-"));
        this.loadSessions(executor);
    }

    void loadSessions(ExecutorService executor) {
        this.loadRemoteSessions(executor);
        try {
            executor.shutdown();
            if (!executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                log.log(Level.INFO, "Executor did not terminate");
            }
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Shutdown of executor for loading sessions failed: " + Exceptions.toMessageString((Throwable)e));
        }
    }

    public void addLocalSession(LocalSession session) {
        long sessionId = session.getSessionId();
        this.localSessionCache.put(sessionId, session);
        if (this.remoteSessionCache.get(sessionId) == null) {
            this.createRemoteSession(sessionId);
        }
    }

    public LocalSession getLocalSession(long sessionId) {
        return this.localSessionCache.get(sessionId);
    }

    public Collection<LocalSession> getLocalSessions() {
        return List.copyOf(this.localSessionCache.values());
    }

    private LocalSession getSessionFromFile(long sessionId) {
        SessionZooKeeperClient sessionZKClient = this.createSessionZooKeeperClient(sessionId);
        File sessionDir = this.getAndValidateExistingSessionAppDir(sessionId);
        FilesApplicationPackage applicationPackage = FilesApplicationPackage.fromFile((File)sessionDir);
        return new LocalSession(this.tenantName, sessionId, (ApplicationPackage)applicationPackage, sessionZKClient);
    }

    public Set<Long> getLocalSessionsIdsFromFileSystem() {
        File[] sessions = this.tenantFileSystemDirs.sessionsPath().listFiles(sessionApplicationsFilter);
        if (sessions == null) {
            return Set.of();
        }
        HashSet<Long> sessionIds = new HashSet<Long>();
        for (File session : sessions) {
            long sessionId = Long.parseLong(session.getName());
            sessionIds.add(sessionId);
        }
        return sessionIds;
    }

    public ConfigChangeActions prepareLocalSession(Session session, DeployLogger logger, PrepareParams params, Instant now) {
        params.vespaVersion().ifPresent(version -> {
            if (!params.isBootstrap() && !this.modelFactoryRegistry.allVersions().contains(version)) {
                throw new UnknownVespaVersionException("Vespa version '" + version + "' not known by this config server");
            }
        });
        ApplicationId applicationId = params.getApplicationId();
        this.applicationRepo.createApplication(applicationId);
        logger.log(Level.FINE, "Created application " + applicationId);
        long sessionId = session.getSessionId();
        SessionZooKeeperClient sessionZooKeeperClient = this.createSessionZooKeeperClient(sessionId);
        Optional<Curator.CompletionWaiter> waiter = params.isDryRun() ? Optional.empty() : Optional.of(sessionZooKeeperClient.createPrepareWaiter());
        Optional<ApplicationVersions> activeApplicationVersions = this.activeApplicationVersions(applicationId);
        try (CuratorTransaction transaction = new CuratorTransaction(this.curator);){
            this.applicationRepo.createWritePrepareTransaction((Transaction)transaction, applicationId, sessionId, this.getActiveSessionId(applicationId)).commit();
        }
        ConfigChangeActions actions = this.sessionPreparer.prepare(this.applicationRepo, logger, params, activeApplicationVersions, now, this.getSessionAppDir(sessionId), session.getApplicationPackage(), sessionZooKeeperClient).getConfigChangeActions();
        this.setPrepared(session);
        waiter.ifPresent(w -> w.awaitCompletion(params.getTimeoutBudget().timeLeft()));
        return actions;
    }

    public LocalSession createSessionFromExisting(Session existingSession, boolean internalRedeploy, TimeoutBudget timeoutBudget, DeployLogger deployLogger) {
        ApplicationId applicationId = existingSession.getApplicationId();
        File existingApp = this.getSessionAppDir(existingSession.getSessionId());
        Instant created = this.clock.instant();
        LocalSession session = this.createSessionFromApplication(existingApp, applicationId, internalRedeploy, timeoutBudget, deployLogger, created);
        this.applicationRepo.createApplication(applicationId);
        this.write(existingSession, session, applicationId, created);
        return session;
    }

    public LocalSession createSessionFromApplicationPackage(File applicationDirectory, ApplicationId applicationId, TimeoutBudget timeoutBudget, DeployLogger deployLogger) {
        LocalSession session = this.createSessionFromApplication(applicationDirectory, applicationId, false, timeoutBudget, deployLogger, this.clock.instant());
        this.applicationRepo.createApplication(applicationId);
        return session;
    }

    private void createLocalSession(File applicationFile, ApplicationId applicationId, long sessionId) {
        try {
            ApplicationPackage applicationPackage = this.createApplicationPackage(applicationFile, applicationId, sessionId, false, Optional.empty());
            this.createLocalSession(sessionId, applicationPackage);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating session " + sessionId, e);
        }
    }

    public void deleteLocalSession(long sessionId) {
        log.log(Level.FINE, () -> "Deleting local session " + sessionId);
        SessionStateWatcher watcher = this.sessionStateWatchers.remove(sessionId);
        if (watcher != null) {
            watcher.close();
        }
        this.localSessionCache.remove(sessionId);
        NestedTransaction transaction = new NestedTransaction();
        transaction.add((Transaction)FileTransaction.from(FileOperations.delete(this.getSessionAppDir(sessionId).getAbsolutePath())), new Class[0]);
        transaction.commit();
    }

    private void deleteAllSessions() {
        for (LocalSession session : this.getLocalSessions()) {
            this.deleteLocalSession(session.getSessionId());
        }
    }

    public RemoteSession getRemoteSession(long sessionId) {
        return this.remoteSessionCache.get(sessionId);
    }

    public Collection<RemoteSession> getRemoteSessions() {
        return List.copyOf(this.remoteSessionCache.values());
    }

    public List<Long> getRemoteSessionsFromZooKeeper() {
        return this.getSessionList(this.curator.getChildren(this.sessionsPath));
    }

    public RemoteSession createRemoteSession(long sessionId) {
        SessionZooKeeperClient sessionZKClient = this.createSessionZooKeeperClient(sessionId);
        RemoteSession session = new RemoteSession(this.tenantName, sessionId, sessionZKClient);
        this.loadSessionIfActive(session);
        this.remoteSessionCache.put(sessionId, session);
        this.updateSessionStateWatcher(sessionId);
        return session;
    }

    public int deleteExpiredRemoteSessions(Predicate<Session> sessionIsActiveForApplication) {
        List<Long> remoteSessionsFromZooKeeper = this.getRemoteSessionsFromZooKeeper();
        log.log(Level.FINE, () -> "Remote sessions for tenant " + this.tenantName + ": " + remoteSessionsFromZooKeeper);
        int deleted = 0;
        int deleteMax = (int)Math.min(1000.0, Math.max(50.0, (double)remoteSessionsFromZooKeeper.size() * 0.05));
        for (Long sessionId : remoteSessionsFromZooKeeper) {
            Session session = this.remoteSessionCache.get(sessionId);
            if (session == null) {
                session = new RemoteSession(this.tenantName, sessionId, this.createSessionZooKeeperClient(sessionId));
            }
            if (session.getStatus() == Session.Status.ACTIVATE && sessionIsActiveForApplication.test(session)) continue;
            if (this.sessionHasExpired(session.getCreateTime())) {
                log.log(Level.FINE, () -> "Remote session " + sessionId + " for " + this.tenantName + " has expired, deleting it");
                this.deleteRemoteSessionFromZooKeeper(session);
                ++deleted;
            }
            if (deleted < deleteMax) continue;
            break;
        }
        return deleted;
    }

    public void deactivateSession(long sessionId) {
        RemoteSession s = this.remoteSessionCache.get(sessionId);
        if (s == null) {
            return;
        }
        this.remoteSessionCache.put(sessionId, s.deactivated());
    }

    public void deleteRemoteSessionFromZooKeeper(Session session) {
        SessionZooKeeperClient sessionZooKeeperClient = this.createSessionZooKeeperClient(session.getSessionId());
        CuratorTransaction transaction = sessionZooKeeperClient.deleteTransaction();
        transaction.commit();
        transaction.close();
    }

    private boolean sessionHasExpired(Instant created) {
        Duration expiryTime = Duration.ofSeconds(this.expiryTimeFlag.value());
        return created.plus(expiryTime).isBefore(this.clock.instant());
    }

    private List<Long> getSessionListFromDirectoryCache(List<ChildData> children) {
        return this.getSessionList(children.stream().map(child -> Path.fromString((String)child.getPath()).getName()).toList());
    }

    private List<Long> getSessionList(List<String> children) {
        return children.stream().map(Long::parseLong).toList();
    }

    private void loadRemoteSessions(ExecutorService executor) throws NumberFormatException {
        HashMap<Long, Future> futures = new HashMap<Long, Future>();
        for (long sessionId2 : this.getRemoteSessionsFromZooKeeper()) {
            futures.put(sessionId2, executor.submit(() -> this.sessionAdded(sessionId2)));
        }
        futures.forEach((sessionId, future) -> {
            try {
                future.get();
                log.log(Level.FINE, () -> "Remote session " + sessionId + " loaded");
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Could not load remote session " + sessionId, e);
            }
        });
    }

    public void sessionAdded(long sessionId) {
        if (this.hasStatusDeleted(sessionId)) {
            return;
        }
        log.log(Level.FINE, () -> "Adding remote session " + sessionId);
        RemoteSession session = this.createRemoteSession(sessionId);
        if (session.getStatus() == Session.Status.NEW) {
            log.log(Level.FINE, () -> session.logPre() + "Confirming upload for session " + sessionId);
            this.confirmUpload(session);
        }
        this.createLocalSessionFromDistributedApplicationPackage(sessionId);
    }

    private boolean hasStatusDeleted(long sessionId) {
        SessionZooKeeperClient sessionZKClient = this.createSessionZooKeeperClient(sessionId);
        RemoteSession session = new RemoteSession(this.tenantName, sessionId, sessionZKClient);
        return session.getStatus() == Session.Status.DELETE;
    }

    void activate(long sessionId) {
        this.createLocalSessionFromDistributedApplicationPackage(sessionId);
        RemoteSession session = this.remoteSessionCache.get(sessionId);
        if (session == null) {
            return;
        }
        Curator.CompletionWaiter waiter = this.createSessionZooKeeperClient(sessionId).getActiveWaiter();
        log.log(Level.FINE, () -> session.logPre() + "Activating " + sessionId);
        this.applicationRepo.activateApplication(this.ensureApplicationLoaded(session), sessionId);
        log.log(Level.FINE, () -> session.logPre() + "Notifying " + waiter);
        this.notifyCompletion(waiter);
        log.log(Level.INFO, session.logPre() + "Session activated: " + sessionId);
    }

    private void loadSessionIfActive(RemoteSession session) {
        for (ApplicationId applicationId : this.applicationRepo.activeApplications()) {
            Optional<Long> activeSession = this.applicationRepo.activeSessionOf(applicationId);
            if (!activeSession.isPresent() || activeSession.get().longValue() != session.getSessionId()) continue;
            log.log(Level.FINE, () -> "Found active application for session " + session.getSessionId() + " , loading it");
            this.applicationRepo.activateApplication(this.ensureApplicationLoaded(session), session.getSessionId());
            log.log(Level.INFO, session.logPre() + "Application activated successfully: " + applicationId + " (generation " + session.getSessionId() + ")");
            return;
        }
    }

    void prepareRemoteSession(long sessionId) {
        this.createLocalSessionFromDistributedApplicationPackage(sessionId);
        RemoteSession session = this.remoteSessionCache.get(sessionId);
        if (session == null) {
            return;
        }
        SessionZooKeeperClient sessionZooKeeperClient = this.createSessionZooKeeperClient(sessionId);
        Curator.CompletionWaiter waiter = sessionZooKeeperClient.getPrepareWaiter();
        this.ensureApplicationLoaded(session);
        this.notifyCompletion(waiter);
    }

    public ApplicationVersions ensureApplicationLoaded(RemoteSession session) {
        if (session.applicationVersions().isPresent()) {
            return session.applicationVersions().get();
        }
        Optional<Long> activeSessionId = this.getActiveSessionId(session.getApplicationId());
        Optional<ApplicationVersions> previousActiveApplicationVersions = activeSessionId.filter(session::isNewerThan).flatMap(this::activeApplicationVersions);
        ApplicationVersions applicationVersions = this.loadApplication(session, previousActiveApplicationVersions);
        RemoteSession activated = session.activated(applicationVersions);
        long sessionId = activated.getSessionId();
        this.remoteSessionCache.put(sessionId, activated);
        this.updateSessionStateWatcher(sessionId);
        return applicationVersions;
    }

    void confirmUpload(Session session) {
        Curator.CompletionWaiter waiter = this.createSessionZooKeeperClient(session.getSessionId()).getUploadWaiter();
        long sessionId = session.getSessionId();
        log.log(Level.FINE, () -> "Notifying upload waiter for session " + sessionId);
        this.notifyCompletion(waiter);
        log.log(Level.FINE, () -> "Done notifying upload for session " + sessionId);
    }

    void notifyCompletion(Curator.CompletionWaiter completionWaiter) {
        try {
            completionWaiter.notifyCompletion();
        }
        catch (RuntimeException e) {
            Set<Class<KeeperException.NodeExistsException>> acceptedExceptions = Set.of(KeeperException.NoNodeException.class, KeeperException.NodeExistsException.class);
            Class<?> exceptionClass = e.getCause().getClass();
            if (acceptedExceptions.contains(exceptionClass)) {
                log.log(Level.FINE, () -> "Not able to notify completion for session (" + completionWaiter + "), node " + (exceptionClass.equals(KeeperException.NoNodeException.class) ? "has been deleted" : "already exists"));
            }
            throw e;
        }
    }

    private ApplicationVersions loadApplication(Session session, Optional<ApplicationVersions> previousApplicationVersions) {
        log.log(Level.FINE, () -> "Loading application for " + session);
        SessionZooKeeperClient sessionZooKeeperClient = this.createSessionZooKeeperClient(session.getSessionId());
        ActivatedModelsBuilder builder = new ActivatedModelsBuilder(session.getTenantName(), session.getSessionId(), sessionZooKeeperClient, previousApplicationVersions, this.sessionPreparer.getExecutor(), this.curator, this.metrics, this.flagSource, this.secretStore, this.hostProvisionerProvider, this.configserverConfig, this.zone, this.modelFactoryRegistry, this.configDefinitionRepo, this.onnxModelCost, this.endpointCertificateSecretStores);
        return ApplicationVersions.fromList(builder.buildModels(session.getApplicationId(), session.getDockerImageRepository(), session.getVespaVersion(), sessionZooKeeperClient.loadApplicationPackage(), new AllocatedHostsFromAllModels(), this.clock.instant()));
    }

    private void nodeChanged() {
        this.zkWatcherExecutor.execute(() -> {
            HashMultiset sessionMetrics = HashMultiset.create();
            this.getRemoteSessions().forEach(arg_0 -> SessionRepository.lambda$nodeChanged$20((Multiset)sessionMetrics, arg_0));
            this.metricUpdater.setNewSessions(sessionMetrics.count((Object)Session.Status.NEW));
            this.metricUpdater.setPreparedSessions(sessionMetrics.count((Object)Session.Status.PREPARE));
            this.metricUpdater.setActivatedSessions(sessionMetrics.count((Object)Session.Status.ACTIVATE));
            this.metricUpdater.setDeactivatedSessions(sessionMetrics.count((Object)Session.Status.DEACTIVATE));
        });
    }

    private void childEvent(CuratorFramework ignored, PathChildrenCacheEvent event) {
        this.zkWatcherExecutor.execute(() -> {
            log.log(Level.FINE, () -> "Got child event: " + event);
            switch (event.getType()) {
                case CHILD_ADDED: 
                case CHILD_REMOVED: 
                case CONNECTION_RECONNECTED: {
                    this.sessionsChanged();
                }
            }
        });
    }

    private void write(Session existingSession, LocalSession session, ApplicationId applicationId, Instant created) {
        List<TenantSecretStore> tenantSecretStores = existingSession.getTenantSecretStores();
        if (!tenantSecretStores.isEmpty() && this.zone.system().isPublic() && this.zone.cloud().name().equals((Object)CloudName.AWS)) {
            tenantSecretStores.forEach(ss -> log.info("Existing tenant secret store:\n" + ss));
        }
        SessionSerializer sessionSerializer = new SessionSerializer();
        sessionSerializer.write(session.getSessionZooKeeperClient(), applicationId, created, existingSession.getApplicationPackageReference(), existingSession.getDockerImageRepository(), existingSession.getVespaVersion(), existingSession.getAthenzDomain(), existingSession.getQuota(), tenantSecretStores, existingSession.getOperatorCertificates(), existingSession.getCloudAccount(), existingSession.getDataplaneTokens(), ActivationTriggers.empty(), this.writeSessionData);
    }

    public SessionData read(Session session) {
        return new SessionSerializer().read(session.getSessionZooKeeperClient(), this.readSessionData);
    }

    public void deleteExpiredSessions(Predicate<Session> sessionIsActiveForApplication) {
        log.log(Level.FINE, () -> "Deleting expired local sessions for tenant '" + this.tenantName + "'");
        HashSet<Long> sessionIdsToDelete = new HashSet<Long>();
        Set<Long> newSessions = this.findNewSessionsInFileSystem();
        try {
            for (long sessionId : this.getLocalSessionsIdsFromFileSystem()) {
                LocalSession session;
                if (newSessions.contains(sessionId)) continue;
                log.log(Level.FINE, () -> "Candidate local session for deletion: " + sessionId + ", created (on disk): " + this.created(this.getSessionAppDir(sessionId)));
                SessionZooKeeperClient sessionZooKeeperClient = this.createSessionZooKeeperClient(sessionId);
                Instant createTime = sessionZooKeeperClient.readCreateTime();
                Session.Status status = sessionZooKeeperClient.readStatus();
                boolean expired = this.sessionLifeTimeElapsed(createTime);
                log.log(Level.FINE, () -> "Candidate local session for deletion: " + sessionId + ", created (in zk): " + createTime + ", status " + status + ", can be deleted: " + this.canBeDeleted(sessionId, status) + ", hasExpired: " + expired);
                if (expired && this.canBeDeleted(sessionId, status)) {
                    log.log(Level.FINE, () -> " expired, can be deleted: " + sessionId);
                    sessionIdsToDelete.add(sessionId);
                    continue;
                }
                if (!createTime.plus(Duration.ofDays(1L)).isBefore(this.clock.instant())) continue;
                log.log(Level.FINE, () -> "not expired, but more than 1 day old: " + sessionId);
                try {
                    session = this.getSessionFromFile(sessionId);
                }
                catch (Exception e) {
                    log.log(Level.FINE, () -> "could not get session from file: " + sessionId + ": " + e.getMessage());
                    continue;
                }
                Optional<ApplicationId> applicationId = session.getOptionalApplicationId();
                if (applicationId.isEmpty() || sessionIsActiveForApplication.test(session)) continue;
                sessionIdsToDelete.add(sessionId);
                log.log(Level.FINE, () -> "Will delete inactive session " + sessionId + " created " + createTime + " for '" + applicationId + "'");
            }
            sessionIdsToDelete.forEach(this::deleteLocalSession);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Error when purging old sessions ", e);
        }
        log.log(Level.FINE, () -> "Done purging old sessions");
    }

    private boolean sessionLifeTimeElapsed(Instant created) {
        Duration sessionLifetime = Duration.ofSeconds(this.configserverConfig.sessionLifetime());
        return created.plus(sessionLifetime).isBefore(this.clock.instant());
    }

    public void deleteExpiredRemoteAndLocalSessions(Clock clock, Predicate<Session> sessionIsActiveForApplication) {
        Set<Long> sessions = this.getLocalSessionsIdsFromFileSystem();
        sessions.addAll(this.getRemoteSessionsFromZooKeeper());
        log.log(Level.FINE, () -> "Sessions for tenant " + this.tenantName + ": " + sessions);
        Set<Long> newSessions = this.findNewSessionsInFileSystem();
        sessions.removeAll(newSessions);
        int deleteMax = (int)Math.min(1000.0, Math.max(50.0, (double)sessions.size() * 0.05));
        int deleted = 0;
        for (Long sessionId : sessions) {
            try {
                Session session = this.remoteSessionCache.get(sessionId);
                if (session == null) {
                    session = new RemoteSession(this.tenantName, sessionId, this.createSessionZooKeeperClient(sessionId));
                }
                Optional<ApplicationId> applicationId = session.getOptionalApplicationId();
                ApplicationLock ignored = this.lockApplication(applicationId);
                try {
                    Instant createTime;
                    boolean hasExpired;
                    Session.Status status = session.getStatus();
                    boolean activeForApplication = sessionIsActiveForApplication.test(session);
                    if (status == Session.Status.ACTIVATE && activeForApplication || !(hasExpired = this.hasExpired(createTime = session.getCreateTime()))) continue;
                    log.log(Level.FINE, () -> "Remote session " + sessionId + " for " + this.tenantName + " has expired, deleting it");
                    this.deleteRemoteSessionFromZooKeeper(session);
                    ++deleted;
                    log.log(Level.FINE, () -> "Expired local session is candidate for deletion: " + sessionId + ", created: " + createTime + ", status " + status + ", can be deleted: " + this.canBeDeleted(sessionId, status));
                    if (this.canBeDeleted(sessionId, status)) {
                        this.deleteLocalSession(sessionId);
                        ++deleted;
                    }
                    if (this.isOldAndCanBeDeleted(sessionId, createTime)) {
                        Optional<LocalSession> localSession = this.getOptionalSessionFromFileSystem(sessionId);
                        if (localSession.isEmpty()) continue;
                        if (!activeForApplication) {
                            log.log(Level.FINE, "Will delete expired session " + sessionId + " created " + createTime + " for '" + applicationId.map(ApplicationId::toString).orElse("unknown") + "'");
                            this.deleteLocalSession(sessionId);
                            ++deleted;
                        }
                    }
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Error when deleting expired sessions ", e);
            }
        }
        log.log(Level.FINE, () -> "Done deleting expired sessions");
    }

    private ApplicationLock lockApplication(Optional<ApplicationId> applicationId) {
        return applicationId.map(id -> new ApplicationLock(Optional.of(this.applicationRepo.lock((ApplicationId)id)))).orElseGet(() -> new ApplicationLock(Optional.empty()));
    }

    private Optional<LocalSession> getOptionalSessionFromFileSystem(long sessionId) {
        try {
            return Optional.of(this.getSessionFromFile(sessionId));
        }
        catch (Exception e) {
            log.log(Level.FINE, () -> "could not get session from file: " + sessionId + ": " + e.getMessage());
            return Optional.empty();
        }
    }

    private boolean isOldAndCanBeDeleted(long sessionId, Instant createTime) {
        Duration expiry;
        Duration oneDay = Duration.ofDays(1L);
        Duration duration = expiry = Duration.ofSeconds(this.expiryTimeFlag.value()).compareTo(oneDay) >= 0 ? Duration.ofSeconds(this.expiryTimeFlag.value()) : oneDay;
        if (createTime.plus(expiry).isBefore(this.clock.instant())) {
            log.log(Level.FINE, () -> "more than 1 day old: " + sessionId);
            return true;
        }
        return false;
    }

    private boolean hasExpired(Instant created) {
        Duration expiryTime = Duration.ofSeconds(this.expiryTimeFlag.value());
        return created.plus(expiryTime).isBefore(this.clock.instant());
    }

    private boolean canBeDeleted(long sessionId, Session.Status status) {
        return !List.of(Session.Status.UNKNOWN, Session.Status.ACTIVATE).contains((Object)status) || this.oldSessionDirWithUnknownStatus(sessionId, status);
    }

    private boolean oldSessionDirWithUnknownStatus(long sessionId, Session.Status status) {
        Duration expiryTime = Duration.ofHours(this.configserverConfig.keepSessionsWithUnknownStatusHours());
        File sessionDir = this.tenantFileSystemDirs.getUserApplicationDir(sessionId);
        return sessionDir.exists() && status == Session.Status.UNKNOWN && this.created(sessionDir).plus(expiryTime).isBefore(this.clock.instant());
    }

    private Set<Long> findNewSessionsInFileSystem() {
        File[] sessions = this.tenantFileSystemDirs.sessionsPath().listFiles(sessionApplicationsFilter);
        HashSet<Long> newSessions = new HashSet<Long>();
        if (sessions != null) {
            for (File session : sessions) {
                try {
                    if (!Files.getLastModifiedTime(session.toPath(), new LinkOption[0]).toInstant().isAfter(this.clock.instant().minus(Duration.ofSeconds(30L)))) continue;
                    newSessions.add(Long.parseLong(session.getName()));
                }
                catch (IOException e) {
                    log.log(Level.FINE, "Unable to find last modified time for " + session.toPath());
                }
            }
        }
        return newSessions;
    }

    private Instant created(File file) {
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return fileAttributes.creationTime().toInstant();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void ensureSessionPathDoesNotExist(long sessionId) {
        Path sessionPath = this.getSessionPath(sessionId);
        if (this.curator.exists(sessionPath)) {
            throw new IllegalArgumentException("Path " + sessionPath.getAbsolute() + " already exists in ZooKeeper");
        }
    }

    private ApplicationPackage createApplication(File configApplicationDir, ApplicationId applicationId, long sessionId, Optional<Long> currentlyActiveSessionId, boolean internalRedeploy, Optional<DeployLogger> deployLogger) {
        long deployTimestamp = System.currentTimeMillis();
        DeployData deployData = new DeployData(applicationId, Long.valueOf(deployTimestamp), internalRedeploy, Long.valueOf(sessionId), currentlyActiveSessionId.orElse(0L).longValue());
        FilesApplicationPackage app = FilesApplicationPackage.fromFileWithDeployData((File)configApplicationDir, (DeployData)deployData);
        this.validateFileExtensions(applicationId, deployLogger, app);
        return app;
    }

    private void validateFileExtensions(ApplicationId applicationId, Optional<DeployLogger> deployLogger, FilesApplicationPackage app) {
        try {
            app.validateFileExtensions();
        }
        catch (IllegalArgumentException e) {
            if (this.configserverConfig.hostedVespa()) {
                String value;
                UnboundStringFlag flag = PermanentFlags.APPLICATION_FILES_WITH_UNKNOWN_EXTENSION;
                switch (value = ((StringFlag)((StringFlag)flag.bindTo(this.flagSource)).with(Dimension.INSTANCE_ID, applicationId.serializedForm())).value()) {
                    case "FAIL": {
                        throw new InvalidApplicationException(e);
                    }
                    case "LOG": {
                        deployLogger.ifPresent(logger -> logger.logApplicationPackage(Level.WARNING, e.getMessage()));
                        break;
                    }
                    default: {
                        log.log(Level.WARNING, "Unknown value for flag " + flag.id() + ": " + value);
                        break;
                    }
                }
            }
            deployLogger.ifPresent(logger -> logger.logApplicationPackage(Level.WARNING, e.getMessage()));
        }
    }

    private LocalSession createSessionFromApplication(File applicationDirectory, ApplicationId applicationId, boolean internalRedeploy, TimeoutBudget timeoutBudget, DeployLogger deployLogger, Instant created) {
        long sessionId = this.getNextSessionId();
        try {
            this.ensureSessionPathDoesNotExist(sessionId);
            ApplicationPackage app = this.createApplicationPackage(applicationDirectory, applicationId, sessionId, internalRedeploy, Optional.of(deployLogger));
            log.log(Level.FINE, () -> TenantRepository.logPre(this.tenantName) + "Creating session " + sessionId + " in ZooKeeper");
            SessionZooKeeperClient sessionZKClient = this.createSessionZooKeeperClient(sessionId);
            sessionZKClient.createNewSession(created);
            Curator.CompletionWaiter waiter = sessionZKClient.getUploadWaiter();
            LocalSession session = new LocalSession(this.tenantName, sessionId, app, sessionZKClient);
            waiter.awaitCompletion(Duration.ofSeconds(Math.min(120L, timeoutBudget.timeLeft().getSeconds())));
            this.addLocalSession(session);
            return session;
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating session " + sessionId, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationPackage createApplicationPackage(File applicationDirectory, ApplicationId applicationId, long sessionId, boolean internalRedeploy, Optional<DeployLogger> deployLogger) throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            Optional<Long> activeSessionId = this.getActiveSessionId(applicationId);
            File userApplicationDir = this.getSessionAppDir(sessionId);
            this.copyApp(applicationDirectory, userApplicationDir);
            ApplicationPackage applicationPackage = this.createApplication(userApplicationDir, applicationId, sessionId, activeSessionId, internalRedeploy, deployLogger);
            applicationPackage.writeMetaData();
            return applicationPackage;
        }
    }

    public Optional<ApplicationVersions> activeApplicationVersions(ApplicationId appId) {
        return this.applicationRepo.activeSessionOf(appId).flatMap(this::activeApplicationVersions);
    }

    private Optional<ApplicationVersions> activeApplicationVersions(long sessionId) {
        try {
            return Optional.ofNullable(this.getRemoteSession(sessionId)).map(this::ensureApplicationLoaded);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyApp(File sourceDir, File destinationDir) throws IOException {
        if (destinationDir.exists()) {
            log.log(Level.INFO, "Destination dir " + destinationDir + " already exists, app has already been copied");
            return;
        }
        if (!sourceDir.isDirectory()) {
            throw new IllegalArgumentException(sourceDir.getAbsolutePath() + " is not a directory");
        }
        java.nio.file.Path tempDestinationDir = null;
        try {
            tempDestinationDir = Files.createTempDirectory(destinationDir.getParentFile().toPath(), "app-package", new FileAttribute[0]);
            log.log(Level.FINE, "Copying dir " + sourceDir.getAbsolutePath() + " to " + tempDestinationDir.toFile().getAbsolutePath());
            IOUtils.copyDirectory((File)sourceDir, (File)tempDestinationDir.toFile());
            this.moveSearchDefinitionsToSchemasDir(tempDestinationDir);
            log.log(Level.FINE, "Moving " + tempDestinationDir + " to " + destinationDir.getAbsolutePath());
            Files.move(tempDestinationDir, destinationDir.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        finally {
            if (tempDestinationDir != null) {
                IOUtils.recursiveDeleteDir((File)tempDestinationDir.toFile());
            }
        }
    }

    private void moveSearchDefinitionsToSchemasDir(java.nio.file.Path applicationDir) throws IOException {
        File schemasDir = applicationDir.resolve(ApplicationPackage.SCHEMAS_DIR.getRelative()).toFile();
        File sdDir = applicationDir.resolve(ApplicationPackage.SEARCH_DEFINITIONS_DIR.getRelative()).toFile();
        if (sdDir.exists() && sdDir.isDirectory()) {
            try {
                File[] sdFiles = sdDir.listFiles();
                if (sdFiles != null) {
                    Files.createDirectories(schemasDir.toPath(), new FileAttribute[0]);
                    List.of(sdFiles).forEach(file -> Exceptions.uncheck(() -> Files.move(file.toPath(), schemasDir.toPath().resolve(file.toPath().getFileName()), StandardCopyOption.REPLACE_EXISTING)));
                }
                Files.delete(sdDir.toPath());
            }
            catch (IOException | UncheckedIOException e) {
                if (schemasDir.exists() && schemasDir.isDirectory()) {
                    throw new InvalidApplicationException("Both " + ApplicationPackage.SCHEMAS_DIR.getRelative() + "/ and " + ApplicationPackage.SEARCH_DEFINITIONS_DIR + "/ exist in application package, please remove " + ApplicationPackage.SEARCH_DEFINITIONS_DIR + "/", e);
                }
                throw e;
            }
        }
    }

    void createSessionFromId(long sessionId) {
        File sessionDir = this.getAndValidateExistingSessionAppDir(sessionId);
        FilesApplicationPackage applicationPackage = FilesApplicationPackage.fromFile((File)sessionDir);
        this.createLocalSession(sessionId, (ApplicationPackage)applicationPackage);
    }

    void createLocalSession(long sessionId, ApplicationPackage applicationPackage) {
        SessionZooKeeperClient sessionZKClient = this.createSessionZooKeeperClient(sessionId);
        LocalSession session = new LocalSession(this.tenantName, sessionId, applicationPackage, sessionZKClient);
        this.addLocalSession(session);
    }

    public void createLocalSessionFromDistributedApplicationPackage(long sessionId) {
        if (this.applicationRepo.sessionExistsInFileSystem(sessionId)) {
            log.log(Level.FINE, () -> "Local session for session id " + sessionId + " already exists");
            this.createSessionFromId(sessionId);
            return;
        }
        SessionZooKeeperClient sessionZKClient = this.createSessionZooKeeperClient(sessionId);
        Optional<FileReference> fileReference = sessionZKClient.readApplicationPackageReference();
        log.log(Level.FINE, () -> "File reference for session id " + sessionId + ": " + fileReference);
        if (fileReference.isEmpty()) {
            return;
        }
        Optional<File> sessionDir = this.fileDistributionFactory.fileDirectory().getFile(fileReference.get());
        if (sessionDir.isEmpty()) {
            return;
        }
        ApplicationId applicationId = sessionZKClient.readApplicationId();
        log.log(Level.FINE, () -> "Creating local session for tenant '" + this.tenantName + "' with session id " + sessionId);
        this.createLocalSession(sessionDir.get(), applicationId, sessionId);
    }

    private Optional<Long> getActiveSessionId(ApplicationId applicationId) {
        return this.applicationRepo.activeSessionOf(applicationId);
    }

    private long getNextSessionId() {
        return this.sessionCounter.nextSessionId();
    }

    public Path getSessionPath(long sessionId) {
        return this.sessionsPath.append(String.valueOf(sessionId));
    }

    Path getSessionStatePath(long sessionId) {
        return this.getSessionPath(sessionId).append("/sessionState");
    }

    public SessionZooKeeperClient createSessionZooKeeperClient(long sessionId) {
        return new SessionZooKeeperClient(this.curator, this.tenantName, sessionId, this.configserverConfig, this.fileDistributionFactory.createFileManager(this.getSessionAppDir(sessionId)), this.maxNodeSize);
    }

    private File getAndValidateExistingSessionAppDir(long sessionId) {
        File appDir = this.getSessionAppDir(sessionId);
        if (!appDir.exists() || !appDir.isDirectory()) {
            throw new IllegalArgumentException("Unable to find correct application directory for session " + sessionId);
        }
        return appDir;
    }

    private File getSessionAppDir(long sessionId) {
        return new TenantFileSystemDirs(this.configServerDB, this.tenantName).getUserApplicationDir(sessionId);
    }

    private void updateSessionStateWatcher(long sessionId) {
        this.sessionStateWatchers.computeIfAbsent(sessionId, id -> {
            Curator.FileCache fileCache = this.curator.createFileCache(this.getSessionStatePath((long)id).getAbsolute(), false);
            fileCache.addListener(this::nodeChanged);
            return new SessionStateWatcher(fileCache, (long)id, this.metricUpdater, this.zkWatcherExecutor, this);
        });
    }

    public String toString() {
        return this.getLocalSessions().toString();
    }

    public Clock clock() {
        return this.clock;
    }

    public void close() {
        this.deleteAllSessions();
        this.tenantFileSystemDirs.delete();
        try {
            if (this.directoryCache != null) {
                this.directoryCache.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception when closing path cache", e);
        }
        finally {
            this.checkForRemovedSessions(new ArrayList<Long>());
        }
    }

    private void sessionsChanged() throws NumberFormatException {
        List<Long> sessions = this.getSessionListFromDirectoryCache(this.directoryCache.getCurrentData());
        this.checkForRemovedSessions(sessions);
        this.checkForAddedSessions(sessions);
    }

    private void checkForRemovedSessions(List<Long> existingSessions) {
        Iterator<RemoteSession> it = this.remoteSessionCache.values().iterator();
        while (it.hasNext()) {
            long sessionId = it.next().sessionId;
            if (existingSessions.contains(sessionId)) continue;
            SessionStateWatcher watcher = this.sessionStateWatchers.remove(sessionId);
            if (watcher != null) {
                watcher.close();
            }
            it.remove();
            this.metricUpdater.incRemovedSessions();
        }
    }

    private void checkForAddedSessions(List<Long> sessions) {
        for (Long sessionId : sessions) {
            if (this.remoteSessionCache.get(sessionId) != null) continue;
            this.sessionAdded(sessionId);
        }
    }

    public Transaction createActivateTransaction(Session session) {
        Transaction transaction = this.createSetStatusTransaction(session, Session.Status.ACTIVATE);
        transaction.add(this.applicationRepo.createWriteActiveTransaction(transaction, session.getApplicationId(), session.getSessionId()).operations());
        return transaction;
    }

    public Transaction createSetStatusTransaction(Session session, Session.Status status) {
        return session.sessionZooKeeperClient.createWriteStatusTransaction(status);
    }

    void setPrepared(Session session) {
        session.setStatus(Session.Status.PREPARE);
    }

    private static /* synthetic */ void lambda$nodeChanged$20(Multiset sessionMetrics, RemoteSession session) {
        sessionMetrics.add((Object)session.getStatus());
    }

    private static class FileOperations {
        private FileOperations() {
        }

        public static DeleteOperation delete(String pathToDelete) {
            return new DeleteOperation(pathToDelete);
        }
    }

    private static class DeleteOperation
    implements FileOperation {
        private final String pathToDelete;

        DeleteOperation(String pathToDelete) {
            this.pathToDelete = pathToDelete;
        }

        @Override
        public void commit() {
            IOUtils.recursiveDeleteDir((File)new File(this.pathToDelete));
        }
    }

    private static class FileTransaction
    extends AbstractTransaction {
        private FileTransaction() {
        }

        public static FileTransaction from(FileOperation operation) {
            FileTransaction transaction = new FileTransaction();
            transaction.add(operation);
            return transaction;
        }

        public void prepare() {
        }

        public void commit() {
            for (Transaction.Operation operation : this.operations()) {
                ((FileOperation)operation).commit();
            }
        }
    }

    private static interface FileOperation
    extends Transaction.Operation {
        public void commit();
    }

    private record ApplicationLock(Optional<Lock> lock) implements Closeable
    {
        @Override
        public void close() {
            this.lock.ifPresent(Lock::close);
        }
    }
}

