/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.config.model.api.Reindexing;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ApplicationReindexing
implements Reindexing {
    private final boolean enabled;
    private final Map<String, Cluster> clusters;

    ApplicationReindexing(boolean enabled, Map<String, Cluster> clusters) {
        this.enabled = enabled;
        this.clusters = Map.copyOf(clusters);
    }

    public static ApplicationReindexing empty() {
        return new ApplicationReindexing(true, Map.of());
    }

    public ApplicationReindexing withReady(String cluster, String documentType, Instant readyAt, double speed) {
        Cluster current = this.clusters.getOrDefault(cluster, Cluster.empty());
        Cluster modified = new Cluster(current.pending, ApplicationReindexing.with(documentType, new Status(readyAt, speed), current.ready));
        return new ApplicationReindexing(this.enabled, ApplicationReindexing.with(cluster, modified, this.clusters));
    }

    public ApplicationReindexing withPending(String cluster, String documentType, long requiredGeneration) {
        Cluster current = this.clusters.getOrDefault(cluster, Cluster.empty());
        Cluster modified = new Cluster(ApplicationReindexing.with(documentType, ApplicationReindexing.requirePositive(requiredGeneration), current.pending), current.ready);
        return new ApplicationReindexing(this.enabled, ApplicationReindexing.with(cluster, modified, this.clusters));
    }

    public ApplicationReindexing withoutPending(String cluster, String documentType) {
        Cluster current = this.clusters.getOrDefault(cluster, Cluster.empty());
        if (current == null) {
            return this;
        }
        Cluster modified = new Cluster(ApplicationReindexing.without(documentType, current.pending), current.ready);
        return new ApplicationReindexing(this.enabled, ApplicationReindexing.with(cluster, modified, this.clusters));
    }

    public ApplicationReindexing without(String cluster) {
        return new ApplicationReindexing(this.enabled, ApplicationReindexing.without(cluster, this.clusters));
    }

    public ApplicationReindexing without(String cluster, String documentType) {
        Cluster current = this.clusters.get(cluster);
        if (current == null) {
            return this;
        }
        Cluster modified = new Cluster(current.pending, ApplicationReindexing.without(documentType, current.ready));
        return new ApplicationReindexing(this.enabled, ApplicationReindexing.with(cluster, modified, this.clusters));
    }

    public ApplicationReindexing enabled(boolean enabled) {
        return new ApplicationReindexing(enabled, this.clusters);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Cluster> clusters() {
        return this.clusters;
    }

    public Optional<Reindexing.Status> status(String clusterName, String documentType) {
        return Optional.ofNullable(this.clusters.get(clusterName)).map(cluster -> cluster.ready().get(documentType));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationReindexing that = (ApplicationReindexing)o;
        return this.enabled == that.enabled && this.clusters.equals(that.clusters);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.clusters);
    }

    public String toString() {
        return "ApplicationReindexing{enabled=" + this.enabled + ", clusters=" + this.clusters + "}";
    }

    private static long requirePositive(long generation) {
        if (generation <= 0L) {
            throw new IllegalArgumentException("Generation must be positive, but was " + generation);
        }
        return generation;
    }

    private static <T> Map<String, T> without(String removed, Map<String, T> map) {
        HashMap<String, T> modified = new HashMap<String, T>(map);
        modified.remove(removed);
        return Map.copyOf(modified);
    }

    private static <T> Map<String, T> with(String added, T value, Map<String, T> map) {
        HashMap<String, T> modified = new HashMap<String, T>(map);
        modified.put(added, value);
        return Map.copyOf(modified);
    }

    public static class Cluster {
        private final Map<String, Long> pending;
        private final Map<String, Status> ready;

        private static Cluster empty() {
            return new Cluster(Map.of(), Map.of());
        }

        Cluster(Map<String, Long> pending, Map<String, Status> ready) {
            this.pending = Map.copyOf(pending);
            this.ready = Map.copyOf(ready);
        }

        public Map<String, Long> pending() {
            return this.pending;
        }

        public Map<String, Status> ready() {
            return this.ready;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cluster cluster = (Cluster)o;
            return this.pending.equals(cluster.pending) && this.ready.equals(cluster.ready);
        }

        public int hashCode() {
            return Objects.hash(this.pending, this.ready);
        }

        public String toString() {
            return "Cluster{pending=" + this.pending + ", ready=" + this.ready + "}";
        }
    }

    public static class Status
    implements Reindexing.Status {
        private final Instant ready;
        private final double speed;

        Status(Instant ready, double speed) {
            if (speed <= 0.0 || 10.0 < speed) {
                throw new IllegalArgumentException("Reindexing speed must be in (0, 10], but was " + speed);
            }
            this.ready = ready.truncatedTo(ChronoUnit.MILLIS);
            this.speed = speed;
        }

        public Instant ready() {
            return this.ready;
        }

        public double speed() {
            return this.speed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return Double.compare(status.speed, this.speed) == 0 && this.ready.equals(status.ready);
        }

        public int hashCode() {
            return Objects.hash(this.ready, this.speed);
        }

        public String toString() {
            return "ready at " + this.ready + ", with relative speed " + this.speed;
        }
    }
}

