/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.concurrent.maintenance.JobControl;
import com.yahoo.concurrent.maintenance.JobControlState;
import com.yahoo.concurrent.maintenance.JobMetrics;
import com.yahoo.concurrent.maintenance.Maintainer;
import com.yahoo.jdisc.Metric;
import com.yahoo.path.Path;
import com.yahoo.transaction.Mutex;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.ListFlag;
import com.yahoo.vespa.flags.PermanentFlags;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class ConfigServerMaintainer
extends Maintainer {
    protected final ApplicationRepository applicationRepository;

    ConfigServerMaintainer(ApplicationRepository applicationRepository, Curator curator, FlagSource flagSource, Instant now, Duration interval, boolean useLock) {
        super(null, interval, now, new JobControl((JobControlState)new JobControlFlags(curator, flagSource, useLock)), (JobMetrics)new ConfigServerJobMetrics(applicationRepository.metric()), ConfigServerMaintainer.cluster(curator), false);
        this.applicationRepository = applicationRepository;
    }

    public static List<String> cluster(Curator curator) {
        return Arrays.stream(curator.zooKeeperEnsembleConnectionSpec().split(",")).filter(hostAndPort -> !hostAndPort.isEmpty()).map(hostAndPort -> hostAndPort.split(":")[0]).collect(Collectors.toList());
    }

    private static class JobControlFlags
    implements JobControlState {
        private static final Path root = Path.fromString((String)"/configserver/v1/");
        private static final Path lockRoot = root.append("locks");
        private final Curator curator;
        private final ListFlag<String> inactiveJobsFlag;
        private final boolean useLock;

        public JobControlFlags(Curator curator, FlagSource flagSource, boolean useLock) {
            this.curator = curator;
            this.inactiveJobsFlag = (ListFlag)PermanentFlags.INACTIVE_MAINTENANCE_JOBS.bindTo(flagSource);
            this.useLock = useLock;
        }

        public Set<String> readInactiveJobs() {
            return Set.copyOf(this.inactiveJobsFlag.value());
        }

        public Mutex lockMaintenanceJob(String job) {
            return this.useLock ? this.curator.lock(lockRoot.append(job), Duration.ofSeconds(1L)) : () -> {};
        }
    }

    private static class ConfigServerJobMetrics
    extends JobMetrics {
        private final Metric metric;

        public ConfigServerJobMetrics(Metric metric) {
            this.metric = metric;
        }

        public void completed(String job, double successFactor) {
            this.metric.set("maintenance.successFactor", (Number)successFactor, this.metric.createContext(Map.of("job", job)));
        }
    }
}

