/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.FileReference;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionUtil;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.FileDistributionConnectionPool;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.filedistribution.FileReferenceData;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.vespa.flags.ListFlag;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ApplicationPackageMaintainer
extends ConfigServerMaintainer {
    private static final Logger log = Logger.getLogger(ApplicationPackageMaintainer.class.getName());
    private final ApplicationRepository applicationRepository;
    private final File downloadDirectory;
    private final ConfigserverConfig configserverConfig;
    private final Supervisor supervisor = new Supervisor(new Transport("filedistribution-pool")).setDropEmptyBuffers(true);
    private final FileDownloader fileDownloader;

    ApplicationPackageMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, FlagSource flagSource) {
        super(applicationRepository, curator, flagSource, applicationRepository.clock().instant(), interval, false);
        this.applicationRepository = applicationRepository;
        this.configserverConfig = applicationRepository.configserverConfig();
        this.downloadDirectory = new File(Defaults.getDefaults().underVespaHome(this.configserverConfig.fileReferencesDir()));
        this.fileDownloader = ApplicationPackageMaintainer.createFileDownloader(this.configserverConfig, this.downloadDirectory, this.supervisor, ((ListFlag)Flags.FILE_DISTRIBUTION_ACCEPTED_COMPRESSION_TYPES.bindTo(flagSource)).value());
    }

    protected double maintain() {
        if (FileDistributionUtil.getOtherConfigServersInCluster(this.configserverConfig).isEmpty()) {
            return 1.0;
        }
        int attempts = 0;
        int failures = 0;
        for (ApplicationId applicationId : this.applicationRepository.listApplications()) {
            FileReference appFileReference;
            log.finest(() -> "Verifying application package for " + applicationId);
            Optional<Session> session = this.applicationRepository.getActiveSession(applicationId);
            if (session.isEmpty() || (appFileReference = session.get().getApplicationPackageReference()) == null) continue;
            long sessionId = session.get().getSessionId();
            ++attempts;
            if (!FileDistributionUtil.fileReferenceExistsOnDisk(this.downloadDirectory, appFileReference)) {
                log.fine(() -> "Downloading application package for " + applicationId + " (session " + sessionId + ")");
                FileReferenceDownload download = new FileReferenceDownload(appFileReference, ((Object)((Object)this)).getClass().getSimpleName(), false);
                if (this.fileDownloader.getFile(download).isEmpty()) {
                    ++failures;
                    log.info("Downloading application package (" + appFileReference + ") for " + applicationId + " (session " + sessionId + ") unsuccessful. Can be ignored unless it happens many times over a long period of time, retries is expected");
                    continue;
                }
            }
            this.createLocalSessionIfMissing(applicationId, sessionId);
        }
        return this.asSuccessFactor(attempts, failures);
    }

    private static FileDownloader createFileDownloader(ConfigserverConfig configserverConfig, File downloadDirectory, Supervisor supervisor, List<String> flagValues) {
        List<String> otherConfigServersInCluster = FileDistributionUtil.getOtherConfigServersInCluster(configserverConfig);
        ConfigSourceSet configSourceSet = new ConfigSourceSet(otherConfigServersInCluster);
        ConnectionPool connectionPool = otherConfigServersInCluster.isEmpty() ? FileDownloader.emptyConnectionPool() : new FileDistributionConnectionPool(configSourceSet, supervisor);
        Set acceptedCompressionTypes = flagValues.stream().map(FileReferenceData.CompressionType::valueOf).collect(Collectors.toSet());
        return new FileDownloader(connectionPool, supervisor, downloadDirectory, Duration.ofSeconds(300L), acceptedCompressionTypes);
    }

    public void awaitShutdown() {
        this.supervisor.transport().shutdown().join();
        this.fileDownloader.close();
        super.awaitShutdown();
    }

    private void createLocalSessionIfMissing(ApplicationId applicationId, long sessionId) {
        Tenant tenant = this.applicationRepository.getTenant(applicationId);
        SessionRepository sessionRepository = tenant.getSessionRepository();
        if (sessionRepository.getLocalSession(sessionId) == null) {
            sessionRepository.createLocalSessionFromDistributedApplicationPackage(sessionId);
        }
    }
}

