/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.annotation.Inject;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.container.jdisc.utils.MultiPartFormParser;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.application.CompressedApplicationInputStream;
import com.yahoo.vespa.config.server.http.BadRequestException;
import com.yahoo.vespa.config.server.http.SessionHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.PrepareResult;
import com.yahoo.vespa.config.server.http.v2.SessionCreateHandler;
import com.yahoo.vespa.config.server.http.v2.response.SessionPrepareAndActivateResponse;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.apache.hc.core5.http.ContentType;

public class ApplicationApiHandler
extends SessionHandler {
    public static final String APPLICATION_X_GZIP = "application/x-gzip";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_PARAMS = "prepareParams";
    public static final String MULTIPART_APPLICATION_PACKAGE = "applicationPackage";
    public static final String contentTypeHeader = "Content-Type";
    private final TenantRepository tenantRepository;
    private final Duration zookeeperBarrierTimeout;
    private final Zone zone;
    private final long maxApplicationPackageSize;

    @Inject
    public ApplicationApiHandler(ThreadedHttpRequestHandler.Context ctx, ApplicationRepository applicationRepository, ConfigserverConfig configserverConfig, Zone zone) {
        super(ctx, applicationRepository);
        this.tenantRepository = applicationRepository.tenantRepository();
        this.zookeeperBarrierTimeout = Duration.ofSeconds(configserverConfig.zookeeper().barrierTimeout());
        this.maxApplicationPackageSize = configserverConfig.maxApplicationPackageSize();
        this.zone = zone;
    }

    @Override
    protected HttpResponse handlePOST(HttpRequest request) {
        CompressedApplicationInputStream compressedStream;
        PrepareParams prepareParams;
        SessionCreateHandler.validateDataAndHeader(request, List.of(APPLICATION_X_GZIP, APPLICATION_ZIP, MULTIPART_FORM_DATA));
        TenantName tenantName = this.validateTenant(request);
        boolean multipartRequest = Optional.ofNullable(request.getHeader(contentTypeHeader)).map(ContentType::parse).map(contentType -> contentType.getMimeType().equalsIgnoreCase(MULTIPART_FORM_DATA)).orElse(false);
        if (multipartRequest) {
            try {
                Map parts = new MultiPartFormParser(request).readParts();
                byte[] params = ((MultiPartFormParser.PartItem)parts.get(MULTIPART_PARAMS)).data().readAllBytes();
                this.log.log(Level.FINE, "Deploy parameters: [{0}]", new String(params, StandardCharsets.UTF_8));
                prepareParams = PrepareParams.fromJson(params, tenantName, this.zookeeperBarrierTimeout);
                MultiPartFormParser.PartItem appPackagePart = (MultiPartFormParser.PartItem)parts.get(MULTIPART_APPLICATION_PACKAGE);
                compressedStream = CompressedApplicationInputStream.createFromCompressedStream(appPackagePart.data(), appPackagePart.contentType(), this.maxApplicationPackageSize);
            }
            catch (IOException e) {
                this.log.log(Level.WARNING, "Unable to parse multipart in deploy", e);
                throw new BadRequestException("Request contains invalid data");
            }
        } else {
            prepareParams = PrepareParams.fromHttpRequest(request, tenantName, this.zookeeperBarrierTimeout);
            compressedStream = CompressedApplicationInputStream.createFromCompressedStream(request.getData(), request.getHeader(contentTypeHeader), this.maxApplicationPackageSize);
        }
        PrepareResult result = this.applicationRepository.deploy(compressedStream, prepareParams);
        return new SessionPrepareAndActivateResponse(result, request, prepareParams.getApplicationId(), this.zone);
    }

    @Override
    public Duration getTimeout() {
        return this.zookeeperBarrierTimeout.plus(Duration.ofSeconds(30L));
    }

    private TenantName validateTenant(HttpRequest request) {
        TenantName tenantName = ApplicationApiHandler.getTenantNameFromRequest(request);
        Utils.checkThatTenantExists(this.tenantRepository, tenantName);
        return tenantName;
    }

    public static TenantName getTenantNameFromRequest(HttpRequest request) {
        BindingMatch<?> bm = Utils.getBindingMatch(request, "http://*/application/v2/tenant/*/prepareandactivate*");
        return TenantName.from((String)bm.group(2));
    }
}

